/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.behaviour;

import eu.fbk.tools.adapter.ui.commands.AbstractToolCommand;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCheckModelCommand
extends AbstractToolCommand {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCheckModelCommand.class);
    protected String behaviourFileName = null;

    public AbstractCheckModelCommand(String commandDescription) {
        super("nuXmv", commandDescription, "tools.nuxmv.executable", "tools.nuxmv.timeout");
    }

    @Override
    protected void initialize() {
        this.behaviourFileName = null;
        super.initialize();
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.behaviourFileName = this.getFileNameParameter(event, "behaviour_model", "smv", "Choose the behaviour model file");
        if (StringUtils.isBlank((CharSequence)this.behaviourFileName)) {
            this.displayError(this.getCommandDescription(), "Behaviour model has not been specified, can't execute the command.");
            logger.error("Behaviour model has not been specified, can't execute the command.");
            return false;
        }
        logger.debug("Set behaviour model to " + this.behaviourFileName);
        return true;
    }
}

