/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.vsl.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.marte.vsl.extensions.VSLContextUtil;
import org.eclipse.papyrus.marte.vsl.scoping.VSLScopeProvider;
import org.eclipse.papyrus.marte.vsl.vSL.AdditiveExpression;
import org.eclipse.papyrus.marte.vsl.vSL.AndOrXorExpression;
import org.eclipse.papyrus.marte.vsl.vSL.BooleanLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.CollectionOrTuple;
import org.eclipse.papyrus.marte.vsl.vSL.ConditionalExpression;
import org.eclipse.papyrus.marte.vsl.vSL.DateTimeLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.DefaultLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.DurationObsExpression;
import org.eclipse.papyrus.marte.vsl.vSL.EqualityExpression;
import org.eclipse.papyrus.marte.vsl.vSL.Expression;
import org.eclipse.papyrus.marte.vsl.vSL.InstantObsExpression;
import org.eclipse.papyrus.marte.vsl.vSL.IntegerLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.Interval;
import org.eclipse.papyrus.marte.vsl.vSL.MultiplicativeExpression;
import org.eclipse.papyrus.marte.vsl.vSL.NameOrChoiceOrBehaviorCall;
import org.eclipse.papyrus.marte.vsl.vSL.NullLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.OperationCallExpression;
import org.eclipse.papyrus.marte.vsl.vSL.PrimaryExpression;
import org.eclipse.papyrus.marte.vsl.vSL.PropertyCallExpression;
import org.eclipse.papyrus.marte.vsl.vSL.RealLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.RelationalExpression;
import org.eclipse.papyrus.marte.vsl.vSL.StringLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.SuffixExpression;
import org.eclipse.papyrus.marte.vsl.vSL.TimeExpression;
import org.eclipse.papyrus.marte.vsl.vSL.Tuple;
import org.eclipse.papyrus.marte.vsl.vSL.UnaryExpression;
import org.eclipse.papyrus.marte.vsl.vSL.UnlimitedLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.VSLPackage;
import org.eclipse.papyrus.marte.vsl.vSL.ValueNamePair;
import org.eclipse.papyrus.marte.vsl.vSL.ValueSpecification;
import org.eclipse.papyrus.marte.vsl.vSL.VariableDeclaration;
import org.eclipse.papyrus.marte.vsl.validation.AbstractVSLJavaValidator;
import org.eclipse.papyrus.marte.vsl.validation.VSLErrorMessage;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class VSLJavaValidator
extends AbstractVSLJavaValidator {
    private static Namespace model;
    private static Element contextElement;
    private static Type expectedType;
    public static Type _integer;
    public static Type _unlimitedNatural;
    public static Type _real;
    public static Type _datetime;
    public static Type _boolean;
    public static Type _string;
    public static Type _nfp_duration;
    public static Map<String, Type> opSignatures;
    public static Map<String, Map<Type, List<Type>>> binaryOpTypeBinding;
    public static Map<String, Type> unaryOpTypeBinding;
    public static VSLJavaValidator eInstance;

    static {
        eInstance = new VSLJavaValidator();
    }

    public static void init(Element _contextElement) {
        contextElement = _contextElement;
        if (contextElement != null) {
            Element elem = contextElement.getOwner();
            while (elem.getOwner() != null) {
                elem = elem.getOwner();
            }
            model = (Namespace)elem;
            boolean typesResolved = false;
            for (Package importedPackage : model.getImportedPackages()) {
                if (typesResolved) continue;
                typesResolved = VSLJavaValidator.initPredefinedTypes(importedPackage);
            }
            if (typesResolved) {
                VSLJavaValidator.initPredefinedOpSignatures();
            }
        }
    }

    private static boolean initPredefinedTypes(Package typeLibrary) {
        for (Element elem : typeLibrary.allOwnedElements()) {
            if (!(elem instanceof Type)) continue;
            Type t = (Type)elem;
            if (t.getQualifiedName().equals("MARTE_Library::MARTE_PrimitivesTypes::Boolean")) {
                _boolean = t;
                continue;
            }
            if (t.getQualifiedName().equals("MARTE_Library::MARTE_PrimitivesTypes::Integer")) {
                _integer = t;
                continue;
            }
            if (t.getQualifiedName().equals("MARTE_Library::MARTE_PrimitivesTypes::String")) {
                _string = t;
                continue;
            }
            if (t.getQualifiedName().equals("MARTE_Library::MARTE_PrimitivesTypes::UnlimitedNatural")) {
                _unlimitedNatural = t;
                continue;
            }
            if (t.getQualifiedName().equals("MARTE_Library::MARTE_PrimitivesTypes::Real")) {
                _real = t;
                continue;
            }
            if (t.getQualifiedName().equals("MARTE_Library::MARTE_PrimitivesTypes::DateTime")) {
                _datetime = t;
                continue;
            }
            if (!t.getQualifiedName().equals("MARTE_Library::BasicNFP_Types::NFP_Duration")) continue;
            _nfp_duration = t;
        }
        return _integer != null && _unlimitedNatural != null && _real != null && _datetime != null && _boolean != null && _string != null && _nfp_duration != null;
    }

    private static void initPredefinedOpSignatures() {
        opSignatures = new HashMap<String, Type>();
        unaryOpTypeBinding = new HashMap<String, Type>();
        binaryOpTypeBinding = new HashMap<String, Map<Type, List<Type>>>();
        unaryOpTypeBinding.put("+", _integer);
        unaryOpTypeBinding.put("+", _real);
        unaryOpTypeBinding.put("-", _integer);
        unaryOpTypeBinding.put("-", _real);
        unaryOpTypeBinding.put("not", _boolean);
        opSignatures.put("+(" + _integer.getName() + ")", _integer);
        opSignatures.put("+(" + _real.getName() + ")", _real);
        opSignatures.put("-(" + _integer.getName() + ")", _integer);
        opSignatures.put("-(" + _real.getName() + ")", _real);
        opSignatures.put("not(" + _boolean.getName() + ")", _boolean);
        binaryOpTypeBinding.put("and", new HashMap());
        binaryOpTypeBinding.put("or", new HashMap());
        binaryOpTypeBinding.put("xor", new HashMap());
        binaryOpTypeBinding.put("==", new HashMap());
        binaryOpTypeBinding.put("<>", new HashMap());
        binaryOpTypeBinding.put("<", new HashMap());
        binaryOpTypeBinding.put(">", new HashMap());
        binaryOpTypeBinding.put("<=", new HashMap());
        binaryOpTypeBinding.put(">=", new HashMap());
        binaryOpTypeBinding.put("*", new HashMap());
        binaryOpTypeBinding.put("/", new HashMap());
        binaryOpTypeBinding.put("mod", new HashMap());
        binaryOpTypeBinding.put("+", new HashMap());
        binaryOpTypeBinding.put("-", new HashMap());
        opSignatures.put("and(" + _boolean.getName() + ',' + _boolean.getName() + ")", _boolean);
        opSignatures.put("or(" + _boolean.getName() + ',' + _boolean.getName() + ")", _boolean);
        opSignatures.put("xor(" + _boolean.getName() + ',' + _boolean.getName() + ")", _boolean);
        binaryOpTypeBinding.get("and").put(_boolean, new ArrayList());
        binaryOpTypeBinding.get("or").put(_boolean, new ArrayList());
        binaryOpTypeBinding.get("xor").put(_boolean, new ArrayList());
        binaryOpTypeBinding.get("and").get(_boolean).add(_boolean);
        binaryOpTypeBinding.get("or").get(_boolean).add(_boolean);
        binaryOpTypeBinding.get("xor").get(_boolean).add(_boolean);
        opSignatures.put("==(" + _integer.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put("==(" + _real.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put("==(" + _integer.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put("==(" + _real.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put("==(" + _real.getName() + ',' + _nfp_duration.getName() + ")", _boolean);
        opSignatures.put("==(" + _boolean.getName() + ',' + _boolean.getName() + ")", _boolean);
        opSignatures.put("==(" + _string.getName() + ',' + _string.getName() + ")", _boolean);
        opSignatures.put("==(" + _datetime.getName() + ',' + _datetime.getName() + ")", _boolean);
        opSignatures.put("<>(" + _integer.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put("<>(" + _real.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put("<>(" + _integer.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put("<>(" + _real.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put("<>(" + _real.getName() + ',' + _nfp_duration.getName() + ")", _boolean);
        opSignatures.put("<>(" + _boolean.getName() + ',' + _boolean.getName() + ")", _boolean);
        opSignatures.put("<>(" + _string.getName() + ',' + _string.getName() + ")", _boolean);
        opSignatures.put("<>(" + _datetime.getName() + ',' + _datetime.getName() + ")", _boolean);
        binaryOpTypeBinding.get("==").put(_integer, new ArrayList());
        binaryOpTypeBinding.get("==").put(_real, new ArrayList());
        binaryOpTypeBinding.get("==").put(_boolean, new ArrayList());
        binaryOpTypeBinding.get("==").put(_string, new ArrayList());
        binaryOpTypeBinding.get("==").put(_datetime, new ArrayList());
        binaryOpTypeBinding.get("==").get(_integer).add(_integer);
        binaryOpTypeBinding.get("==").get(_integer).add(_real);
        binaryOpTypeBinding.get("==").get(_real).add(_real);
        binaryOpTypeBinding.get("==").get(_real).add(_integer);
        binaryOpTypeBinding.get("==").get(_real).add(_nfp_duration);
        binaryOpTypeBinding.get("==").get(_datetime).add(_datetime);
        binaryOpTypeBinding.get("==").get(_boolean).add(_boolean);
        binaryOpTypeBinding.get("==").get(_string).add(_string);
        binaryOpTypeBinding.get("<>").put(_integer, new ArrayList());
        binaryOpTypeBinding.get("<>").put(_real, new ArrayList());
        binaryOpTypeBinding.get("<>").put(_boolean, new ArrayList());
        binaryOpTypeBinding.get("<>").put(_string, new ArrayList());
        binaryOpTypeBinding.get("<>").put(_datetime, new ArrayList());
        binaryOpTypeBinding.get("<>").get(_integer).add(_integer);
        binaryOpTypeBinding.get("<>").get(_integer).add(_real);
        binaryOpTypeBinding.get("<>").get(_real).add(_real);
        binaryOpTypeBinding.get("<>").get(_real).add(_integer);
        binaryOpTypeBinding.get("<>").get(_real).add(_nfp_duration);
        binaryOpTypeBinding.get("<>").get(_datetime).add(_datetime);
        binaryOpTypeBinding.get("<>").get(_boolean).add(_boolean);
        binaryOpTypeBinding.get("<>").get(_string).add(_string);
        opSignatures.put("<(" + _integer.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put("<(" + _real.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put("<(" + _integer.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put("<(" + _real.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put("<(" + _string.getName() + ',' + _string.getName() + ")", _boolean);
        opSignatures.put("<(" + _nfp_duration.getName() + ',' + _nfp_duration.getName() + ")", _boolean);
        opSignatures.put("<(" + _real.getName() + ',' + _nfp_duration.getName() + ")", _boolean);
        opSignatures.put("<(" + _datetime.getName() + ',' + _datetime.getName() + ")", _boolean);
        opSignatures.put(">(" + _integer.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put(">(" + _real.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put(">(" + _integer.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put(">(" + _real.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put(">(" + _nfp_duration.getName() + ',' + _nfp_duration.getName() + ")", _boolean);
        opSignatures.put(">(" + _real.getName() + ',' + _nfp_duration.getName() + ")", _boolean);
        opSignatures.put(">(" + _string.getName() + ',' + _string.getName() + ")", _boolean);
        opSignatures.put(">(" + _datetime.getName() + ',' + _datetime.getName() + ")", _boolean);
        opSignatures.put("<=(" + _integer.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put("<=(" + _real.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put("<=(" + _integer.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put("<=(" + _real.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put("<=(" + _string.getName() + ',' + _string.getName() + ")", _boolean);
        opSignatures.put("<=(" + _nfp_duration.getName() + ',' + _nfp_duration.getName() + ")", _boolean);
        opSignatures.put("<=(" + _real.getName() + ',' + _nfp_duration.getName() + ")", _boolean);
        opSignatures.put("<=(" + _datetime.getName() + ',' + _datetime.getName() + ")", _boolean);
        opSignatures.put(">=(" + _integer.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put(">=(" + _real.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put(">=(" + _integer.getName() + ',' + _real.getName() + ")", _boolean);
        opSignatures.put(">=(" + _real.getName() + ',' + _integer.getName() + ")", _boolean);
        opSignatures.put(">=(" + _string.getName() + ',' + _string.getName() + ")", _boolean);
        opSignatures.put(">=(" + _nfp_duration.getName() + ',' + _nfp_duration.getName() + ")", _boolean);
        opSignatures.put(">=(" + _real.getName() + ',' + _nfp_duration.getName() + ")", _boolean);
        opSignatures.put(">=(" + _datetime.getName() + ',' + _datetime.getName() + ")", _boolean);
        binaryOpTypeBinding.get("<").put(_integer, new ArrayList());
        binaryOpTypeBinding.get("<").put(_real, new ArrayList());
        binaryOpTypeBinding.get("<").put(_string, new ArrayList());
        binaryOpTypeBinding.get("<").put(_nfp_duration, new ArrayList());
        binaryOpTypeBinding.get("<").put(_datetime, new ArrayList());
        binaryOpTypeBinding.get("<").get(_integer).add(_integer);
        binaryOpTypeBinding.get("<").get(_integer).add(_real);
        binaryOpTypeBinding.get("<").get(_real).add(_real);
        binaryOpTypeBinding.get("<").get(_real).add(_integer);
        binaryOpTypeBinding.get("<").get(_real).add(_nfp_duration);
        binaryOpTypeBinding.get("<").get(_nfp_duration).add(_nfp_duration);
        binaryOpTypeBinding.get("<").get(_string).add(_string);
        binaryOpTypeBinding.get("<").get(_datetime).add(_datetime);
        binaryOpTypeBinding.get(">").put(_integer, new ArrayList());
        binaryOpTypeBinding.get(">").put(_real, new ArrayList());
        binaryOpTypeBinding.get(">").put(_string, new ArrayList());
        binaryOpTypeBinding.get(">").put(_nfp_duration, new ArrayList());
        binaryOpTypeBinding.get(">").put(_datetime, new ArrayList());
        binaryOpTypeBinding.get(">").get(_integer).add(_integer);
        binaryOpTypeBinding.get(">").get(_integer).add(_real);
        binaryOpTypeBinding.get(">").get(_real).add(_real);
        binaryOpTypeBinding.get(">").get(_real).add(_integer);
        binaryOpTypeBinding.get(">").get(_real).add(_nfp_duration);
        binaryOpTypeBinding.get(">").get(_nfp_duration).add(_nfp_duration);
        binaryOpTypeBinding.get(">").get(_string).add(_string);
        binaryOpTypeBinding.get(">").get(_datetime).add(_datetime);
        binaryOpTypeBinding.get("<=").put(_integer, new ArrayList());
        binaryOpTypeBinding.get("<=").put(_real, new ArrayList());
        binaryOpTypeBinding.get("<=").put(_string, new ArrayList());
        binaryOpTypeBinding.get("<=").put(_nfp_duration, new ArrayList());
        binaryOpTypeBinding.get("<=").put(_datetime, new ArrayList());
        binaryOpTypeBinding.get("<=").get(_integer).add(_integer);
        binaryOpTypeBinding.get("<=").get(_integer).add(_real);
        binaryOpTypeBinding.get("<=").get(_real).add(_real);
        binaryOpTypeBinding.get("<=").get(_real).add(_integer);
        binaryOpTypeBinding.get("<=").get(_real).add(_nfp_duration);
        binaryOpTypeBinding.get("<=").get(_nfp_duration).add(_nfp_duration);
        binaryOpTypeBinding.get("<=").get(_string).add(_string);
        binaryOpTypeBinding.get("<=").get(_datetime).add(_datetime);
        binaryOpTypeBinding.get(">=").put(_integer, new ArrayList());
        binaryOpTypeBinding.get(">=").put(_real, new ArrayList());
        binaryOpTypeBinding.get(">=").put(_string, new ArrayList());
        binaryOpTypeBinding.get(">=").put(_nfp_duration, new ArrayList());
        binaryOpTypeBinding.get(">=").put(_datetime, new ArrayList());
        binaryOpTypeBinding.get(">=").get(_integer).add(_integer);
        binaryOpTypeBinding.get(">=").get(_integer).add(_real);
        binaryOpTypeBinding.get(">=").get(_real).add(_real);
        binaryOpTypeBinding.get(">=").get(_real).add(_integer);
        binaryOpTypeBinding.get(">=").get(_real).add(_nfp_duration);
        binaryOpTypeBinding.get(">=").get(_nfp_duration).add(_nfp_duration);
        binaryOpTypeBinding.get(">=").get(_string).add(_string);
        binaryOpTypeBinding.get(">=").get(_datetime).add(_datetime);
        opSignatures.put("*(" + _integer.getName() + ',' + _integer.getName() + ")", _integer);
        opSignatures.put("*(" + _real.getName() + ',' + _real.getName() + ")", _real);
        opSignatures.put("*(" + _real.getName() + ',' + _integer.getName() + ")", _real);
        opSignatures.put("*(" + _integer.getName() + ',' + _real.getName() + ")", _real);
        opSignatures.put("/(" + _integer.getName() + ',' + _integer.getName() + ")", _integer);
        opSignatures.put("/(" + _real.getName() + ',' + _real.getName() + ")", _real);
        opSignatures.put("/(" + _real.getName() + ',' + _integer.getName() + ")", _real);
        opSignatures.put("/(" + _integer.getName() + ',' + _real.getName() + ")", _real);
        opSignatures.put("mod(" + _integer.getName() + ',' + _integer.getName() + ")", _integer);
        binaryOpTypeBinding.get("*").put(_integer, new ArrayList());
        binaryOpTypeBinding.get("*").put(_real, new ArrayList());
        binaryOpTypeBinding.get("*").get(_integer).add(_integer);
        binaryOpTypeBinding.get("*").get(_integer).add(_real);
        binaryOpTypeBinding.get("*").get(_real).add(_real);
        binaryOpTypeBinding.get("*").get(_real).add(_integer);
        binaryOpTypeBinding.get("/").put(_integer, new ArrayList());
        binaryOpTypeBinding.get("/").put(_real, new ArrayList());
        binaryOpTypeBinding.get("/").get(_integer).add(_integer);
        binaryOpTypeBinding.get("/").get(_integer).add(_real);
        binaryOpTypeBinding.get("/").get(_real).add(_real);
        binaryOpTypeBinding.get("/").get(_real).add(_integer);
        binaryOpTypeBinding.get("mod").put(_integer, new ArrayList());
        binaryOpTypeBinding.get("mod").get(_integer).add(_integer);
        opSignatures.put("+(" + _integer.getName() + ',' + _integer.getName() + ")", _integer);
        opSignatures.put("+(" + _real.getName() + ',' + _real.getName() + ")", _real);
        opSignatures.put("+(" + _real.getName() + ',' + _integer.getName() + ")", _real);
        opSignatures.put("+(" + _integer.getName() + ',' + _real.getName() + ")", _real);
        opSignatures.put("+(" + _datetime.getName() + ',' + _real.getName() + ")", _datetime);
        opSignatures.put("+(" + _datetime.getName() + ',' + _nfp_duration.getName() + ")", _datetime);
        opSignatures.put("+(" + _nfp_duration.getName() + ',' + _nfp_duration.getName() + ")", _nfp_duration);
        opSignatures.put("+(" + _real.getName() + ',' + _datetime.getName() + ")", _datetime);
        opSignatures.put("-(" + _integer.getName() + ',' + _integer.getName() + ")", _integer);
        opSignatures.put("-(" + _real.getName() + ',' + _real.getName() + ")", _real);
        opSignatures.put("-(" + _real.getName() + ',' + _integer.getName() + ")", _real);
        opSignatures.put("-(" + _integer.getName() + ',' + _real.getName() + ")", _real);
        opSignatures.put("-(" + _datetime.getName() + ',' + _datetime.getName() + ")", _real);
        opSignatures.put("-(" + _datetime.getName() + ',' + _nfp_duration.getName() + ")", _datetime);
        opSignatures.put("-(" + _nfp_duration.getName() + ',' + _nfp_duration.getName() + ")", _nfp_duration);
        binaryOpTypeBinding.get("+").put(_integer, new ArrayList());
        binaryOpTypeBinding.get("+").put(_real, new ArrayList());
        binaryOpTypeBinding.get("+").put(_datetime, new ArrayList());
        binaryOpTypeBinding.get("+").put(_nfp_duration, new ArrayList());
        binaryOpTypeBinding.get("+").get(_integer).add(_integer);
        binaryOpTypeBinding.get("+").get(_integer).add(_real);
        binaryOpTypeBinding.get("+").get(_real).add(_real);
        binaryOpTypeBinding.get("+").get(_real).add(_integer);
        binaryOpTypeBinding.get("+").get(_real).add(_datetime);
        binaryOpTypeBinding.get("+").get(_datetime).add(_real);
        binaryOpTypeBinding.get("+").get(_datetime).add(_nfp_duration);
        binaryOpTypeBinding.get("+").get(_nfp_duration).add(_nfp_duration);
        binaryOpTypeBinding.get("-").put(_integer, new ArrayList());
        binaryOpTypeBinding.get("-").put(_real, new ArrayList());
        binaryOpTypeBinding.get("-").put(_datetime, new ArrayList());
        binaryOpTypeBinding.get("-").put(_nfp_duration, new ArrayList());
        binaryOpTypeBinding.get("-").get(_integer).add(_integer);
        binaryOpTypeBinding.get("-").get(_integer).add(_real);
        binaryOpTypeBinding.get("-").get(_real).add(_real);
        binaryOpTypeBinding.get("-").get(_real).add(_integer);
        binaryOpTypeBinding.get("-").get(_datetime).add(_datetime);
        binaryOpTypeBinding.get("-").get(_datetime).add(_nfp_duration);
        binaryOpTypeBinding.get("-").get(_nfp_duration).add(_nfp_duration);
    }

    public static void setExpectedType(Type _expectedType) {
        expectedType = _expectedType;
    }

    public static Type getExpectedType() {
        return expectedType;
    }

    public static Namespace getModel() {
        return model;
    }

    public static Element getContextElement() {
        return contextElement;
    }

    public VSLValidationResult checkBinaryExpression(VSLValidationResult[] validationResults, EList<String> operators) {
        String operator = (String)operators.get(0);
        EAttribute potentialErrorFeature = null;
        EObject potentialErrorSource = validationResults[1].validatedRule();
        if (operator.equals("+") || operator.equals("-")) {
            potentialErrorFeature = VSLPackage.eINSTANCE.getAdditiveExpression_Op();
            while (potentialErrorSource != null && !(potentialErrorSource instanceof AdditiveExpression)) {
                potentialErrorSource = potentialErrorSource.eContainer();
            }
        } else if (operator.equals("*") || operator.equals("/") || operator.equals("mod")) {
            potentialErrorFeature = VSLPackage.eINSTANCE.getMultiplicativeExpression_Op();
            while (potentialErrorSource != null && !(potentialErrorSource instanceof MultiplicativeExpression)) {
                potentialErrorSource = potentialErrorSource.eContainer();
            }
        } else if (operator.equals("==") || operator.equals("<>")) {
            potentialErrorFeature = VSLPackage.eINSTANCE.getEqualityExpression_Op();
            while (potentialErrorSource != null && !(potentialErrorSource instanceof EqualityExpression)) {
                potentialErrorSource = potentialErrorSource.eContainer();
            }
        } else if (operator.equals("and") || operator.equals("or") || operator.equals("xor")) {
            potentialErrorFeature = VSLPackage.eINSTANCE.getAndOrXorExpression_Op();
            while (potentialErrorSource != null && !(potentialErrorSource instanceof AndOrXorExpression)) {
                potentialErrorSource = potentialErrorSource.eContainer();
            }
        } else {
            potentialErrorFeature = VSLPackage.eINSTANCE.getRelationalExpression_Op();
            while (potentialErrorSource != null && !(potentialErrorSource instanceof RelationalExpression)) {
                potentialErrorSource = potentialErrorSource.eContainer();
            }
        }
        VSLValidationResult validationResult = new VSLValidationResult(potentialErrorSource, (EStructuralFeature)potentialErrorFeature, validationResults[0].inferedType(), false, "");
        int i = 1;
        while (i < validationResults.length) {
            Type inferedType = this.findReturnTypeOfBinaryOperator((String)operators.get(i - 1), validationResult.inferedType(), validationResults[i].inferedType());
            if (inferedType == null) {
                String errorMessage = VSLErrorMessage.getUndefinedBinaryOperatorSignatureMessage((String)operators.get(i - 1), validationResult.inferedType().getName(), validationResults[i].inferedType().getName());
                return new VSLValidationResult(potentialErrorSource, (EStructuralFeature)potentialErrorFeature, null, true, errorMessage);
            }
            validationResult = new VSLValidationResult(potentialErrorSource, (EStructuralFeature)potentialErrorFeature, inferedType, false, "");
            ++i;
        }
        return validationResult;
    }

    private Type findReturnTypeOfBinaryOperator(String operator, Type firstOperandType, Type secondOperandType) {
        String signature = operator + "(" + firstOperandType.getName() + ',' + secondOperandType.getName() + ")";
        return opSignatures.get(signature);
    }

    private Type findReturnTypeOfUnaryOperator(String operator, Type operandType) {
        String signature = operator + "(" + operandType.getName() + ")";
        return opSignatures.get(signature);
    }

    public VSLValidationResult checkExpressionRule(Expression exp) {
        return this.checkAndOrXorExpression(exp.getExp());
    }

    public VSLValidationResult checkAndOrXorExpression(AndOrXorExpression exp) {
        if (exp.getExp().size() == 1) {
            return eInstance.checkEqualityExpression((EqualityExpression)exp.getExp().get(0));
        }
        boolean errorFound = false;
        int errorIndex = 0;
        VSLValidationResult[] validationResults = new VSLValidationResult[exp.getExp().size()];
        int i = 0;
        while (i < exp.getExp().size() && !errorFound) {
            validationResults[i] = eInstance.checkEqualityExpression((EqualityExpression)exp.getExp().get(i));
            errorFound = validationResults[i].errorFound();
            errorIndex = i++;
        }
        if (errorFound) {
            return validationResults[errorIndex];
        }
        return eInstance.checkBinaryExpression(validationResults, exp.getOp());
    }

    public VSLValidationResult checkEqualityExpression(EqualityExpression exp) {
        if (exp.getExp().size() == 1) {
            return eInstance.checkRelationalExpression((RelationalExpression)exp.getExp().get(0));
        }
        boolean errorFound = false;
        int errorIndex = 0;
        VSLValidationResult[] validationResults = new VSLValidationResult[exp.getExp().size()];
        int i = 0;
        while (i < exp.getExp().size() && !errorFound) {
            validationResults[i] = eInstance.checkRelationalExpression((RelationalExpression)exp.getExp().get(i));
            errorFound = validationResults[i].errorFound();
            errorIndex = i++;
        }
        if (errorFound) {
            return validationResults[errorIndex];
        }
        return eInstance.checkBinaryExpression(validationResults, exp.getOp());
    }

    public VSLValidationResult checkRelationalExpression(RelationalExpression exp) {
        if (exp.getExp().size() == 1) {
            return eInstance.checkConditionalExpression((ConditionalExpression)exp.getExp().get(0));
        }
        boolean errorFound = false;
        int errorIndex = 0;
        VSLValidationResult[] validationResults = new VSLValidationResult[exp.getExp().size()];
        int i = 0;
        while (i < exp.getExp().size() && !errorFound) {
            validationResults[i] = eInstance.checkConditionalExpression((ConditionalExpression)exp.getExp().get(i));
            errorFound = validationResults[i].errorFound();
            errorIndex = i++;
        }
        if (errorFound) {
            return validationResults[errorIndex];
        }
        return eInstance.checkBinaryExpression(validationResults, exp.getOp());
    }

    public VSLValidationResult checkConditionalExpression(ConditionalExpression exp) {
        Type elseType;
        if (exp.getExp().size() == 1) {
            return eInstance.checkAdditiveExpression((AdditiveExpression)exp.getExp().get(0));
        }
        if (exp.getExp().size() != 3) {
            String errorMessage = VSLErrorMessage.getInvalidNumberOfExpressionsInConditionalExpression();
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getConditionalExpression_Exp(), null, true, errorMessage);
        }
        VSLValidationResult conditionValiditionResult = this.checkAdditiveExpression((AdditiveExpression)exp.getExp().get(0));
        if (conditionValiditionResult.errorFound()) {
            return conditionValiditionResult;
        }
        if (conditionValiditionResult.inferedType() != null && !conditionValiditionResult.inferedType().conformsTo(_boolean)) {
            String errorMessage = VSLErrorMessage.getInvalidExpressionType("Boolean", conditionValiditionResult.inferedType().getName());
            conditionValiditionResult.errorFound = true;
            conditionValiditionResult.errorMessage = errorMessage;
            return conditionValiditionResult;
        }
        VSLValidationResult thenValidationResult = this.checkAdditiveExpression((AdditiveExpression)exp.getExp().get(1));
        VSLValidationResult elseValidationResult = this.checkAdditiveExpression((AdditiveExpression)exp.getExp().get(2));
        if (thenValidationResult.errorFound()) {
            return thenValidationResult;
        }
        if (elseValidationResult.errorFound()) {
            return elseValidationResult;
        }
        Type thenType = thenValidationResult.inferedType();
        if (thenType == (elseType = elseValidationResult.inferedType())) {
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getConditionalExpression_Exp(), thenType, false, "");
        }
        if (thenType.conformsTo(elseType)) {
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getConditionalExpression_Exp(), elseType, false, "");
        }
        if (elseType.conformsTo(thenType)) {
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getConditionalExpression_Exp(), thenType, false, "");
        }
        String errorMessage = VSLErrorMessage.getInvalidExpressionType(thenType.getName(), elseType.getName());
        return new VSLValidationResult((EObject)exp.getExp().get(2), (EStructuralFeature)VSLPackage.eINSTANCE.getAdditiveExpression_Exp(), elseType, true, errorMessage);
    }

    public VSLValidationResult checkAdditiveExpression(AdditiveExpression exp) {
        if (exp.getExp().size() == 1) {
            return eInstance.checkMultiplicativeExpression((MultiplicativeExpression)exp.getExp().get(0));
        }
        boolean errorFound = false;
        int errorIndex = 0;
        VSLValidationResult[] validationResults = new VSLValidationResult[exp.getExp().size()];
        int i = 0;
        while (i < exp.getExp().size() && !errorFound) {
            validationResults[i] = eInstance.checkMultiplicativeExpression((MultiplicativeExpression)exp.getExp().get(i));
            errorFound = validationResults[i].errorFound();
            errorIndex = i++;
        }
        if (errorFound) {
            return validationResults[errorIndex];
        }
        return eInstance.checkBinaryExpression(validationResults, exp.getOp());
    }

    public VSLValidationResult checkMultiplicativeExpression(MultiplicativeExpression exp) {
        if (exp.getExp().size() == 0) {
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getMultiplicativeExpression_Exp(), null, false, "");
        }
        if (exp.getExp().size() == 1) {
            return eInstance.checkUnaryExpression((UnaryExpression)exp.getExp().get(0));
        }
        boolean errorFound = false;
        int errorIndex = 0;
        VSLValidationResult[] validationResults = new VSLValidationResult[exp.getExp().size()];
        int i = 0;
        while (i < exp.getExp().size() && !errorFound) {
            validationResults[i] = eInstance.checkUnaryExpression((UnaryExpression)exp.getExp().get(i));
            errorFound = validationResults[i].errorFound();
            errorIndex = i++;
        }
        if (errorFound) {
            return validationResults[errorIndex];
        }
        return eInstance.checkBinaryExpression(validationResults, exp.getOp());
    }

    public VSLValidationResult checkUnaryExpression(UnaryExpression exp) {
        Type inferedType = null;
        if (exp.getUnary() != null) {
            VSLValidationResult nestedUnaryValidationResult = eInstance.checkUnaryExpression(exp.getUnary());
            if (nestedUnaryValidationResult.errorFound()) {
                return nestedUnaryValidationResult;
            }
            inferedType = this.findReturnTypeOfUnaryOperator(exp.getOp(), nestedUnaryValidationResult.inferedType());
            if (inferedType == null) {
                String errorMessage = VSLErrorMessage.getUndefinedUnaryOperatorSignatureMessage(exp.getOp(), nestedUnaryValidationResult.inferedType.getName());
                return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getUnaryExpression_Op(), null, true, errorMessage);
            }
        } else if (exp.getExp() != null) {
            VSLValidationResult nestedPrimaryValidationResult = eInstance.checkPrimaryExpression(exp.getExp());
            if (nestedPrimaryValidationResult.errorFound()) {
                return nestedPrimaryValidationResult;
            }
            inferedType = nestedPrimaryValidationResult.inferedType();
        }
        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getUnaryExpression_Exp(), inferedType, false, "");
    }

    public VSLValidationResult checkPrimaryExpression(PrimaryExpression exp) {
        Type inferedType = null;
        VSLValidationResult prefixValidationResult = eInstance.checkValueSpecification(exp.getPrefix());
        if (prefixValidationResult.errorFound()) {
            return prefixValidationResult;
        }
        inferedType = prefixValidationResult.inferedType();
        if (exp.getSuffix() != null) {
            VSLValidationResult suffixValidationResult = eInstance.checkSuffixExpression(exp.getSuffix());
            if (suffixValidationResult.errorFound()) {
                return suffixValidationResult;
            }
            inferedType = suffixValidationResult.inferedType();
        }
        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getPrimaryExpression_Prefix(), inferedType, false, "");
    }

    public VSLValidationResult checkValueSpecification(ValueSpecification valueSpec) {
        Type inferedType = null;
        EAttribute feature = null;
        if (valueSpec instanceof IntegerLiteralRule) {
            inferedType = _integer;
            feature = VSLPackage.eINSTANCE.getLiteral_Value();
        } else if (valueSpec instanceof UnlimitedLiteralRule) {
            inferedType = _unlimitedNatural;
            feature = VSLPackage.eINSTANCE.getLiteral_Value();
        } else if (valueSpec instanceof RealLiteralRule) {
            inferedType = _real;
            feature = VSLPackage.eINSTANCE.getLiteral_Value();
        } else if (valueSpec instanceof DateTimeLiteralRule) {
            inferedType = _datetime;
            feature = VSLPackage.eINSTANCE.getLiteral_Value();
        } else if (valueSpec instanceof BooleanLiteralRule) {
            inferedType = _boolean;
            feature = VSLPackage.eINSTANCE.getLiteral_Value();
        } else if (valueSpec instanceof StringLiteralRule) {
            inferedType = _string;
            feature = VSLPackage.eINSTANCE.getLiteral_Value();
        } else if (valueSpec instanceof NullLiteralRule) {
            VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
            ((Object)((Object)vSLScopeProvider)).getClass();
            VSLScopeProvider.ScopingHelper scopingHelper = vSLScopeProvider.new VSLScopeProvider.ScopingHelper(valueSpec);
            inferedType = scopingHelper.getClassifierForScoping();
            feature = VSLPackage.eINSTANCE.getLiteral_Value();
        } else if (valueSpec instanceof DefaultLiteralRule) {
            VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
            ((Object)((Object)vSLScopeProvider)).getClass();
            VSLScopeProvider.ScopingHelper scopingHelper = vSLScopeProvider.new VSLScopeProvider.ScopingHelper(valueSpec);
            inferedType = scopingHelper.getClassifierForScoping();
            feature = VSLPackage.eINSTANCE.getLiteral_Value();
        } else {
            if (valueSpec instanceof NameOrChoiceOrBehaviorCall) {
                return this.checkNameOrChoiceOrBehaviorCall((NameOrChoiceOrBehaviorCall)valueSpec);
            }
            if (valueSpec instanceof Interval) {
                return this.checkInterval((Interval)valueSpec);
            }
            if (valueSpec instanceof CollectionOrTuple) {
                return this.checkCollectionOrTuple((CollectionOrTuple)valueSpec);
            }
            if (valueSpec instanceof Tuple) {
                return this.checkTuple((Tuple)valueSpec);
            }
            if (valueSpec instanceof TimeExpression) {
                return this.checkTimeExpression((TimeExpression)valueSpec);
            }
            if (valueSpec instanceof VariableDeclaration) {
                return this.checkVariableDeclarion((VariableDeclaration)valueSpec);
            }
            if (valueSpec instanceof Expression) {
                return this.checkExpressionRule((Expression)valueSpec);
            }
        }
        return new VSLValidationResult(valueSpec, (EStructuralFeature)feature, inferedType, false, "");
    }

    public VSLValidationResult checkVariableDeclarion(VariableDeclaration valueSpec) {
        DataType dataType;
        if (valueSpec.getType() != null) {
            dataType = valueSpec.getType().getType();
        } else {
            VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
            ((Object)((Object)vSLScopeProvider)).getClass();
            dataType = vSLScopeProvider.new VSLScopeProvider.ScopingHelper(valueSpec).getClassifierForScoping();
        }
        DataType inferedType = dataType;
        VSLValidationResult initValidationResult = null;
        if (valueSpec.getInitValue() != null) {
            initValidationResult = this.checkExpressionRule(valueSpec.getInitValue());
        }
        if (initValidationResult != null && initValidationResult.errorFound()) {
            return initValidationResult;
        }
        if (initValidationResult != null && initValidationResult.inferedType() != inferedType && !((Classifier)initValidationResult.inferedType()).getGenerals().contains((Object)inferedType)) {
            String errorMessage = VSLErrorMessage.getInvalidExpressionType(inferedType.getName(), initValidationResult.inferedType.getName());
            return new VSLValidationResult(valueSpec, (EStructuralFeature)VSLPackage.eINSTANCE.getVariableDeclaration_InitValue(), initValidationResult.inferedType(), true, errorMessage);
        }
        return new VSLValidationResult(valueSpec, (EStructuralFeature)VSLPackage.eINSTANCE.getVariableDeclaration_Name(), (Type)inferedType, false, "");
    }

    public VSLValidationResult checkTimeExpression(TimeExpression valueSpec) {
        Classifier locallyInferedType;
        Expression index = null;
        Expression condition = null;
        Type inferedType = _real;
        EReference mainFeature = null;
        EReference indexFeature = null;
        EReference conditionFeature = null;
        if (valueSpec instanceof InstantObsExpression) {
            mainFeature = VSLPackage.eINSTANCE.getInstantObsExpression_Id();
            inferedType = _datetime;
            InstantObsExpression instantObs = (InstantObsExpression)valueSpec;
            index = instantObs.getIndex();
            indexFeature = VSLPackage.eINSTANCE.getInstantObsExpression_Index();
            condition = instantObs.getCondition();
            conditionFeature = VSLPackage.eINSTANCE.getInstantObsExpression_Condition();
        } else if (valueSpec instanceof DurationObsExpression) {
            mainFeature = VSLPackage.eINSTANCE.getDurationObsExpression_Id();
            inferedType = _real;
            DurationObsExpression durationObs = (DurationObsExpression)valueSpec;
            index = durationObs.getIndex();
            indexFeature = VSLPackage.eINSTANCE.getDurationObsExpression_Index();
            condition = durationObs.getCondition();
            conditionFeature = VSLPackage.eINSTANCE.getDurationObsExpression_Condition();
        }
        if (index != null) {
            VSLValidationResult checkIndex = this.checkExpressionRule(index);
            if (checkIndex.errorFound()) {
                return checkIndex;
            }
            locallyInferedType = (Classifier)checkIndex.inferedType();
            if (locallyInferedType != _integer && !locallyInferedType.getGenerals().contains((Object)_integer) && !locallyInferedType.getName().equals(_integer.getName())) {
                String errorMessage = VSLErrorMessage.getInvalidExpressionType(_integer.getName(), locallyInferedType.getName());
                return new VSLValidationResult(valueSpec, (EStructuralFeature)indexFeature, (Type)locallyInferedType, true, errorMessage);
            }
        }
        if (condition != null) {
            VSLValidationResult checkCondition = this.checkExpressionRule(condition);
            if (checkCondition.errorFound()) {
                return checkCondition;
            }
            locallyInferedType = (Classifier)checkCondition.inferedType();
            if (locallyInferedType != _boolean && !locallyInferedType.getGenerals().contains((Object)_boolean) && !locallyInferedType.getName().equals(_boolean.getName())) {
                String errorMessage = VSLErrorMessage.getInvalidExpressionType(_boolean.getName(), locallyInferedType.getName());
                return new VSLValidationResult(valueSpec, (EStructuralFeature)conditionFeature, (Type)locallyInferedType, true, errorMessage);
            }
        }
        return new VSLValidationResult(valueSpec, (EStructuralFeature)mainFeature, inferedType, false, "");
    }

    public VSLValidationResult checkCollectionOrTuple(CollectionOrTuple valueSpec) {
        Classifier expectedType;
        block9: {
            ArrayList<VSLValidationResult> listOfValidationResults;
            block8: {
                listOfValidationResults = new ArrayList<VSLValidationResult>();
                if (valueSpec.getListOfValues() != null) {
                    for (Expression exp : valueSpec.getListOfValues().getValues()) {
                        VSLValidationResult expValidationResult = this.checkExpressionRule(exp);
                        listOfValidationResults.add(expValidationResult);
                        if (!expValidationResult.errorFound()) continue;
                        return expValidationResult;
                    }
                }
                VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
                ((Object)((Object)vSLScopeProvider)).getClass();
                VSLScopeProvider.ScopingHelper scopingHelper = vSLScopeProvider.new VSLScopeProvider.ScopingHelper(valueSpec);
                expectedType = scopingHelper.getClassifierForScoping();
                MultiplicityElement expectedMultiplicity = scopingHelper.getExpectedMultiplicity();
                if (!VSLContextUtil.isATupleType(expectedType)) break block8;
                if (expectedMultiplicity.getUpper() == 1) {
                    List<NamedElement> tupleAttribs = VSLContextUtil.getTupleAttribs(expectedType);
                    int i = 0;
                    while (i < tupleAttribs.size() && i < listOfValidationResults.size()) {
                        Type locallyExpectedType;
                        Type inferedType = ((VSLValidationResult)listOfValidationResults.get(i)).inferedType();
                        if (inferedType != (locallyExpectedType = ((Property)tupleAttribs.get(i)).getType()) && !((Classifier)inferedType).getGenerals().contains((Object)locallyExpectedType)) {
                            String errorMessage = VSLErrorMessage.getInvalidExpressionType(locallyExpectedType.getName(), inferedType.getName());
                            return new VSLValidationResult(((VSLValidationResult)listOfValidationResults.get(i)).validatedRule(), ((VSLValidationResult)listOfValidationResults.get(i)).validatedFeature(), inferedType, true, errorMessage);
                        }
                        ++i;
                    }
                } else {
                    for (VSLValidationResult validationResult : listOfValidationResults) {
                        Type inferedType = validationResult.inferedType();
                        if (inferedType == expectedType || expectedType.getGenerals().contains((Object)expectedType)) continue;
                        String errorMessage = VSLErrorMessage.getInvalidExpressionType(expectedType.getName(), inferedType.getName());
                        return new VSLValidationResult(validationResult.validatedRule(), validationResult.validatedFeature(), inferedType, true, errorMessage);
                    }
                }
                break block9;
            }
            if (!VSLContextUtil.isACollectionType(expectedType)) break block9;
            Property collectionAttib = (Property)VSLContextUtil.getCollectionAttrib(expectedType);
            Type locallyExpectedType = collectionAttib.getType();
            for (VSLValidationResult validationResult : listOfValidationResults) {
                Type inferedType = validationResult.inferedType();
                if (inferedType == locallyExpectedType || ((Classifier)locallyExpectedType).getGenerals().contains((Object)locallyExpectedType)) continue;
                String errorMessage = VSLErrorMessage.getInvalidExpressionType(expectedType.getName(), inferedType.getName());
                return new VSLValidationResult(validationResult.validatedRule(), validationResult.validatedFeature(), inferedType, true, errorMessage);
            }
        }
        return new VSLValidationResult(valueSpec, (EStructuralFeature)VSLPackage.eINSTANCE.getCollectionOrTuple_ListOfValues(), (Type)expectedType, false, "");
    }

    public VSLValidationResult checkSuffixExpression(SuffixExpression exp) {
        if (exp instanceof PropertyCallExpression) {
            return this.checkPropertyCallExpression((PropertyCallExpression)exp);
        }
        return this.checkOperationCallExpression((OperationCallExpression)exp);
    }

    public VSLValidationResult checkPropertyCallExpression(PropertyCallExpression exp) {
        Property p = exp.getProperty();
        Type inferedType = null;
        if (p.getType() == null) {
            String errorMessage = VSLErrorMessage.getUntypedPropertyMessage(p.getName());
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getPropertyCallExpression_Property(), null, true, errorMessage);
        }
        inferedType = p.getType();
        if (exp.getSuffix() != null) {
            VSLValidationResult suffixValidationResult = eInstance.checkSuffixExpression(exp.getSuffix());
            if (suffixValidationResult.errorFound()) {
                return suffixValidationResult;
            }
            inferedType = suffixValidationResult.inferedType();
        }
        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getPropertyCallExpression_Property(), inferedType, false, "");
    }

    public VSLValidationResult checkOperationCallExpression(OperationCallExpression exp) {
        Operation b = exp.getOperation();
        Type inferedType = null;
        Type returnType = null;
        ArrayList<String> expectedTypeNames = new ArrayList<String>();
        int i = 0;
        while (i < b.getOwnedParameters().size()) {
            Parameter p = (Parameter)b.getOwnedParameters().get(i);
            if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                returnType = p.getType();
            } else {
                expectedTypeNames.add(p.getType().getName());
            }
            ++i;
        }
        if (returnType == null) {
            String errorMessage = VSLErrorMessage.getOperationWithoutReturnParameterMessage(b.getName());
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getOperationCallExpression_Operation(), null, true, errorMessage);
        }
        inferedType = returnType;
        if (exp.getArguments() == null && b.getOwnedParameters().size() - 1 > 0) {
            String errorMessage = VSLErrorMessage.getInvalidNumberOfArgumentsForOperationCall(b.getName(), expectedTypeNames);
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getOperationCallExpression_Arguments(), inferedType, true, errorMessage);
        }
        if (exp.getArguments() != null) {
            if (exp.getArguments().getValues().size() != b.getOwnedParameters().size() - 1) {
                String errorMessage = VSLErrorMessage.getInvalidNumberOfArgumentsForOperationCall(b.getName(), expectedTypeNames);
                return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getOperationCallExpression_Arguments(), inferedType, true, errorMessage);
            }
            ArrayList<Parameter> inOutParameters = new ArrayList<Parameter>();
            for (Parameter p : b.getOwnedParameters()) {
                if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
                inOutParameters.add(p);
            }
            ArrayList<VSLValidationResult> argumentValidationResults = new ArrayList<VSLValidationResult>();
            for (Expression e : exp.getArguments().getValues()) {
                VSLValidationResult argumentValidationResult = this.checkExpressionRule(e);
                argumentValidationResults.add(argumentValidationResult);
                if (!argumentValidationResult.errorFound()) continue;
                return argumentValidationResult;
            }
            ArrayList<String> foundTypeNames = new ArrayList<String>();
            boolean errorFound = false;
            int i2 = 0;
            while (i2 < argumentValidationResults.size()) {
                Type expectedType = ((Parameter)inOutParameters.get(i2)).getType();
                Type foundType = ((VSLValidationResult)argumentValidationResults.get(i2)).inferedType();
                foundTypeNames.add(foundType.getName());
                if (VSLContextUtil.isAChoiceType((Classifier)expectedType)) {
                    boolean choiceAttribFound = false;
                    List<NamedElement> allChoiceAttribs = VSLContextUtil.getChoiceAttribs((Classifier)expectedType);
                    for (NamedElement choiceAttrib : allChoiceAttribs) {
                        Property p = (Property)choiceAttrib;
                        if (!foundType.conformsTo(p.getType())) continue;
                        choiceAttribFound = true;
                    }
                    if (!choiceAttribFound && !foundType.conformsTo(expectedType)) {
                        errorFound = true;
                    }
                } else if (!foundType.conformsTo(expectedType)) {
                    errorFound = true;
                }
                ++i2;
            }
            if (errorFound) {
                String errorMessage = VSLErrorMessage.getInvalidArgumentsForOperationCall(b.getName(), expectedTypeNames, foundTypeNames);
                return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getOperationCallExpression_Arguments(), inferedType, errorFound, errorMessage);
            }
        }
        if (exp.getSuffix() != null) {
            VSLValidationResult suffixValidationResult = eInstance.checkSuffixExpression(exp.getSuffix());
            if (suffixValidationResult.errorFound()) {
                return suffixValidationResult;
            }
            inferedType = suffixValidationResult.inferedType();
        }
        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getOperationCallExpression_Operation(), inferedType, false, "");
    }

    public VSLValidationResult checkInterval(Interval interval) {
        Type lowerType;
        if (interval.getLower() == null) {
            return new VSLValidationResult(interval, (EStructuralFeature)VSLPackage.eINSTANCE.getInterval_Lower(), null, true, "");
        }
        if (interval.getUpper() == null) {
            return new VSLValidationResult(interval, (EStructuralFeature)VSLPackage.eINSTANCE.getInterval_Upper(), null, true, "");
        }
        VSLValidationResult lowerValidationResult = this.checkExpressionRule(interval.getLower());
        if (lowerValidationResult.errorFound()) {
            return lowerValidationResult;
        }
        VSLValidationResult upperValidationResult = this.checkExpressionRule(interval.getUpper());
        if (upperValidationResult.errorFound()) {
            return upperValidationResult;
        }
        VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
        ((Object)((Object)vSLScopeProvider)).getClass();
        VSLScopeProvider.ScopingHelper scopingHelper = vSLScopeProvider.new VSLScopeProvider.ScopingHelper(interval);
        Classifier expectedType = scopingHelper.getClassifierForScoping();
        if (VSLContextUtil.isAnIntervalType(expectedType)) {
            Property intervalAttrib = (Property)VSLContextUtil.getIntervalAttrib(expectedType);
            expectedType = intervalAttrib.getType();
        }
        if ((lowerType = lowerValidationResult.inferedType()) == null || lowerType != expectedType && !((Classifier)lowerType).getGenerals().contains((Object)expectedType)) {
            String errorMessage = VSLErrorMessage.getInvalidExpressionType(expectedType.getName(), lowerType != null ? lowerType.getName() : "NULL");
            return new VSLValidationResult(interval, (EStructuralFeature)VSLPackage.eINSTANCE.getInterval_Lower(), lowerType, true, errorMessage);
        }
        Type upperType = upperValidationResult.inferedType();
        if (upperType == null || upperType != expectedType && !((Classifier)upperType).getGenerals().contains((Object)expectedType)) {
            String errorMessage = VSLErrorMessage.getInvalidExpressionType(expectedType.getName(), upperType != null ? upperType.getName() : "NULL");
            return new VSLValidationResult(interval, (EStructuralFeature)VSLPackage.eINSTANCE.getInterval_Upper(), upperType, true, errorMessage);
        }
        return new VSLValidationResult(interval, (EStructuralFeature)VSLPackage.eINSTANCE.getInterval_Lower(), (Type)expectedType, false, "");
    }

    public VSLValidationResult checkNameOrChoiceOrBehaviorCall(NameOrChoiceOrBehaviorCall exp) {
        Type inferedType = null;
        if (exp.getId() != null) {
            VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
            ((Object)((Object)vSLScopeProvider)).getClass();
            VSLScopeProvider.ScopingHelper helper = vSLScopeProvider.new VSLScopeProvider.ScopingHelper(exp.eContainer());
            if (helper.isExpectedTypeAStereotype()) {
                Stereotype expectedStereotype = (Stereotype)helper.getClassifierForScoping();
                return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Id(), (Type)expectedStereotype, false, "");
            }
            if (helper.isExpectedTypeAUMLMetaclass()) {
                Class expectedMetaclass = (Class)helper.getClassifierForScoping();
                return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Id(), (Type)expectedMetaclass, false, "");
            }
            if (exp.getId() instanceof Property) {
                Property p = (Property)exp.getId();
                if (p.getType() == null) {
                    String errorMessage = VSLErrorMessage.getUntypedPropertyMessage(p.getName());
                    return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Id(), inferedType, true, errorMessage);
                }
                inferedType = p.getType();
                if (VSLContextUtil.isAChoiceType((Classifier)p.getOwner())) {
                    if (exp.getArguments() == null || exp.getArguments().getValues().isEmpty()) {
                        String errorMessage = VSLErrorMessage.getMissingArgumentForChosenAlternativeMessage(p.getName(), p.getType().getName());
                        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Arguments(), null, true, errorMessage);
                    }
                    if (exp.getArguments().getValues().size() > 1) {
                        String errorMessage = VSLErrorMessage.getTooManyArgumentsForChosenAlternativeMessage(p.getName(), p.getType().getName());
                        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Arguments(), null, true, errorMessage);
                    }
                    VSLValidationResult nestedArgumentValidationResult = this.checkExpressionRule((Expression)exp.getArguments().getValues().get(0));
                    if (nestedArgumentValidationResult.errorFound()) {
                        return nestedArgumentValidationResult;
                    }
                    VSLScopeProvider vSLScopeProvider2 = VSLScopeProvider.eInstance;
                    ((Object)((Object)vSLScopeProvider2)).getClass();
                    VSLScopeProvider.ScopingHelper scopingHelper = vSLScopeProvider2.new VSLScopeProvider.ScopingHelper((EObject)exp.getArguments().getValues().get(0));
                    if (!nestedArgumentValidationResult.inferedType().conformsTo((Type)scopingHelper.getClassifierForScoping())) {
                        String errorMessage = VSLErrorMessage.getInvalidArgumentForChosenAlternativeMessage(p.getName(), scopingHelper.getClassifierForScoping().getName(), nestedArgumentValidationResult.inferedType().getName());
                        return new VSLValidationResult((EObject)exp.getArguments().getValues().get(0), nestedArgumentValidationResult.validatedFeature(), inferedType, true, errorMessage);
                    }
                }
            } else {
                if (exp.getId() instanceof EnumerationLiteral) {
                    EnumerationLiteral literal = (EnumerationLiteral)exp.getId();
                    return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Id(), (Type)literal.getEnumeration(), false, "");
                }
                if (exp.getId() instanceof Behavior) {
                    Behavior b = (Behavior)exp.getId();
                    Type returnType = null;
                    ArrayList<String> expectedTypeNames = new ArrayList<String>();
                    int i = 0;
                    while (i < b.getOwnedParameters().size()) {
                        Parameter p = (Parameter)b.getOwnedParameters().get(i);
                        if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                            returnType = p.getType();
                        } else {
                            expectedTypeNames.add(p.getType().getName());
                        }
                        ++i;
                    }
                    if (returnType == null) {
                        String errorMessage = VSLErrorMessage.getBehaviorWithoutReturnParameterMessage(b.getName());
                        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Id(), inferedType, true, errorMessage);
                    }
                    inferedType = returnType;
                    if (exp.getArguments() == null && expectedTypeNames.size() > 0) {
                        String errorMessage = VSLErrorMessage.getMissingArgumentsForBehaviorCall(b.getName(), expectedTypeNames);
                        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Arguments(), inferedType, true, errorMessage);
                    }
                    if (exp.getArguments() != null && exp.getArguments().getValues().size() != b.getOwnedParameters().size() - 1) {
                        String errorMessage = VSLErrorMessage.getInvalidNumberOfArgumentsForBehaviorCall(b.getName(), expectedTypeNames);
                        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Arguments(), inferedType, true, errorMessage);
                    }
                    ArrayList<Parameter> inOutParameters = new ArrayList<Parameter>();
                    for (Parameter p : b.getOwnedParameters()) {
                        if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
                        inOutParameters.add(p);
                    }
                    ArrayList<VSLValidationResult> argumentValidationResults = new ArrayList<VSLValidationResult>();
                    if (exp.getArguments() != null) {
                        for (Expression e : exp.getArguments().getValues()) {
                            VSLValidationResult argumentValidationResult = this.checkExpressionRule(e);
                            argumentValidationResults.add(argumentValidationResult);
                            if (!argumentValidationResult.errorFound()) continue;
                            return argumentValidationResult;
                        }
                    }
                    ArrayList<String> foundTypeNames = new ArrayList<String>();
                    boolean errorFound = false;
                    int i2 = 0;
                    while (i2 < argumentValidationResults.size()) {
                        Type expectedType = ((Parameter)inOutParameters.get(i2)).getType();
                        Type foundType = ((VSLValidationResult)argumentValidationResults.get(i2)).inferedType();
                        if (foundType == null) {
                            errorFound = true;
                        } else {
                            foundTypeNames.add(foundType.getName());
                            if (!foundType.conformsTo(expectedType)) {
                                errorFound = true;
                            }
                        }
                        ++i2;
                    }
                    if (errorFound) {
                        String errorMessage = VSLErrorMessage.getInvalidArgumentsForBehaviorCall(b.getName(), expectedTypeNames, foundTypeNames);
                        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Arguments(), inferedType, errorFound, errorMessage);
                    }
                }
            }
        }
        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getNameOrChoiceOrBehaviorCall_Id(), inferedType, false, "");
    }

    public VSLValidationResult checkTuple(Tuple exp) {
        VSLScopeProvider vSLScopeProvider = VSLScopeProvider.eInstance;
        ((Object)((Object)vSLScopeProvider)).getClass();
        VSLScopeProvider.ScopingHelper scopingHelper = vSLScopeProvider.new VSLScopeProvider.ScopingHelper(exp);
        for (ValueNamePair vnp : exp.getListOfValueNamePairs().getValueNamePairs()) {
            VSLValidationResult valueNamePairValidationResult = this.checkValueNamePair(vnp);
            if (!valueNamePairValidationResult.errorFound()) continue;
            return valueNamePairValidationResult;
        }
        Classifier classifierForScoping = scopingHelper.getClassifierForScoping();
        if (VSLContextUtil.isATupleType(classifierForScoping)) {
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getTuple_ListOfValueNamePairs(), (Type)classifierForScoping, false, "");
        }
        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getTuple_ListOfValueNamePairs(), _nfp_duration, false, "");
    }

    public VSLValidationResult checkValueNamePair(ValueNamePair exp) {
        if (exp.getProperty() == null) {
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getValueNamePair_Property(), null, true, "");
        }
        if (exp.getProperty().getType() == null) {
            String errorMessage = VSLErrorMessage.getUntypedPropertyMessage(exp.getProperty().getName());
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getValueNamePair_Property(), null, true, errorMessage);
        }
        VSLValidationResult valueValidationResult = this.checkExpressionRule(exp.getValue());
        if (valueValidationResult.errorFound()) {
            return valueValidationResult;
        }
        Type inferedType = valueValidationResult.inferedType();
        if (inferedType.getName().equals(exp.getProperty().getType().getName())) {
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getValueNamePair_Property(), inferedType, false, "");
        }
        if (!inferedType.conformsTo(exp.getProperty().getType())) {
            String errorMessage = VSLErrorMessage.getInvalidExpressionType(exp.getProperty().getType().getName(), inferedType.getName());
            return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getValueNamePair_Value(), inferedType, true, errorMessage);
        }
        return new VSLValidationResult(exp, (EStructuralFeature)VSLPackage.eINSTANCE.getValueNamePair_Property(), inferedType, false, "");
    }

    public static CollectionOrTuple isACollection(Expression exp) {
        return VSLJavaValidator.isACollection(exp.getExp());
    }

    private static CollectionOrTuple isACollection(AndOrXorExpression exp) {
        return VSLJavaValidator.isACollection((EqualityExpression)exp.getExp().get(0));
    }

    private static CollectionOrTuple isACollection(EqualityExpression exp) {
        return VSLJavaValidator.isACollection((RelationalExpression)exp.getExp().get(0));
    }

    private static CollectionOrTuple isACollection(RelationalExpression exp) {
        return VSLJavaValidator.isACollection((ConditionalExpression)exp.getExp().get(0));
    }

    private static CollectionOrTuple isACollection(ConditionalExpression exp) {
        if (exp.getExp().size() == 1) {
            return VSLJavaValidator.isACollection((AdditiveExpression)exp.getExp().get(0));
        }
        if (exp.getExp().size() == 3) {
            CollectionOrTuple coll = VSLJavaValidator.isACollection((AdditiveExpression)exp.getExp().get(1));
            return coll != null ? VSLJavaValidator.isACollection((AdditiveExpression)exp.getExp().get(2)) : null;
        }
        return null;
    }

    private static CollectionOrTuple isACollection(AdditiveExpression exp) {
        return VSLJavaValidator.isACollection((MultiplicativeExpression)exp.getExp().get(0));
    }

    private static CollectionOrTuple isACollection(MultiplicativeExpression exp) {
        return exp.getExp().isEmpty() ? null : VSLJavaValidator.isACollection((UnaryExpression)exp.getExp().get(0));
    }

    private static CollectionOrTuple isACollection(UnaryExpression exp) {
        return VSLJavaValidator.isACollection(exp.getExp());
    }

    private static CollectionOrTuple isACollection(PrimaryExpression exp) {
        return exp.getSuffix() == null ? VSLJavaValidator.isACollection(exp.getPrefix()) : null;
    }

    private static CollectionOrTuple isACollection(ValueSpecification exp) {
        return exp instanceof CollectionOrTuple ? (CollectionOrTuple)exp : null;
    }

    public class VSLValidationResult {
        private Type inferedType;
        private boolean errorFound;
        private EObject validatedRule;
        private EStructuralFeature validatedFeature;
        private String errorMessage = "";

        public VSLValidationResult(EObject validatedRule, EStructuralFeature validatedFeature, Type inferedType, boolean errorFound, String errorMessage) {
            this.validatedRule = validatedRule;
            this.validatedFeature = validatedFeature;
            this.inferedType = inferedType;
            this.errorFound = errorFound;
            this.errorMessage = String.valueOf(this.errorMessage) + errorMessage;
        }

        public EObject validatedRule() {
            return this.validatedRule;
        }

        public EStructuralFeature validatedFeature() {
            return this.validatedFeature;
        }

        public boolean errorFound() {
            return this.errorFound;
        }

        public Type inferedType() {
            return this.inferedType;
        }

        public String errorMessage() {
            return this.errorMessage;
        }
    }
}

