/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SemanticAdapter;

public class DefaultCreationEditPolicy
extends CreationEditPolicy {
    protected Command getCreateCommand(CreateViewRequest request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        for (CreateViewRequest.ViewDescriptor descriptor : request.getViewDescriptors()) {
            CreateViewCommand createCommand = new CreateViewCommand(editingDomain, descriptor, (View)this.getHost().getModel());
            ICommand setBoundsCommand = this.getSetBoundsCommand(request, descriptor);
            if (setBoundsCommand != null) {
                createCommand = CompositeCommand.compose((ICommand)createCommand, (ICommand)setBoundsCommand);
            }
            cc.compose((IUndoableOperation)createCommand);
        }
        return new ICommandProxy(cc.reduce());
    }

    protected ICommand getSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor) {
        return null;
    }

    protected ICommand getReparentCommand(IGraphicalEditPart gep) {
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        View container = (View)this.getHost().getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        View view = (View)gep.getModel();
        EObject element = ViewUtil.resolveSemanticElement((View)view);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (element != null) {
            MoveRequest moveRequest = new MoveRequest(editingDomain, context, element);
            Map parameters = moveRequest.getParameters();
            if (parameters != null) {
                parameters.put("TYPE_MOVING", "TYPE_MOVING_DIAGRAM");
            }
            moveRequest.addParameters(parameters);
            Command moveSemanticCmd = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)moveRequest));
            if (moveSemanticCmd == null) {
                return UnexecutableCommand.INSTANCE;
            }
            cc.compose((IUndoableOperation)new CommandProxy(moveSemanticCmd));
        }
        cc.compose((IUndoableOperation)this.getReparentViewCommand(gep));
        return cc;
    }

    protected ICommand getReparentViewCommand(IGraphicalEditPart gep) {
        GraphicalEditPart parent = (GraphicalEditPart)this.getHost();
        if (parent instanceof ListCompartmentEditPart && !this.canCreate(gep)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getReparentViewCommand(gep);
    }

    private boolean canCreate(IGraphicalEditPart gep) {
        CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor(gep);
        CreateViewRequest request = new CreateViewRequest(descriptor);
        Command createCommand = this.getCreateCommand(request);
        return createCommand.canExecute();
    }

    private CreateViewRequest.ViewDescriptor getViewDescriptor(IGraphicalEditPart gep) {
        String type = gep.getNotationView().getType();
        SemanticAdapter elementAdapter = new SemanticAdapter(gep.resolveSemanticElement(), null);
        return new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, type, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
    }
}

