/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.core.internal.clipboard.CopierFactory;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;

public class DefaultDiagramCopyCommand
extends AbstractOverrideableCommand
implements AbstractCommand.NonDirtying {
    private final Collection<Object> objectsToPutInClipboard = new ArrayList<Object>();
    private Collection<Object> oldClipboardContent;

    public Collection<Object> getObjectsToPutInClipboard() {
        return this.objectsToPutInClipboard;
    }

    public DefaultDiagramCopyCommand(EditingDomain domain, PapyrusClipboard<Object> papyrusClipboard, Collection<IGraphicalEditPart> pObjectsToPutInClipboard) {
        super(domain);
        IGraphicalEditPart next;
        Diagram diagram;
        Boolean keepReferences = Activator.getInstance().getPreferenceStore().getBoolean("KEEP_EXTERNAL_REFERENCES");
        EcoreUtil.Copier copier = new CopierFactory(domain.getResourceSet(), keepReferences.booleanValue()).get();
        ArrayList<Object> objectToCopy = new ArrayList<Object>();
        if (pObjectsToPutInClipboard != null) {
            for (IGraphicalEditPart iGraphicalEditPart : pObjectsToPutInClipboard) {
                View notationView = iGraphicalEditPart.getNotationView();
                EObject element = notationView.getElement();
                objectToCopy.add(notationView);
                objectToCopy.add(element);
            }
        }
        List filterDescendants = EcoreUtil.filterDescendants(objectToCopy);
        copier.copyAll((Collection)filterDescendants);
        copier.copyReferences();
        HashMap mapInternalCopyInClipboard = new HashMap();
        mapInternalCopyInClipboard.putAll(copier);
        papyrusClipboard.addAllInternalCopyInClipboard(mapInternalCopyInClipboard);
        if (pObjectsToPutInClipboard != null && !pObjectsToPutInClipboard.isEmpty() && (diagram = (next = pObjectsToPutInClipboard.iterator().next()).getNotationView().getDiagram()) != null) {
            papyrusClipboard.setContainerType(diagram.getType());
        }
    }

    public void doExecute() {
        this.oldClipboardContent = this.domain.getClipboard();
        this.domain.setClipboard(this.objectsToPutInClipboard);
    }

    public void doUndo() {
        this.domain.setClipboard(this.oldClipboardContent);
    }

    public void doRedo() {
        this.domain.setClipboard(this.objectsToPutInClipboard);
    }

    protected boolean prepare() {
        return this.domain != null;
    }
}

