/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.providers;

import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.uml.decoratormodel.profileExternalization.ApplyProfiles;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class DecoratorPackageCache
extends AdapterImpl {
    private static final Map<Package, Package> DECORATOR_TO_USER_PACKAGE_CACHE = new MapMaker().weakKeys().weakValues().concurrencyLevel(4).makeMap();
    private final Resource resource;

    public DecoratorPackageCache(Resource resource) {
        this.resource = resource;
    }

    public void install() {
        this.resource.eAdapters().add((Object)this);
    }

    public static Package getUserModelPackage(Package decoratorPackage) {
        return DECORATOR_TO_USER_PACKAGE_CACHE.get(decoratorPackage);
    }

    public static void aboutToUnload(Resource resource) {
        DecoratorPackageCache cache = DecoratorPackageCache.getCache(resource);
        if (cache != null) {
            cache.populate();
        }
    }

    static void cache(Package decorator, Package userModel) {
        DECORATOR_TO_USER_PACKAGE_CACHE.put(decorator, userModel);
    }

    static DecoratorPackageCache getCache(Resource resource) {
        return (DecoratorPackageCache)((Object)Iterables.getFirst((Iterable)Iterables.filter((Iterable)resource.eAdapters(), DecoratorPackageCache.class), null));
    }

    private static void cache(ApplyProfiles applyProfiles) {
        Dependency dependency = applyProfiles.getBase_Dependency();
        if (dependency != null) {
            Package decorator = DecoratorPackageCache.getPackage(dependency.getSuppliers());
            Package userModel = DecoratorPackageCache.getPackage(dependency.getClients());
            if (decorator != null && userModel != null) {
                DecoratorPackageCache.cache(decorator, userModel);
            }
        }
    }

    static Package getPackage(Collection<?> elements) {
        return (Package)EcoreUtil.getObjectByType(elements, (EClassifier)UMLPackage.Literals.PACKAGE);
    }

    public void notifyChanged(Notification msg) {
        if (msg.getFeatureID(Resource.class) == 2) {
            switch (msg.getEventType()) {
                case 4: 
                case 6: {
                    if (this.resource.isLoaded()) break;
                    Object old = msg.getOldValue();
                    List<Object> removed = old instanceof Collection ? (List<Object>)old : Collections.singletonList(old);
                    for (ApplyProfiles next : Iterables.filter(removed, ApplyProfiles.class)) {
                        DecoratorPackageCache.cache(next);
                    }
                    break;
                }
            }
        }
    }

    void populate() {
        for (ApplyProfiles next : Iterables.filter((Iterable)this.resource.getContents(), ApplyProfiles.class)) {
            DecoratorPackageCache.cache(next);
        }
    }
}

