/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeSet;

public class TypeEquivalenceSet {
    private ConstraintVariable2[] fVariables;
    private ITypeSet fTypeEstimate;

    public TypeEquivalenceSet(ConstraintVariable2 first, ConstraintVariable2 second) {
        this.fVariables = new ConstraintVariable2[]{first, second};
    }

    public TypeEquivalenceSet(ConstraintVariable2 variable) {
        this.fVariables = new ConstraintVariable2[]{variable};
    }

    public void add(ConstraintVariable2 variable) {
        int i = 0;
        while (i < this.fVariables.length) {
            if (this.fVariables[i] == variable) {
                return;
            }
            ++i;
        }
        int length = this.fVariables.length;
        ConstraintVariable2[] newElements = new ConstraintVariable2[length + 1];
        System.arraycopy(this.fVariables, 0, newElements, 0, length);
        newElements[length] = variable;
        this.fVariables = newElements;
    }

    public ConstraintVariable2[] getContributingVariables() {
        return this.fVariables;
    }

    public void addAll(ConstraintVariable2[] variables) {
        if (this.fVariables.length * variables.length > 100) {
            LinkedHashSet<ConstraintVariable2> result = new LinkedHashSet<ConstraintVariable2>(this.fVariables.length + variables.length);
            result.addAll(Arrays.asList(this.fVariables));
            result.addAll(Arrays.asList(variables));
            this.fVariables = result.toArray(new ConstraintVariable2[result.size()]);
        } else {
            List<ConstraintVariable2> elements = Arrays.asList(this.fVariables);
            ArrayList<ConstraintVariable2> result = new ArrayList<ConstraintVariable2>(this.fVariables.length + variables.length);
            result.addAll(elements);
            int i = 0;
            while (i < variables.length) {
                ConstraintVariable2 right = variables[i];
                if (!result.contains(right)) {
                    result.add(right);
                }
                ++i;
            }
            this.fVariables = result.toArray(new ConstraintVariable2[result.size()]);
        }
    }

    public void setTypeEstimate(ITypeSet estimate) {
        this.fTypeEstimate = estimate;
    }

    public ITypeSet getTypeEstimate() {
        return this.fTypeEstimate;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.fVariables.length > 0) {
            result.append(this.fVariables[0].toString());
        }
        int i = 1;
        while (i < this.fVariables.length) {
            result.append(" =^= \n");
            result.append(this.fVariables[i].toString());
            ++i;
        }
        return result.toString();
    }
}

