/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.refresh;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.sirius.business.internal.helper.refresh.AbstractProviderDescriptor;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtensionProvider;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshOverride;
import org.eclipse.sirius.diagram.business.internal.helper.refresh.RefreshExtensionProviderDescriptor;

public final class RefreshExtensionService
implements IRefreshExtension,
IRefreshOverride {
    private static final String REFRESH_EXTENSION_PROVIDER_EXTENSION_POINT = "org.eclipse.sirius.refreshExtensionProvider";
    private static final String TAG_ENGINE = "refreshExtensionProvider";
    private static RefreshExtensionService instance = new RefreshExtensionService();
    private List<RefreshExtensionProviderDescriptor> providers = new LinkedList<RefreshExtensionProviderDescriptor>();
    private boolean providersLoaded;

    private RefreshExtensionService() {
    }

    public static RefreshExtensionService getInstance() {
        return instance;
    }

    protected void loadProviders() {
        this.providers.clear();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(REFRESH_EXTENSION_PROVIDER_EXTENSION_POINT).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    AbstractProviderDescriptor desc = this.parseEngine(configElement);
                    if (desc != null) {
                        this.providers.add((RefreshExtensionProviderDescriptor)desc);
                    }
                    ++n4;
                }
                ++n2;
            }
            Collections.sort(this.providers);
        }
        this.providersLoaded = true;
    }

    private AbstractProviderDescriptor parseEngine(IConfigurationElement configurationElement) {
        if (!configurationElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        RefreshExtensionProviderDescriptor desc = new RefreshExtensionProviderDescriptor(configurationElement);
        return desc;
    }

    protected void dispose() {
        this.providers.clear();
        this.providersLoaded = false;
    }

    @Override
    public void beforeRefresh(DDiagram viewPoint) {
        ListIterator<RefreshExtensionProviderDescriptor> iterProviders = this.getProviders().listIterator();
        while (iterProviders.hasNext()) {
            RefreshExtensionProviderDescriptor currentProviderDecsriptor = iterProviders.next();
            IRefreshExtensionProvider refreshExtensionProvider = currentProviderDecsriptor.getProviderInstance();
            if (!RefreshExtensionService.safeProvides(refreshExtensionProvider, viewPoint)) continue;
            IRefreshExtension refreshExtension = RefreshExtensionService.safeGetRefreshExtension(refreshExtensionProvider, viewPoint);
            RefreshExtensionService.safeBeforeRefresh(refreshExtension, viewPoint);
        }
    }

    @Override
    public void postRefresh(DDiagram viewPoint) {
        ListIterator<RefreshExtensionProviderDescriptor> iterProviders = this.getProviders().listIterator();
        while (iterProviders.hasNext()) {
            RefreshExtensionProviderDescriptor currentProviderDecsriptor = iterProviders.next();
            IRefreshExtensionProvider refreshExtensionProvider = currentProviderDecsriptor.getProviderInstance();
            if (!RefreshExtensionService.safeProvides(refreshExtensionProvider, viewPoint)) continue;
            IRefreshExtension refreshExtension = RefreshExtensionService.safeGetRefreshExtension(refreshExtensionProvider, viewPoint);
            RefreshExtensionService.safePostRefresh(refreshExtension, viewPoint);
        }
    }

    @Override
    public boolean aroundRefresh(DDiagram dDiagram) {
        ListIterator<RefreshExtensionProviderDescriptor> iterProviders = this.getProviders().listIterator();
        boolean oneOverride = false;
        while (iterProviders.hasNext()) {
            IRefreshExtension refreshExtension;
            RefreshExtensionProviderDescriptor currentProviderDecsriptor = iterProviders.next();
            IRefreshExtensionProvider refreshExtensionProvider = currentProviderDecsriptor.getProviderInstance();
            if (!RefreshExtensionService.safeProvides(refreshExtensionProvider, dDiagram) || !((refreshExtension = RefreshExtensionService.safeGetRefreshExtension(refreshExtensionProvider, dDiagram)) instanceof IRefreshOverride)) continue;
            boolean bl = oneOverride = ((IRefreshOverride)((Object)refreshExtension)).aroundRefresh(dDiagram) || oneOverride;
        }
        return oneOverride;
    }

    public List<RefreshExtensionProviderDescriptor> getProviders() {
        if (!this.providersLoaded) {
            this.loadProviders();
        }
        return this.providers;
    }

    protected static boolean safeProvides(IRefreshExtensionProvider refreshExtensionProvider, DDiagram viewPoint) {
        boolean result = false;
        if (refreshExtensionProvider != null) {
            result = refreshExtensionProvider.provides(viewPoint);
        }
        return result;
    }

    protected static IRefreshExtension safeGetRefreshExtension(IRefreshExtensionProvider refreshExtensionProvider, DDiagram viewPoint) {
        IRefreshExtension refreshExtension = null;
        if (refreshExtensionProvider != null) {
            refreshExtension = refreshExtensionProvider.getRefreshExtension(viewPoint);
        }
        return refreshExtension;
    }

    private static void safeBeforeRefresh(IRefreshExtension refreshExtension, DDiagram viewPoint) {
        if (refreshExtension != null) {
            refreshExtension.beforeRefresh(viewPoint);
        }
    }

    private static void safePostRefresh(IRefreshExtension refreshExtension, DDiagram viewPoint) {
        if (refreshExtension != null) {
            refreshExtension.postRefresh(viewPoint);
        }
    }
}

