/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;

public class WizardPatternFilter
extends PatternFilter {
    @Override
    public boolean isElementSelectable(Object element) {
        return element instanceof WorkbenchWizardElement;
    }

    @Override
    protected boolean isLeafMatch(Viewer viewer, Object element) {
        if (element instanceof WizardCollectionElement) {
            return false;
        }
        if (element instanceof WorkbenchWizardElement) {
            WorkbenchWizardElement desc = (WorkbenchWizardElement)element;
            String text = desc.getLabel();
            if (this.wordMatches(text)) {
                return true;
            }
            String wizDesc = desc.getDescription();
            if (this.wordMatches(wizDesc)) {
                return true;
            }
            String[] keywordLabels = desc.getKeywordLabels();
            int i = 0;
            while (i < keywordLabels.length) {
                if (this.wordMatches(keywordLabels[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = super.filter(viewer, parent, elements);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            if (elem instanceof WizardCollectionElement) {
                WizardCollectionElement wizardCollection = WizardCollectionElement.filter(viewer, this, (WizardCollectionElement)elem);
                if (wizardCollection != null) {
                    result.add(wizardCollection);
                }
            } else {
                result.add(elem);
            }
            ++n2;
        }
        return result.toArray();
    }
}

