/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.c.expression.validation;

import eu.fbk.tools.editor.c.expression.expression.AdditiveExpression;
import eu.fbk.tools.editor.c.expression.expression.AndExpression;
import eu.fbk.tools.editor.c.expression.expression.EqualityExpression;
import eu.fbk.tools.editor.c.expression.expression.ExclusiveOrExpression;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.expression.expression.ExpressionPackage;
import eu.fbk.tools.editor.c.expression.expression.Identifier;
import eu.fbk.tools.editor.c.expression.expression.InclusiveOrExpression;
import eu.fbk.tools.editor.c.expression.expression.LogicalAndExpression;
import eu.fbk.tools.editor.c.expression.expression.LogicalOrExpression;
import eu.fbk.tools.editor.c.expression.expression.MultiplicativeExpression;
import eu.fbk.tools.editor.c.expression.expression.NumericalLiteral;
import eu.fbk.tools.editor.c.expression.expression.RelationalExpression;
import eu.fbk.tools.editor.c.expression.expression.ShiftExpression;
import eu.fbk.tools.editor.c.expression.validation.AbstractExpressionValidator;
import eu.fbk.tools.editor.c.expression.validation.ProposalProvider;
import eu.fbk.tools.editor.c.expression.validation.VariableProposalProvider;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class ExpressionValidator
extends AbstractExpressionValidator {
    public static boolean validationRequired = false;

    @Check
    public void checkVariable(Identifier variable) {
        boolean _tripleEquals;
        if (!validationRequired) {
            return;
        }
        String variableName = variable.getName();
        ProposalProvider.VariableInfo _get = VariableProposalProvider.getInstance().getVariables().get(variableName);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            this.error("Invalid symbol " + variableName, variable, (EStructuralFeature)ExpressionPackage.Literals.IDENTIFIER__NAME);
        }
    }

    @Check
    public void checkLogicalExpression(LogicalOrExpression expression) {
        if (!validationRequired) {
            return;
        }
        Optional<Boolean> left = this.isBooleanFormula(expression.getLeft());
        Optional<Boolean> right = this.isBooleanFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left expression operand should be a boolean formula or boolean literal", expression, (EStructuralFeature)ExpressionPackage.Literals.LOGICAL_OR_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right expression operand should be a boolean formula or boolean literal", expression, (EStructuralFeature)ExpressionPackage.Literals.LOGICAL_OR_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkLogicalExpression(LogicalAndExpression expression) {
        if (!validationRequired) {
            return;
        }
        Optional<Boolean> left = this.isBooleanFormula(expression.getLeft());
        Optional<Boolean> right = this.isBooleanFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left expression operand should be a boolean formula or boolean literal", expression, (EStructuralFeature)ExpressionPackage.Literals.LOGICAL_AND_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right expression operand should be a boolean formula or boolean literal", expression, (EStructuralFeature)ExpressionPackage.Literals.LOGICAL_AND_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkLogicalExpression(EqualityExpression expression) {
        if (!validationRequired) {
            return;
        }
        Optional<Boolean> left = this.isBooleanFormula(expression.getLeft());
        Optional<Boolean> right = this.isBooleanFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left expression operand should be a boolean formula or boolean literal", expression, (EStructuralFeature)ExpressionPackage.Literals.EQUALITY_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right expression operand should be a boolean formula or boolean literal", expression, (EStructuralFeature)ExpressionPackage.Literals.EQUALITY_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkLogicalExpression(RelationalExpression expression) {
        Boolean _get_1;
        boolean _tripleNotEquals;
        if (!validationRequired) {
            return;
        }
        Optional<Boolean> left = this.isBooleanFormula(expression.getLeft());
        Optional<Boolean> right = this.isBooleanFormula(expression.getRight());
        if (left.isPresent() && left.get().booleanValue()) {
            this.error("Left expression operand is boolean", expression, (EStructuralFeature)ExpressionPackage.Literals.RELATIONAL_EXPRESSION__LEFT);
        }
        if (right.isPresent() && right.get().booleanValue()) {
            this.error("Right expression operand is boolean", expression, (EStructuralFeature)ExpressionPackage.Literals.RELATIONAL_EXPRESSION__RIGHT);
        }
        if (!left.isPresent() || !right.isPresent()) {
            return;
        }
        Boolean _get = left.get();
        boolean bl = _tripleNotEquals = _get != (_get_1 = right.get());
        if (_tripleNotEquals) {
            this.error("Left and right expression operands are of different types", expression, (EStructuralFeature)ExpressionPackage.Literals.RELATIONAL_EXPRESSION__LEFT);
            this.error("Left and right expression operands are of different types", expression, (EStructuralFeature)ExpressionPackage.Literals.RELATIONAL_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkNumericalExpression(AdditiveExpression expression) {
        if (!validationRequired) {
            return;
        }
        Optional<Boolean> left = this.isNumericalFormula(expression.getLeft());
        Optional<Boolean> right = this.isNumericalFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.ADDITIVE_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.ADDITIVE_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkNumericalExpression(MultiplicativeExpression expression) {
        if (!validationRequired) {
            return;
        }
        Optional<Boolean> left = this.isNumericalFormula(expression.getLeft());
        Optional<Boolean> right = this.isNumericalFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.MULTIPLICATIVE_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.MULTIPLICATIVE_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkNumericalExpression(AndExpression expression) {
        if (!validationRequired) {
            return;
        }
        Optional<Boolean> left = this.isNumericalFormula(expression.getLeft());
        Optional<Boolean> right = this.isNumericalFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.AND_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.AND_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkNumericalExpression(ExclusiveOrExpression expression) {
        if (!validationRequired) {
            return;
        }
        Optional<Boolean> left = this.isNumericalFormula(expression.getLeft());
        Optional<Boolean> right = this.isNumericalFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.EXCLUSIVE_OR_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.EXCLUSIVE_OR_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkNumericalExpression(InclusiveOrExpression expression) {
        if (!validationRequired) {
            return;
        }
        Optional<Boolean> left = this.isNumericalFormula(expression.getLeft());
        Optional<Boolean> right = this.isNumericalFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.INCLUSIVE_OR_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.INCLUSIVE_OR_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkNumericalExpression(ShiftExpression expression) {
        if (!validationRequired) {
            return;
        }
        Optional<Boolean> left = this.isNumericalFormula(expression.getLeft());
        Optional<Boolean> right = this.isNumericalFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.SHIFT_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right expression operand is not numerical", expression, (EStructuralFeature)ExpressionPackage.Literals.SHIFT_EXPRESSION__RIGHT);
        }
    }

    private Optional<Boolean> isBooleanFormula(Expression expression) {
        if (expression instanceof Identifier) {
            return this.isBooleanVariable((Identifier)expression);
        }
        if (!(expression instanceof LogicalOrExpression || expression instanceof LogicalAndExpression || expression instanceof EqualityExpression || expression instanceof RelationalExpression)) {
            return Optional.of(false);
        }
        return Optional.of(true);
    }

    private Optional<Boolean> isNumericalFormula(Expression expression) {
        if (expression instanceof Identifier) {
            Boolean _get = this.isBooleanVariable((Identifier)expression).get();
            if (_get.booleanValue()) {
                return Optional.of(false);
            }
            return Optional.of(true);
        }
        if (expression instanceof NumericalLiteral) {
            return Optional.of(true);
        }
        if (expression instanceof InclusiveOrExpression || expression instanceof ExclusiveOrExpression || expression instanceof AndExpression || expression instanceof ShiftExpression || expression instanceof AdditiveExpression || expression instanceof MultiplicativeExpression) {
            return Optional.of(true);
        }
        return Optional.of(false);
    }

    private Optional<Boolean> isBooleanVariable(Identifier variable) {
        ProposalProvider.VariableInfo _get;
        String variableName = variable.getName();
        ProposalProvider.VariableInfo variableInfo = _get = VariableProposalProvider.getInstance().getVariables().get(variableName);
        if (variableInfo.type == null) {
            return Optional.empty();
        }
        if (variableInfo.type == ProposalProvider.VariableType.BOOLEAN) {
            return Optional.of(true);
        }
        return Optional.of(false);
    }
}

