/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.paste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.paste.IPastePostAction;

public final class PastePostActionRegistry {
    private static final String CLASS_MANAGER = "postActionClass";
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.paste.postactions";
    private final Collection<IPastePostAction> postActions = new ArrayList<IPastePostAction>();
    public static final PastePostActionRegistry INSTANCE = new PastePostActionRegistry();

    private PastePostActionRegistry() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            try {
                IPastePostAction solver = (IPastePostAction)iConfigurationElement.createExecutableExtension(CLASS_MANAGER);
                this.postActions.add(solver);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
    }

    public void doPostAction(INattableModelManager tableManager, String postActionId, EObject tableContext, Object objectToEdit, Map<Object, Object> sharedMap, String axisAsString) {
        IPastePostAction postAction = this.getPostAction(postActionId);
        if (postAction != null) {
            postAction.doPostAction(tableManager, postActionId, objectToEdit, sharedMap);
        } else {
            Activator.log.warn(NLS.bind((String)"No Manager were found to manage {0}", (Object)postActionId));
        }
    }

    public void concludePostAction(INattableModelManager tableManager, String postActionId, Map<Object, Object> sharedMap) {
        IPastePostAction postAction = this.getPostAction(postActionId);
        if (postAction != null) {
            postAction.concludePostAction(tableManager, postActionId, sharedMap);
        } else {
            Activator.log.warn(NLS.bind((String)"No Manager were found to manage {0}", (Object)postActionId));
        }
    }

    private IPastePostAction getPostAction(String postActionId) {
        for (IPastePostAction current : this.postActions) {
            if (!current.accept(postActionId)) continue;
            return current;
        }
        return null;
    }

    public Collection<String> getAvailablePostActionIds(INattableModelManager tableManager, Object object) {
        ArrayList<String> postActions = new ArrayList<String>();
        for (IPastePostAction current : this.postActions) {
            postActions.addAll(current.getAvailablePostActionIds(tableManager, object));
        }
        Collections.sort(postActions);
        return postActions;
    }
}

