/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.glazedlists.copy;

import java.util.List;
import org.eclipse.papyrus.infra.nattable.glazedlists.copy.SortingState;
import org.eclipse.papyrus.infra.nattable.glazedlists.copy.SortingStrategy;

public final class MouseOnlySortingStrategy
implements SortingStrategy {
    private final boolean multipleColumnSort;

    public MouseOnlySortingStrategy(boolean multipleColumnSort) {
        this.multipleColumnSort = multipleColumnSort;
    }

    @Override
    public void columnClicked(SortingState sortingState, int column, int clicks, boolean shift, boolean control) {
        SortingState.SortingColumn clickedColumn = sortingState.getColumns().get(column);
        if (clickedColumn.getComparators().isEmpty()) {
            return;
        }
        List<SortingState.SortingColumn> recentlyClickedColumns = sortingState.getRecentlyClickedColumns();
        if (clicks == 2) {
            for (SortingState.SortingColumn sortingColumn : recentlyClickedColumns) {
                sortingColumn.clear();
            }
            recentlyClickedColumns.clear();
        } else if (!this.multipleColumnSort) {
            for (SortingState.SortingColumn sortingColumn : recentlyClickedColumns) {
                if (sortingColumn == clickedColumn) continue;
                sortingColumn.clear();
            }
            recentlyClickedColumns.clear();
        }
        int netClicks = 1 + clickedColumn.getComparatorIndex() * 2 + (clickedColumn.isReverse() ? 1 : 0);
        clickedColumn.setComparatorIndex(netClicks / 2 % clickedColumn.getComparators().size());
        clickedColumn.setReverse(netClicks % 2 == 1);
        if (!recentlyClickedColumns.contains(clickedColumn)) {
            recentlyClickedColumns.add(clickedColumn);
        }
        sortingState.fireSortingChanged();
    }
}

