/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import org.eclipse.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.ocl.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.ocl.TypeHelper;
import org.eclipse.ocl.cst.TypeCS;

public class Definition
extends AbstractDefinition
implements XpandDefinition {
    private final Identifier name;

    public Definition(int start, int end, int line, Identifier name, TypeCS type, DeclaredParameter[] params, Statement[] body) {
        super(start, end, line, type, params, body);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name.getValue();
    }

    @Override
    public TypeHelper getTargetType() {
        return this.type;
    }

    @Override
    public final Template getOwner() {
        return this.owner;
    }

    @Override
    public final DeclaredParameter[] getParams() {
        return this.params;
    }

    public String toString() {
        return String.valueOf(this.getOwner().getFullyQualifiedName()) + "::" + this.getName() + this.getParamString() + " FOR " + this.type.getName();
    }

    private String getParamString() {
        if (this.params == null || this.params.length == 0) {
            return "";
        }
        StringBuilder buff = new StringBuilder("(");
        int i = 0;
        while (i < this.params.length) {
            DeclaredParameter p = this.params[i];
            buff.append(p.getVarName()).append(" ").append(p.getTypeName());
            if (i + 1 < this.params.length) {
                buff.append(",");
            }
            ++i;
        }
        return buff.append(")").toString();
    }
}

