/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.contract.validation;

import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.contract.contract.Assumption;
import eu.fbk.tools.editor.contract.contract.ContractPackage;
import eu.fbk.tools.editor.contract.contract.Guarantee;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.contract.expression.validation.ValidatorUtil;
import eu.fbk.tools.editor.contract.validation.AbstractContractValidator;
import eu.fbk.tools.editor.contract.validation.AssertionProposalProvider;
import eu.fbk.tools.editor.contract.validation.ModelUtil;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class ContractValidator
extends AbstractContractValidator {
    @Check
    public void checkAssume(Assumption assumption) {
        Expression _constraint = assumption.getConstraint();
        if (_constraint instanceof Expression) {
            Optional<Boolean> isAssertonIdDefined;
            Expression constraint = assumption.getConstraint();
            if (constraint instanceof FullVariableId && (isAssertonIdDefined = this.isAssertonIdDefined((FullVariableId)constraint)).isPresent() && isAssertonIdDefined.get().booleanValue()) {
                return;
            }
            Optional isBoolFormula = this.isBooleanFormula(constraint);
            if (isBoolFormula.isPresent() && !((Boolean)isBoolFormula.get()).booleanValue()) {
                this.error("Assumption should be a boolean formula, a boolean literal or an assertion name", assumption, (EStructuralFeature)ContractPackage.Literals.ASSUMPTION__CONSTRAINT);
            }
            return;
        }
        this.error("Assumption should be a boolean formula, a boolean literal or an assertion name", assumption, (EStructuralFeature)ContractPackage.Literals.ASSUMPTION__CONSTRAINT);
    }

    @Check
    public void checkGuarantee(Guarantee guarantee) {
        Expression _constraint = guarantee.getConstraint();
        if (_constraint instanceof Expression) {
            Optional<Boolean> isAssertonIdDefined;
            Expression constraint = guarantee.getConstraint();
            Expression _constraint_1 = guarantee.getConstraint();
            if (_constraint_1 instanceof FullVariableId && (isAssertonIdDefined = this.isAssertonIdDefined((FullVariableId)constraint)).isPresent() && isAssertonIdDefined.get().booleanValue()) {
                return;
            }
            Optional isBoolFormula = this.isBooleanFormula(constraint);
            if (isBoolFormula.isPresent() && !((Boolean)isBoolFormula.get()).booleanValue()) {
                this.error("Guarantee should be a boolean formula, a boolean literal or an assertion name", guarantee, (EStructuralFeature)ContractPackage.Literals.GUARANTEE__CONSTRAINT);
            }
            return;
        }
        this.error("Guarantee should be a boolean formula, a boolean literal or an assertion name", guarantee, (EStructuralFeature)ContractPackage.Literals.GUARANTEE__CONSTRAINT);
    }

    public Object checkConstraint(Expression constraint) {
        return null;
    }

    @Check
    public boolean checkIsDeclaredVariable(FullVariableId variable) {
        boolean _isDeclaredVariableCheckEnabled = ValidatorUtil.isDeclaredVariableCheckEnabled();
        if (_isDeclaredVariableCheckEnabled) {
            String variableName = ModelUtil.getVariableIdAsStr(variable.getId());
            List<String> _values = AssertionProposalProvider.getInstance().getValues();
            for (String value : _values) {
                boolean _equals = value.equals(variableName);
                if (!_equals) continue;
                return true;
            }
        }
        return super.checkIsDeclaredVariable(variable);
    }

    public Optional<Boolean> isAssertonIdDefined(FullVariableId assertionId) {
        boolean _isDeclaredVariableCheckEnabled = ValidatorUtil.isDeclaredVariableCheckEnabled();
        if (_isDeclaredVariableCheckEnabled) {
            String assertionName = ModelUtil.getFullVariableIdAsStr(assertionId);
            List<String> _values = AssertionProposalProvider.getInstance().getValues();
            for (String value : _values) {
                boolean _equals = value.equals(assertionName);
                if (!_equals) continue;
                return Optional.of(true);
            }
            return Optional.of(false);
        }
        return Optional.empty();
    }

    @Check
    public void checkIsBooleanExpression(Expression expression) {
    }
}

