/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.contract.formatting2;

import com.google.inject.Inject;
import eu.fbk.tools.editor.basetype.baseType.BoundedArrayType;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.contract.contract.Assumption;
import eu.fbk.tools.editor.contract.contract.Contract;
import eu.fbk.tools.editor.contract.contract.Contracts;
import eu.fbk.tools.editor.contract.contract.Guarantee;
import eu.fbk.tools.editor.contract.expression.expression.ArrayIndex;
import eu.fbk.tools.editor.contract.expression.expression.ComponentId;
import eu.fbk.tools.editor.contract.expression.expression.FullParameterId;
import eu.fbk.tools.editor.contract.expression.expression.FullPortId;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBound;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBounds;
import eu.fbk.tools.editor.contract.expression.expression.LogicalExpression;
import eu.fbk.tools.editor.contract.expression.expression.ParameterId;
import eu.fbk.tools.editor.contract.expression.expression.PortId;
import eu.fbk.tools.editor.contract.expression.expression.TemporalExpression;
import eu.fbk.tools.editor.contract.expression.formatting2.ExpressionFormatter;
import eu.fbk.tools.editor.contract.services.ContractGrammarAccess;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

public class ContractFormatter
extends ExpressionFormatter {
    @Inject
    @Extension
    private ContractGrammarAccess grammarAccess;

    protected void _format(Contracts contracts, @Extension IFormattableDocument document) {
        EList<Contract> _contracts = contracts.getContracts();
        for (Contract contract : _contracts) {
            document.format((Object)contract);
        }
    }

    protected void _format(Contract contract, @Extension IFormattableDocument document) {
        document.format((Object)contract.getAssumption());
        document.format((Object)contract.getGuarantee());
    }

    protected void _format(Assumption assumption, @Extension IFormattableDocument document) {
        document.format((Object)assumption.getConstraint());
    }

    protected void _format(Guarantee guarantee, @Extension IFormattableDocument document) {
        document.format((Object)guarantee.getConstraint());
    }

    public void format(Object assumption, IFormattableDocument document) {
        if (assumption instanceof BoundedArrayType) {
            this._format((BoundedArrayType)assumption, document);
            return;
        }
        if (assumption instanceof FullParameterId) {
            this._format((FullParameterId)assumption, document);
            return;
        }
        if (assumption instanceof FullPortId) {
            this._format((FullPortId)assumption, document);
            return;
        }
        if (assumption instanceof EnumType) {
            this._format((EnumType)assumption, document);
            return;
        }
        if (assumption instanceof LogicalExpression) {
            this._format((LogicalExpression)assumption, document);
            return;
        }
        if (assumption instanceof TemporalExpression) {
            this._format((TemporalExpression)assumption, document);
            return;
        }
        if (assumption instanceof XtextResource) {
            this._format((XtextResource)assumption, document);
            return;
        }
        if (assumption instanceof ParameterId) {
            this._format((ParameterId)assumption, document);
            return;
        }
        if (assumption instanceof PortId) {
            this._format((PortId)assumption, document);
            return;
        }
        if (assumption instanceof Assumption) {
            this._format((Assumption)assumption, document);
            return;
        }
        if (assumption instanceof Contract) {
            this._format((Contract)assumption, document);
            return;
        }
        if (assumption instanceof Contracts) {
            this._format((Contracts)assumption, document);
            return;
        }
        if (assumption instanceof Guarantee) {
            this._format((Guarantee)assumption, document);
            return;
        }
        if (assumption instanceof ArrayIndex) {
            this._format((ArrayIndex)assumption, document);
            return;
        }
        if (assumption instanceof ComponentId) {
            this._format((ComponentId)assumption, document);
            return;
        }
        if (assumption instanceof IteratorBound) {
            this._format((IteratorBound)assumption, document);
            return;
        }
        if (assumption instanceof IteratorBounds) {
            this._format((IteratorBounds)assumption, document);
            return;
        }
        if (assumption instanceof EObject) {
            this._format((EObject)assumption, document);
            return;
        }
        if (assumption == null) {
            this._format(null, document);
            return;
        }
        if (assumption != null) {
            this._format(assumption, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(assumption, document).toString());
    }
}

