/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy.state;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.State;

public abstract class AbstractBehaviorToStateDropStrategy
extends TransactionalDropStrategy {
    public String getLabel() {
        String featureName = this.getFeatureToEdit().getName();
        return "Behavior -> State : sets the \"" + featureName + "\" property";
    }

    public String getDescription() {
        String featureName = this.getFeatureToEdit().getName();
        return "When a Behavior is dropped on a State, sets the behavior as the state's \"" + featureName + "\" property";
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        String featureName = this.getFeatureToEdit().getName();
        return "org.eclipse.papyrus.behaviorToState." + featureName;
    }

    public int getPriority() {
        return 50;
    }

    public String getCategory() {
        return "org.eclipse.papyrus.behaviorToState";
    }

    public Command doGetCommand(Request request, EditPart targetEditPart) {
        if (!(this.getTargetSemanticElement(targetEditPart) instanceof State)) {
            return null;
        }
        List sourceEObjects = this.getSourceEObjects(request);
        if (sourceEObjects.size() != 1) {
            return null;
        }
        if (!(sourceEObjects.get(0) instanceof Behavior)) {
            return null;
        }
        final Behavior behavior = (Behavior)sourceEObjects.get(0);
        final State targetState = (State)this.getTargetSemanticElement(targetEditPart);
        EObject ancestor = targetState.eContainer();
        while (ancestor != null) {
            if (ancestor == behavior) {
                return null;
            }
            ancestor = ancestor.eContainer();
        }
        return new Command(){

            public void execute() {
                targetState.eSet(AbstractBehaviorToStateDropStrategy.this.getFeatureToEdit(), (Object)behavior);
            }
        };
    }

    protected abstract EStructuralFeature getFeatureToEdit();
}

