/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class FeatureImportOperation
implements IWorkspaceRunnable {
    private IFeatureModel[] fModels;
    private boolean fBinary;
    private IPath fTargetPath;
    private IWorkspaceRoot fRoot;
    private IReplaceQuery fReplaceQuery;

    public FeatureImportOperation(IFeatureModel[] models, boolean binary, IPath targetPath, IReplaceQuery replaceQuery) {
        this.fModels = models;
        this.fBinary = binary;
        this.fTargetPath = targetPath;
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fReplaceQuery = replaceQuery;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.FeatureImportWizard_operation_creating, (int)this.fModels.length);
        MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, PDEUIMessages.FeatureImportWizard_operation_multiProblem, null);
        int i = 0;
        while (i < this.fModels.length) {
            try {
                this.createProject(this.fModels[i], (IProgressMonitor)subMonitor.split(1));
            }
            catch (CoreException e) {
                multiStatus.merge(e.getStatus());
            }
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++i;
        }
        if (!multiStatus.isOK()) {
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private void createProject(IFeatureModel model, IProgressMonitor monitor) throws CoreException {
        String name = model.getFeature().getId();
        IFeaturePlugin[] plugins = model.getFeature().getPlugins();
        int i = 0;
        while (i < plugins.length) {
            if (name.equals(plugins[i].getId())) {
                name = String.valueOf(name) + "-feature";
                break;
            }
            ++i;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)PDEUIMessages.FeatureImportWizard_operation_creating2, (Object)name), (int)9);
        IProject project = this.fRoot.getProject(name);
        if (project.exists() || new File(project.getParent().getLocation().toFile(), name).exists()) {
            if (this.queryReplace(project)) {
                if (!project.exists()) {
                    project.create((IProgressMonitor)subMonitor.split(1));
                }
                project.delete(true, true, (IProgressMonitor)subMonitor.split(1));
                try {
                    RepositoryProvider.unmap((IProject)project);
                }
                catch (TeamException teamException) {}
            } else {
                return;
            }
        }
        subMonitor.setWorkRemaining(7);
        IProjectDescription description = PDEPlugin.getWorkspace().newProjectDescription(name);
        if (this.fTargetPath != null) {
            description.setLocation(this.fTargetPath.append(name));
        }
        project.create(description, (IProgressMonitor)subMonitor.split(1));
        if (!project.isOpen()) {
            project.open(null);
        }
        File featureDir = new File(model.getInstallLocation());
        this.importContent(featureDir, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)subMonitor.split(1));
        IFolder folder = project.getFolder("META-INF");
        if (folder.exists()) {
            folder.delete(true, null);
        }
        if (this.fBinary) {
            project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
        }
        this.createBuildProperties(project);
        this.setProjectNatures(project, model, subMonitor.split(1));
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            this.setClasspath(project, model, (IProgressMonitor)subMonitor.split(4));
        }
    }

    private void importContent(Object source, IPath destPath, IImportStructureProvider provider, List<?> filesToImport, IProgressMonitor monitor) throws CoreException {
        IOverwriteQuery query = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        ImportOperation op = new ImportOperation(destPath, source, provider, query);
        op.setCreateContainerStructure(false);
        if (filesToImport != null) {
            op.setFilesToImport(filesToImport);
        }
        try {
            op.run(monitor);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            if (th instanceof CoreException) {
                throw (CoreException)th;
            }
            Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    private boolean queryReplace(IProject project) throws OperationCanceledException {
        switch (this.fReplaceQuery.doQuery(project)) {
            case 0: {
                throw new OperationCanceledException();
            }
            case 1: {
                return false;
            }
        }
        return true;
    }

    private void setProjectNatures(IProject project, IFeatureModel model, SubMonitor subMonitor) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (this.needsJavaNature(model)) {
            desc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.FeatureNature"});
        } else {
            desc.setNatureIds(new String[]{"org.eclipse.pde.FeatureNature"});
        }
        subMonitor.setWorkRemaining(1);
        project.setDescription(desc, (IProgressMonitor)subMonitor.split(1));
    }

    private void setClasspath(IProject project, IFeatureModel model, IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IJavaProject jProject = JavaCore.create((IProject)project);
        IClasspathEntry jreCPEntry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
        String libName = model.getFeature().getInstallHandler().getLibrary();
        IClasspathEntry handlerCPEntry = JavaCore.newLibraryEntry((IPath)project.getFullPath().append(libName), null, null);
        jProject.setRawClasspath(new IClasspathEntry[]{jreCPEntry, handlerCPEntry}, (IProgressMonitor)subMonitor);
    }

    private boolean needsJavaNature(IFeatureModel model) {
        IFeatureInstallHandler handler = model.getFeature().getInstallHandler();
        if (handler == null) {
            return false;
        }
        String libName = handler.getLibrary();
        if (libName == null || libName.length() <= 0) {
            return false;
        }
        File lib = new File(model.getInstallLocation(), libName);
        return lib.exists();
    }

    private void createBuildProperties(IProject project) {
        IFile file = PDEProject.getBuildProperties((IProject)project);
        if (!file.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(file);
            IBuildEntry ientry = model.getFactory().createEntry("bin.includes");
            try {
                IResource[] res = project.members();
                int i = 0;
                while (i < res.length) {
                    String path = res[i].getProjectRelativePath().toString();
                    if (!path.equals(".project")) {
                        ientry.addToken(path);
                    }
                    ++i;
                }
                model.getBuild().add(ientry);
                model.save();
            }
            catch (CoreException coreException) {}
        }
    }

    public static interface IReplaceQuery {
        public static final int CANCEL = 0;
        public static final int NO = 1;
        public static final int YES = 2;

        public int doQuery(IProject var1);
    }
}

