/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractGraphicalCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.menu.utils.DeleteActionUtil;

public class DeleteFromDiagramCommandHandler
extends AbstractGraphicalCommandHandler
implements IHandler {
    private static final String COMMAND_LABEL = "Delete From Diagram";

    protected Command getCommand() {
        List<IGraphicalEditPart> editParts = this.getSelectedElements();
        if (editParts.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!DeleteActionUtil.isSupportView(editParts) || DeleteActionUtil.isCanonical(editParts)) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand(COMMAND_LABEL);
        for (IGraphicalEditPart editPart : editParts) {
            command.add(DeleteActionUtil.getDeleteFromDiagramCommand(editPart));
        }
        return command;
    }

    protected boolean computeEnabled() {
        boolean enable = true;
        List<IGraphicalEditPart> selectedElement = this.getSelectedElements();
        Iterator<IGraphicalEditPart> iteratorSelection = selectedElement.iterator();
        while (iteratorSelection.hasNext() && enable) {
            IGraphicalEditPart editPart = iteratorSelection.next();
            boolean bl = enable = enable && !(editPart instanceof DiagramEditPart) && DeleteActionUtil.isSupportView(editPart) && (!DeleteActionUtil.isCanonicalView(editPart) || !DeleteActionUtil.isCanonicalEditPart(editPart));
        }
        return enable;
    }
}

