/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc.details;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.ua.core.toc.text.TocObject;
import org.eclipse.pde.internal.ua.ui.editor.toc.TocTreeSection;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class TocAbstractDetails
extends PDEDetails {
    private static final int NUM_COLUMNS = 3;
    private TocTreeSection fMasterSection;
    private Section fMainSection;
    private String fContextID;

    public TocAbstractDetails(TocTreeSection masterSection, String contextID) {
        this.fMasterSection = masterSection;
        this.fContextID = contextID;
        this.fMainSection = null;
    }

    public void createContents(Composite parent) {
        this.configureParentLayout(parent);
        this.createDetails(parent);
        this.hookListeners();
    }

    private void configureParentLayout(Composite parent) {
        parent.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout((boolean)false, (int)1));
    }

    public void createDetails(Composite parent) {
        int style = 256;
        if (this.getDetailsDescription() != null) {
            style |= 0x80;
        }
        this.fMainSection = this.getPage().createUISection(parent, this.getDetailsTitle(), this.getDetailsDescription(), style);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fMainSection);
        Composite sectionClient = this.getPage().createUISectionContainer((Composite)this.fMainSection, 3);
        GridData data = new GridData(1808);
        this.fMainSection.setLayoutData((Object)data);
        this.createFields(sectionClient);
        this.getManagedForm().getToolkit().paintBordersFor(sectionClient);
        this.fMainSection.setClient((Control)sectionClient);
        this.markDetailsPart((Control)this.fMainSection);
    }

    protected abstract void createFields(Composite var1);

    protected abstract String getDetailsTitle();

    protected abstract String getDetailsDescription();

    public abstract void updateFields();

    public abstract void hookListeners();

    public void selectionChanged(IFormPart part, ISelection selection) {
    }

    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    public String getContextId() {
        return this.fContextID;
    }

    public PDEFormPage getPage() {
        return (PDEFormPage)this.getManagedForm().getContainer();
    }

    protected void setPathEntry(IFile file) {
        IPath path = file.getFullPath();
        if (file.getProject().equals((Object)this.getDataObject().getModel().getUnderlyingResource().getProject())) {
            this.getPathEntryField().setValue(path.removeFirstSegments(1).toString());
        } else {
            this.getPathEntryField().setValue(".." + path.toString());
        }
    }

    protected void handleOpen() {
        IFile file = this.getMasterSection().openFile(this.getPathEntryField().getValue(), this.isTocPath());
        if (file != null) {
            this.setPathEntry(file);
        }
    }

    protected boolean isTocPath() {
        return false;
    }

    protected abstract TocObject getDataObject();

    protected abstract FormEntry getPathEntryField();

    public boolean isEditable() {
        return this.fMasterSection.isEditable();
    }

    public void modelChanged(IModelChangedEvent event) {
    }

    public boolean isEditableElement() {
        return this.fMasterSection.isEditable();
    }

    public FormToolkit getToolkit() {
        return this.getManagedForm().getToolkit();
    }

    public TocTreeSection getMasterSection() {
        return this.fMasterSection;
    }

    protected Object getFirstSelectedObject(ISelection selection) {
        IStructuredSelection structuredSel = (IStructuredSelection)selection;
        if (structuredSel == null) {
            return null;
        }
        return structuredSel.getFirstElement();
    }

    protected void createLabel(Composite client, FormToolkit toolkit, String text) {
        Label label = toolkit.createLabel(client, text, 64);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
    }

    protected void createSpace(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), "");
    }
}

