/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.test;

import com.google.inject.Inject;
import eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.core.visitors.CleanCTranslatorToPython;
import eu.fbk.eclipse.standardtools.utils.core.parser.ParseHelper;
import eu.fbk.eclipse.standardtools.utils.core.utils.SysMLElementExtractor;
import eu.fbk.tools.editor.c.statement.statement.Statement;
import eu.fbk.tools.editor.c.statement.tests.StatementInjectorProvider;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.testing.XtextRunner;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=StatementInjectorProvider.class)
public class TestStatement {
    String indent = "    ";
    private final String NewLine = "\n";
    @Inject
    private ParseHelper<?> stmtParseHelper;
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    @Before
    public void beforeTest() {
    }

    @Test
    public void testIfStatement() {
        String cStmt = "if (locVar > data2) {c = 0;x = f(c);} else {c = 1;x = f(c);}";
        String pyStmt = "if self.locVar > data2:\n" + this.indent + "c = 0" + "\n" + this.indent + "x = f(c)" + "\n" + "else:" + "\n" + this.indent + "c = 1" + "\n" + this.indent + "x = f(c)";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testIfStatement2() {
        String cStmt = "if (locVar > data2) assert (x == 1);    else if (locVar < data2) assert (x ==1); else assert (x > 1);";
        String pyStmt = "if self.locVar > data2:\n" + this.indent + "assert x == 1" + "\n" + "else:" + "\n" + this.indent + "if self.locVar < data2:" + "\n" + this.indent + this.indent + "assert x == 1" + "\n" + this.indent + "else:" + "\n" + this.indent + this.indent + "assert x > 1";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testIfStatement5() {
        String cStmt = "if (locVar > data2) setx(1);    else if (locVar < data2) setx(2); else setx(3);";
        String pyStmt = "if self.locVar > data2:\n" + this.indent + "setx(1)" + "\n" + "else:" + "\n" + this.indent + "if self.locVar < data2:" + "\n" + this.indent + this.indent + "setx(2)" + "\n" + this.indent + "else:" + "\n" + this.indent + this.indent + "setx(3)";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testIfStatement3() {
        String cStmt = "if (true) assert (x == 1);    else if (false) assert (x ==1);";
        String pyStmt = "if True:\n" + this.indent + "assert x == 1" + "\n" + "else:" + "\n" + this.indent + "if False:" + "\n" + this.indent + this.indent + "assert x == 1";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testIfStatement4() {
        String cStmt = "if (locVar > data2) {c = 0;x = f(c);} if (locVar < data2) {c = 1;x = f(c);}";
        String pyStmt = "if self.locVar > data2:\n" + this.indent + "c = 0" + "\n" + this.indent + "x = f(c)" + "\n" + "if self.locVar < data2:" + "\n" + this.indent + "c = 1" + "\n" + this.indent + "x = f(c)";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testIfStatement6() {
        String cStmt = "if (locVar > data2) setx(1);    else if (locVar < data2) setx(2); else setx(3);";
        String pyStmt = "if self.locVar > data2:\n" + this.indent + "setx(1)" + "\n" + "else:" + "\n" + this.indent + "if self.locVar < data2:" + "\n" + this.indent + this.indent + "setx(2)" + "\n" + this.indent + "else:" + "\n" + this.indent + this.indent + "setx(3)";
        System.out.println("testIfStatement6: " + pyStmt);
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testSelfStatement() {
        String cStmt = "get_y[0].print_counter();";
        String pyStmt = "self.get_y[0].print_counter()";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("get_y", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void iteratorStatement() {
        String cStmt = "for (Obj d : locVar) { z = z + 1; break;}";
        String pyStmt = "for d in self.locVar:\n" + this.indent + "z = z + 1" + "\n" + this.indent + "break";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void iteratorStatement2() {
        String cStmt = "for (Obj d : locVar) break;";
        String pyStmt = "for d in self.locVar:\n" + this.indent + "break";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void manyIteratorStatement() {
        int i = 0;
        while (i < 1000) {
            String cStmt = "boolean res = true ;res &= ( esclusoDM == false ) ; res &= ( esclusoIS == false ) ; { boolean __res_0 = true ;{ for ( ElettromagneteRec it : elettromagnete ) { __res_0 &= ( ! ( ( it . elettromagnete . getFsmState ( ) == Bloccato ) || ( it . elettromagnete . getFsmState ( ) == Attivato ) ) ) ; if ( __res_0 == false ) { break ;}}}res &= __res_0 ;}{ boolean __res_1 = true ;{ for ( CircuitoDiBinarioRec it : cdbDiImmobilizzazione ) { __res_1 &= ( it . circuitoDiBinario . getLibero ( ) && ( ! it . circuitoDiBinario . getBloccato ( ) ) ) ; if ( __res_1 == false ) { break ;}}}res &= __res_1 ;}res &= ( Deviatoio_eventSoccorsoTcRovescio ) ; res &= ( prenotazione == false ) ; return res ;";
            String pyStmt = "for d in self.locVar:\n" + this.indent + "break";
            HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
            typeAssignmentCache.put("locVar", null);
            this.testStatementPair(cStmt, pyStmt, typeAssignmentCache);
            ++i;
        }
    }

    private void testStatementPair(String cleanCString, String expectedPythonResult, HashMap<String, Object> typeAssignmentCache) {
        try {
            Statement stmt = (Statement)this.stmtParseHelper.parse((CharSequence)cleanCString);
            SysMLElementExtractor elementExtractor = new SysMLElementExtractor(null, null, null);
            List<String> literalsNamesMap = null;
            CleanCTranslatorToPython cleanCTranslatorToPython = new CleanCTranslatorToPython(elementExtractor, false, literalsNamesMap);
            cleanCTranslatorToPython.addAllVariableInGlobalVariablesCache(typeAssignmentCache);
            cleanCTranslatorToPython.process((EObject)stmt);
        }
        catch (Exception e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    @Test
    public void statement() {
        String cStmt = "counter=0;\nreturn response_done();";
        String pyStmt = "self.counter = 0\nreturn self.response_done()";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("counter", null);
        typeAssignmentCache.put("response_done", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void statement3() {
        String cStmt = "integer balance[5] = {1000, 2, 3, 7, 50};";
        String pyStmt = "balance[5] = {1000, 2, 3, 7, 50}\n";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void statement2() {
        String cStmt = "args['command_done']=true;self.response_notify(y, args);";
        String pyStmt = "args['command_done'] = True\nself.response_notify(y, args)";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void switchStatement() {
        String cStmt = "switch(grade) {case 'A' : {print(\"Excellent!\" ); print(\"Bravo!\" ); break;} case 'B' : break;case 'C' :  {print(\"Well done\" ); break;} case 'D' : print(\"You passed\" ); break; case 'F' : print(\"Better try again\" ); break; default : print(\"Invalid grade\" );break; }";
        String pyStmt = "if grade is 'A':\n" + this.indent + "print(\"Excellent!\")" + "\n" + this.indent + "print(\"Bravo!\")" + "\n" + this.indent + "pass" + "\n" + "elif grade is 'B':" + "\n" + this.indent + "pass" + "\n" + "elif grade is 'C':" + "\n" + this.indent + "print(\"Well done\")" + "\n" + this.indent + "pass" + "\n" + "elif grade is 'D':" + "\n" + this.indent + "print(\"You passed\")" + "\n" + this.indent + "pass" + "\n" + "elif grade is 'F':" + "\n" + this.indent + "print(\"Better try again\")" + "\n" + this.indent + "pass" + "\n" + "else:" + "\n" + this.indent + "print(\"Invalid grade\")" + "\n" + this.indent + "pass" + "\n";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void switchStatement3() {
        String cStmt = "switch(var) {case 'A' : print(\"Excellent!\" ); break; default : {print(\"Invalid grade\" );break; }}";
        String pyStmt = "if var is 'A':\n" + this.indent + "print(\"Excellent!\")" + "\n" + this.indent + "pass" + "\n" + "else:" + "\n" + this.indent + "print(\"Invalid grade\")" + "\n" + this.indent + "pass" + "\n";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void switchStatement4() {
        String cStmt = "switch(var) {case 'A' : print(\"Excellent!\" ); break;}";
        String pyStmt = "if var is 'A':\n" + this.indent + "print(\"Excellent!\")" + "\n" + this.indent + "pass" + "\n";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void switchStatement2() {
        String cStmt = "switch(grade) {case 'A' : {print(\"Excellent!\" ); print(\"Bravo!\" ); break;} case 'B' : break;case 'C' :  print(\"Well done\" ); break; case 'D' : print(\"You passed\" ); break; case 'F' : {print(\"Better try again\" ); break;} default : break; }";
        String pyStmt = "if grade is 'A':\n" + this.indent + "print(\"Excellent!\")" + "\n" + this.indent + "print(\"Bravo!\")" + "\n" + this.indent + "pass" + "\n" + "elif grade is 'B':" + "\n" + this.indent + "pass" + "\n" + "elif grade is 'C':" + "\n" + this.indent + "print(\"Well done\")" + "\n" + this.indent + "pass" + "\n" + "elif grade is 'D':" + "\n" + this.indent + "print(\"You passed\")" + "\n" + this.indent + "pass" + "\n" + "elif grade is 'F':" + "\n" + this.indent + "print(\"Better try again\")" + "\n" + this.indent + "pass" + "\n" + "else:" + "\n" + this.indent + "pass" + "\n";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testStatement() {
        String cStmt = "enum1=a.b.c.d.e.f(); ";
        String pyStmt = "enum1 = a.b.c.d.e.f()";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testCompoundStatement() {
        String cStmt = "{enum1=a.b.c.d.e.f();} ";
        String pyStmt = "enum1 = a.b.c.d.e.f()";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testCompoundStatement2() {
        String cStmt = "{{enum1=a.b.c.d.e.f();}} ";
        String pyStmt = "enum1 = a.b.c.d.e.f()";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testEnum1() {
        String cStmt = "enum1=setEnum1(e); ";
        String pyStmt = "enum1 = setEnum1(e)";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testEnum2() {
        String cStmt = "enum1=a.b.c.d.e.setEnum1(e); ";
        String pyStmt = "enum1 = a.b.c.d.e.setEnum1(e)";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testEnum3() {
        String cStmt = "enum Enum1 enum1=UP; ";
        String pyStmt = "enum1 = UP\n";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testForLoops() {
        String cStmt = "for(Y currVar : y){return currVar.x.getY();}for(X currVar : x){return currVar.getY();}response_wait();";
        String pyStmt = "for currVar in y:\n" + this.indent + "return currVar.x.getY()" + "\n" + "for currVar in x:" + "\n" + this.indent + "return currVar.getY()" + "\n" + "response_wait()";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    @Test
    public void testForLoops2() {
        String cStmt = "for(Y currVar : y){b = true;}";
        String pyStmt = "for currVar in y:\n" + this.indent + "b = True";
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", null);
        this.checkStatementPair(cStmt, pyStmt, typeAssignmentCache);
    }

    private void checkStatementPair(String cleanCString, String expectedPythonResult, HashMap<String, Object> typeAssignmentCache) {
        try {
            Statement stmt = (Statement)this.stmtParseHelper.parse((CharSequence)cleanCString);
            SysMLElementExtractor elementExtractor = new SysMLElementExtractor(null, null, null);
            List<String> literalsNamesMap = null;
            CleanCTranslatorToPython cleanCTranslatorToPython = new CleanCTranslatorToPython(elementExtractor, false, literalsNamesMap);
            cleanCTranslatorToPython.addAllVariableInGlobalVariablesCache(typeAssignmentCache);
            String result = cleanCTranslatorToPython.process((EObject)stmt);
            Assert.assertTrue((String)("Wrong translation. \n Expected result: \n'" + expectedPythonResult + "'\n result: \n'" + result + "'"), (boolean)expectedPythonResult.equals(result));
        }
        catch (Exception e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }
}

