/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.test;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.core.visitors.CleanCTranslatorToPython;
import eu.fbk.eclipse.standardtools.utils.core.parser.ParseHelper;
import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import eu.fbk.eclipse.standardtools.utils.core.utils.SysMLElementExtractor;
import eu.fbk.tools.editor.c.c.TranslationUnit;
import eu.fbk.tools.editor.c.tests.CInjectorProvider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.testing.XtextRunner;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=CInjectorProvider.class)
public class TestClass {
    @Inject
    private ParseHelper<?> parseHelper;
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    @Before
    public void beforeTest() {
    }

    @Test
    public void testFiles() throws IOException {
        String userDir = System.getProperty("user.dir");
        String resourceCleanCDir = String.valueOf(userDir) + "/resources/cleanC";
        File cleanCFolder = new File(resourceCleanCDir);
        Object[] listOfCleanCFiles = cleanCFolder.listFiles();
        Arrays.sort(listOfCleanCFiles);
        int cleanCfiles = listOfCleanCFiles.length;
        String resourcePythonDir = String.valueOf(userDir) + "/resources/python";
        File pythonFolder = new File(resourcePythonDir);
        Object[] listOfPythonFiles = pythonFolder.listFiles();
        Arrays.sort(listOfPythonFiles);
        System.out.println("Found " + Integer.valueOf(cleanCfiles) + " models to be tested");
        HashMap<String, Object> typeAssignmentCache = new HashMap<String, Object>();
        typeAssignmentCache.put("locVar", new Pair(null, (Object)"Private"));
        typeAssignmentCache.put("locFun", new Pair(null, (Object)"Private"));
        List<String> literalsNamesMap = null;
        int i = 0;
        while (i < cleanCfiles) {
            String cModelStr = Files.toString((File)listOfCleanCFiles[i], (Charset)Charsets.UTF_8);
            String pyModelStr = Files.toString((File)listOfPythonFiles[i], (Charset)Charsets.UTF_8);
            this.checkClassPair(((File)listOfCleanCFiles[i]).getName(), cModelStr, pyModelStr, typeAssignmentCache, literalsNamesMap);
            ++i;
        }
    }

    private void checkClassPair(String fileName, String cleanCString, String expectedPythonResult, HashMap<String, Object> typeAssignmentCache, List<String> literalsNamesMap) {
        try {
            TranslationUnit expr = (TranslationUnit)this.parseHelper.parse((CharSequence)cleanCString);
            System.out.println("fileName: " + fileName);
            SysMLElementExtractor elementExtractor = new SysMLElementExtractor(null, null, null);
            CleanCTranslatorToPython cleanCTranslatorToPython = new CleanCTranslatorToPython(elementExtractor, false, literalsNamesMap);
            String result = cleanCTranslatorToPython.process((EObject)expr);
            Assert.assertTrue((String)("Wrong translation in file " + fileName + "\n Expected result: '\n" + expectedPythonResult + "'\n result: '\n" + result + "'"), (boolean)expectedPythonResult.equals(result));
        }
        catch (Exception e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }
}

