/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.core.utils;

import java.util.ArrayList;
import java.util.List;

public class PythonUtil {
    private boolean addSpace = true;
    public final String NewLine = "\n";
    public final String Ind = "    ";
    public static final String STATE_GETTER_PYTHON = "get_fsmState()";
    private static final String IS_TRIGGERED = "is_triggered";
    private static final String LEN = "len";
    public final String For = "for";
    public final String If = "if";
    private final String in = "in";
    public final String Return = "return";
    public final String Pass = "pass";
    public final String Self = "self";
    public final String Equal = "=";
    public final String LeftParen = "(";
    public final String RightParen = ")";
    public final String Dot = ".";
    public final String Comma = ",";
    public final String Colon = ":";
    public final String LogicalOrOperator = "or";
    public final String LogicalAndOperator = "and";
    public final String UnaryNotOperator = "not";
    public final String All = "all";
    public final String AllNotEmpty = "all_notempty";
    public final String Any = "any";
    public final String GreatThanOperator = ">";
    public final String LessThanOperator = "<";
    public final String GreatEqThanOperator = ">=";
    public final String LessEqThanOperator = "<=";
    public final String EqualOperator = "==";
    public final String TrueKeyword = "True";
    public final String FalseKeyword = "False";
    public final String New3Lines = "\n\n\n";
    public final String Def = "def";
    public final String Else = "else";
    public final String ElIf = "elif ";
    public final String LeftBracket = "[";
    public final String RightBracket = "]";
    public final String LeftBrace = "{";
    public final String RightBrace = "}";
    public final String AndOperator = "&";
    public final String existsOperationName = "exists";
    public final String existsCall = "exists()";
    public final String getCommandArgMethodName = "get_command_arg";
    public final String getCurrCommandArgMethodName = "get_current_command_arg";
    public final String ImpliesOp = "=>";
    public final String ExOrOperator = "^";
    public final String BreakKeyword = "break";
    public final String Assert = "assert";

    public String createIsTriggeredOperationCommand(String operationName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("'" + operationName + "'");
        return this.createSelfMethodCall(IS_TRIGGERED, args);
    }

    public String createSelfMethodCall(String methodName, List<String> args) {
        return "self." + this.createMethodCall(methodName, args);
    }

    public String createReturnStmt(String ind, String returnExprStr) {
        return String.valueOf(ind) + "return" + " " + returnExprStr;
    }

    public String createReturnStmt(String returnExprStr) {
        return "return " + returnExprStr;
    }

    private String addSpace() {
        if (this.addSpace) {
            return " ";
        }
        return "";
    }

    public String createBinaryProposition(String leftProp, String op, String rightProp) {
        return String.valueOf(leftProp) + this.addSpace() + op + this.addSpace() + rightProp;
    }

    public String createDotExpr(String leftExpr, String rightExpr) {
        if (leftExpr.equals("")) {
            return rightExpr;
        }
        return String.valueOf(leftExpr) + "." + rightExpr;
    }

    public String createOperationCall(String leftExpr, String rightExpr) {
        return String.valueOf(this.createDotExpr(leftExpr, rightExpr)) + "(" + ")";
    }

    public String createExistsPredicate(String list) {
        return "(len(" + list + ")" + ">" + "0" + ")";
    }

    private String addIndentation(String str, String ind) {
        return String.valueOf(ind) + str;
    }

    public String createImpliesStatement(String cond, String stmt) {
        return "not " + cond + " " + "or" + " " + stmt;
    }

    public String createStatementListWithNl(List<String> pyStmtList) {
        String res = "";
        int i = 0;
        while (i < pyStmtList.size()) {
            res = res.concat(pyStmtList.get(i));
            if (i != pyStmtList.size() - 1) {
                res = String.valueOf(res) + "\n";
            }
            ++i;
        }
        return res;
    }

    public String createAllExpression(String condition, String itId, String listId) {
        return "all(" + condition + " " + "for" + " " + itId + " " + "in" + " " + listId + ")";
    }

    public String createAllExpression(String condition, String itId, String listId, String filterCondition) {
        return "all(" + condition + " " + "for" + " " + itId + " " + "in" + " " + listId + " " + "if" + " " + filterCondition + ")";
    }

    public String createAllExpressionNotEmpty(String expr, String itId, String listId) {
        return "all_notempty(" + expr + " " + "for" + " " + itId + " " + "in" + " " + listId + ")";
    }

    public String createAllExpressionNotEmpty(String expr, String itId, String listId, String filterCondition) {
        return "all_notempty(" + expr + " " + "for" + " " + itId + " " + "in" + " " + listId + " " + "if" + " " + filterCondition + ")";
    }

    public String createAllStatement(String exprInd, String expr, String itId, String listId) {
        return "for " + itId + " " + "in" + " " + listId + ":" + "\n" + this.addIndentation(expr, exprInd);
    }

    public String createExprInParens(String expr) {
        if (expr == null) {
            return "()";
        }
        return "(" + expr + ")";
    }

    public String createNotProposition(String expr) {
        return "not" + this.addSpace() + expr;
    }

    public String createInclOrProposition(String leftProp, String rightProp) {
        if (leftProp.equals("")) {
            return rightProp;
        }
        return this.createBinaryProposition(leftProp, "or", rightProp);
    }

    public String createLogicAndProposition(String leftProp, String rightProp) {
        if (leftProp.equals("")) {
            return rightProp;
        }
        return this.createBinaryProposition(leftProp, "and", rightProp);
    }

    public String createPythonGetterCall(String attrName, List<String> args) {
        String argsStr = null;
        if (args != null) {
            argsStr = this.createStatementListWithCommas(args);
        }
        String argsStrInParens = this.createExprInParens(argsStr);
        return "get_" + attrName + argsStrInParens;
    }

    public String createPythonSelfGetterCall(String attrName, List<String> args) {
        return "self." + this.createPythonGetterCall(attrName, args);
    }

    public String createPythonSetterCall(String attrName, List<String> args) {
        String argsStr = null;
        if (args != null) {
            argsStr = this.createStatementListWithCommas(args);
        }
        String argsStrInParens = this.createExprInParens(argsStr);
        return "set_" + attrName + argsStrInParens;
    }

    public String createMethodCall(String methodName, List<String> args) {
        String argsStr = null;
        if (args != null) {
            argsStr = this.createStatementListWithCommas(args);
        }
        String argsStrInParens = this.createExprInParens(argsStr);
        return String.valueOf(methodName) + argsStrInParens;
    }

    public String createStatementListWithCommas(List<String> pyStmtList) {
        String res = "";
        int i = 0;
        while (i < pyStmtList.size()) {
            if (i != 0) {
                res = res.concat(",");
            }
            res = res.concat(pyStmtList.get(i));
            ++i;
        }
        return res;
    }

    public String createIfStatement(String cond, String indStmt, String stmt) {
        return "if " + cond + ":" + "\n" + this.addIndentation(stmt, indStmt);
    }

    public String createAssignmentExpr(String left, String op, String right) {
        return String.valueOf(left) + this.addSpace() + op + this.addSpace() + right;
    }

    public String createForStmt(String addIndentation, String iterId, String listId, String stmt) {
        return String.valueOf(addIndentation) + "for" + " " + iterId + " in " + listId + ":" + "\n" + stmt;
    }

    public String createElseStatement(String ind, String stmt) {
        return String.valueOf(ind) + "else" + ":" + "\n" + stmt;
    }

    public boolean isExistsCall(String pyId) {
        return pyId.equals("exists()");
    }

    public String createGetCurrCommandArgStr(String argName) throws Exception {
        return String.valueOf(argName) + " = self" + "." + "get_current_command_arg" + "('" + argName + "')";
    }

    public String getCommandArgMethodName(String operationName, String argAsStr) {
        return "self.get_command_arg('" + operationName + "'" + "," + "'" + argAsStr + "')";
    }

    public String createFunctionDeclaration(String indentation, String funcDecl, String funcStmt) {
        return String.valueOf(indentation) + "def" + " " + funcDecl + ":" + "\n" + funcStmt;
    }

    public String createPyAssert(String addIndentation, String pyExpr) {
        return String.valueOf(addIndentation) + "assert" + " " + pyExpr;
    }

    public String createPassStmt(String ind) {
        return String.valueOf(ind) + "pass";
    }

    public String createStmt(String ind, String expr) {
        return String.valueOf(ind) + expr;
    }

    public String createDeclarator(String ind, String declName, String initValue) {
        return String.valueOf(ind) + declName + " " + "=" + " " + initValue;
    }

    public String createBooleanId(boolean booleanValue) {
        return booleanValue ? "True" : "False";
    }

    public String createSelfDotExpr(String idName) {
        return "self." + idName;
    }

    public String createExprInBrackets(String expr) {
        return "[" + expr + "]";
    }

    public String createUnaryProposition(String op, String expr) {
        return String.valueOf(op) + expr;
    }

    public String createAndProposition(String leftProp, String rightProp) {
        if (leftProp.equals("")) {
            return rightProp;
        }
        return this.createBinaryProposition(leftProp, "&", rightProp);
    }

    public String createExclOrProposition(String leftProp, String rightProp) {
        return this.createBinaryProposition(leftProp, "^", rightProp);
    }

    public String createLogicOrProposition(String leftProp, String rightProp) {
        if (leftProp.equals("")) {
            return rightProp;
        }
        return this.createBinaryProposition(leftProp, "or", rightProp);
    }

    public String createExprInBraces(String expr) {
        return "{" + expr + "}";
    }

    public String createBreakStmt(String ind) {
        return String.valueOf(ind) + "break";
    }

    public String createStatementList(List<String> pyStmtList) {
        String res = "";
        int i = 0;
        while (i < pyStmtList.size()) {
            res = res.concat(pyStmtList.get(i));
            ++i;
        }
        return res;
    }

    public String createStatementListWithSpacesAndCommas(List<String> pyStmtList) {
        String res = "";
        int i = 0;
        while (i < pyStmtList.size()) {
            if (i != 0) {
                res = res.concat(this.addSpace());
            }
            res = res.concat(pyStmtList.get(i));
            if (i != pyStmtList.size() - 1) {
                res = res.concat(",");
            }
            ++i;
        }
        return res;
    }

    public String createAnyExpression(String expr, String itId, String listId) {
        return "any(" + expr + " " + "for" + " " + itId + " " + "in" + " " + listId + ")";
    }

    public String createAnyExpression(String condition, String filter, String itId, String listId) {
        return "any(" + condition + " " + "for" + " " + itId + " " + "in" + " " + listId + " " + "if" + " " + filter + ")";
    }
}

