/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.command.AbstractPapyrusHandler;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractCommandHandler
extends AbstractPapyrusHandler {
    private List<?> selection = Collections.EMPTY_LIST;

    protected abstract Command getCommand(IEvaluationContext var1);

    protected Command getCommand(ExecutionEvent event) {
        Command result = null;
        Object context = event.getApplicationContext();
        if (!(context instanceof IEvaluationContext)) {
            throw new IllegalArgumentException("No evaluation context in execution event: " + event);
        }
        result = this.getCommand((IEvaluationContext)context);
        return result;
    }

    protected List<?> getSelection() {
        return this.selection;
    }

    protected EObject getSelectedElement() {
        Object first;
        EObject businessObject;
        EObject eObject = null;
        List<?> selection = this.getSelection();
        if (!selection.isEmpty() && (businessObject = EMFHelper.getEObject(first = selection.get(0))) != null) {
            eObject = businessObject;
        }
        return eObject;
    }

    protected List<EObject> getSelectedElements() {
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        List<?> selection = this.getSelection();
        if (!selection.isEmpty()) {
            for (Object current : selection) {
                EObject selectedEObject = EMFHelper.getEObject(current);
                if (selectedEObject == null) continue;
                selectedEObjects.add(selectedEObject);
            }
        }
        return selectedEObjects;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            try {
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                this.selection = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.EMPTY_LIST;
                ServiceUtilsForHandlers.getInstance().getTransactionalEditingDomain(event).getCommandStack().execute(this.getCommand(event));
            }
            catch (ServiceException e) {
                Activator.log.error("Unexpected error while executing command.", (Throwable)e);
                this.selection = Collections.EMPTY_LIST;
            }
        }
        finally {
            this.selection = Collections.EMPTY_LIST;
        }
        return null;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        boolean result = false;
        Command command = this.getCommand(context);
        if (command != null) {
            result = command.canExecute();
            command.dispose();
        }
        return result;
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext context = (IEvaluationContext)evaluationContext;
            Object selection = ((IEvaluationContext)evaluationContext).getDefaultVariable();
            if (selection instanceof Collection) {
                this.selection = selection instanceof List ? (List)selection : new ArrayList((Collection)selection);
                this.setBaseEnabled(this.computeEnabled(context));
                this.selection = Collections.EMPTY_LIST;
            }
        }
        super.setEnabled(evaluationContext);
    }
}

