/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.edit.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.Activator;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;

public class ElementTypeUtils {
    protected ElementTypeUtils() {
    }

    public static final Collection<IElementType> getAllExistingElementTypes() {
        IClientContext clientContext = ElementTypeUtils.getEditContext();
        IElementType[] types = ElementTypeRegistry.getInstance().getElementTypes(clientContext);
        return Arrays.asList(types);
    }

    public static final Collection<String> getAllExistingElementTypesIds() {
        TreeSet<String> ids = new TreeSet<String>();
        for (IElementType iElementType : ElementTypeUtils.getAllExistingElementTypes()) {
            ids.add(iElementType.getId());
        }
        return ids;
    }

    public static IClientContext getEditContext() {
        IClientContext result = null;
        try {
            result = TypeContext.getContext();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return result;
    }

    public static boolean useGUI(IEditCommandRequest request) {
        Object value = request.getParameter("USE_GUI");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            Boolean booleanObject = Boolean.valueOf((String)value);
            return booleanObject;
        }
        return true;
    }

    public static boolean dialogCancellable(IEditCommandRequest request) {
        Object value = request.getParameter("DIALOG_CANCELLABLE");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            Boolean booleanObject = Boolean.valueOf((String)value);
            return booleanObject;
        }
        return false;
    }

    public static void setUseGUI(IEditCommandRequest request, boolean useGUI) {
        request.setParameter("USE_GUI", (Object)useGUI);
    }

    public static void setDialogCancellable(IEditCommandRequest request, boolean dialogCancellable) {
        request.setParameter("DIALOG_CANCELLABLE", (Object)dialogCancellable);
    }
}

