/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import com.google.common.base.Objects;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFHyperlinkDescription;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFHyperlinkController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFHyperlinkController
extends AbstractEEFWidgetController
implements IEEFHyperlinkController {
    private EEFHyperlinkDescription description;
    private EditingContextAdapter contextAdapter;
    private IConsumer<Object> newValueConsumer;

    public EEFHyperlinkController(EEFHyperlinkDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
        this.contextAdapter = contextAdapter;
    }

    @Override
    public void refresh() {
        super.refresh();
        String valueExpression = this.description.getValueExpression();
        Object valueExpressionResult = this.newEval().evaluate(valueExpression);
        this.newValueConsumer.apply(valueExpressionResult);
    }

    @Override
    public String computeDisplayValue(Object value) {
        String displayExpression = this.description.getDisplayExpression();
        String text = null;
        if (!Util.isBlank((String)displayExpression)) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(this.variableManager.getVariables());
            variables.put("value", value);
            text = EvalFactory.of(this.interpreter, variables).logIfInvalidType(String.class).evaluate(displayExpression);
        }
        return (String)Objects.firstNonNull(text, (Object)"");
    }

    @Override
    public IStatus onClick(final Object element) {
        return this.contextAdapter.performModelChange(new Runnable(){

            @Override
            public void run() {
                String expression = EEFHyperlinkController.this.description.getOnClickExpression();
                EAttribute attr = EefPackage.Literals.EEF_HYPERLINK_DESCRIPTION__ON_CLICK_EXPRESSION;
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.putAll(EEFHyperlinkController.this.variableManager.getVariables());
                variables.put("selection", element);
                EvalFactory.of(EEFHyperlinkController.this.interpreter, variables).logIfBlank(attr).call(expression);
            }
        });
    }

    @Override
    public void onNewValue(IConsumer<Object> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }

    @Override
    public IStatus action(final EEFWidgetAction action) {
        return this.contextAdapter.performModelChange(new Runnable(){

            @Override
            public void run() {
                String expression = action.getActionExpression();
                EAttribute eAttribute = EefPackage.Literals.EEF_WIDGET_ACTION__ACTION_EXPRESSION;
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.putAll(EEFHyperlinkController.this.variableManager.getVariables());
                EvalFactory.of(EEFHyperlinkController.this.interpreter, variables).logIfBlank(eAttribute).call(expression);
            }
        });
    }
}

