/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.api.controllers;

import java.text.MessageFormat;
import org.eclipse.eef.EEFCustomExpression;
import org.eclipse.eef.EEFCustomWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.internal.EEFCorePlugin;
import org.eclipse.eef.core.internal.Messages;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public abstract class AbstractEEFCustomWidgetController
extends AbstractEEFWidgetController {
    protected EEFCustomWidgetDescription description;
    protected EditingContextAdapter contextAdapter;

    public AbstractEEFCustomWidgetController(EEFCustomWidgetDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
        this.contextAdapter = contextAdapter;
    }

    protected abstract EEFCustomWidgetDescription getDescription();

    protected String getCustomExpression(String customExpressionId) {
        EEFCustomWidgetDescription customDescription = this.getDescription();
        if (customDescription != null) {
            for (EEFCustomExpression eefCustomExpression : customDescription.getCustomExpressions()) {
                if (eefCustomExpression == null || customExpressionId == null || !customExpressionId.equals(eefCustomExpression.getIdentifier())) continue;
                return eefCustomExpression.getCustomExpression();
            }
        }
        String message = MessageFormat.format(Messages.AbstractEEFWidgetController_NoCustomExpressionFoundForID, customExpressionId);
        EEFCorePlugin.getPlugin().error(message);
        return null;
    }

    protected void executeCommandExpression(final String customExpressionId) {
        this.contextAdapter.performModelChange(new Runnable(){

            @Override
            public void run() {
                String pushExpression = AbstractEEFCustomWidgetController.this.getCustomExpression(customExpressionId);
                EAttribute attr = EefPackage.Literals.EEF_CUSTOM_EXPRESSION__CUSTOM_EXPRESSION;
                AbstractEEFCustomWidgetController.this.newEval().logIfBlank(attr).call(pushExpression);
            }
        });
    }
}

