/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagram.ui.services;

import eu.fbk.eclipse.standardtools.diagram.DiagramDescriptor;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.StateMachine;

public class CHESSDiagramsGeneratorService {
    private static CHESSDiagramsGeneratorService instance;
    private static final String IBD = "InternalBlock";
    private static final String BDD = "BlockDefinition";
    private static final String STMD = "PapyrusUMLStateMachineDiagram";
    private static final String ERROR_MODEL = "CHESS::Dependability::ThreatsPropagation::ErrorModel";
    private static final Logger logger;
    private String directoryName;
    private String imageExtension;

    static {
        logger = Logger.getLogger(CHESSDiagramsGeneratorService.class);
    }

    public static CHESSDiagramsGeneratorService getInstance() {
        if (instance == null) {
            instance = new CHESSDiagramsGeneratorService();
        }
        return instance;
    }

    public void setParametersBeforeDiagramsGenerator(String directoryName, String imageExtension) {
        this.directoryName = directoryName;
        this.imageExtension = imageExtension;
    }

    public DiagramDescriptor createDiagramWithDescriptor(Diagram diagram, Shell shell, IProgressMonitor monitor) {
        EObject diagramOwner = DiagramUtils.getOwner((Diagram)diagram);
        String diagramName = "";
        String ownerName = null;
        boolean hasComponentOwner = true;
        int weight = 0;
        if (diagramOwner instanceof Class) {
            if (diagramOwner instanceof StateMachine) {
                ownerName = ((Class)((StateMachine)diagramOwner).getOwner()).getName();
                diagramName = String.valueOf(ownerName) + "_" + diagram.getName();
            } else {
                ownerName = ((Class)diagramOwner).getName();
                diagramName = String.valueOf(ownerName) + "_" + diagram.getName();
            }
        } else {
            hasComponentOwner = false;
            diagramName = diagram.getName();
        }
        if (this.isBlockDefinitionDiagram(diagram)) {
            weight = 1;
        } else if (this.isInternalBlockDiagram(diagram)) {
            weight = 2;
        } else if (this.isStateMachineDiagram(diagram)) {
            weight = UMLUtil.getAppliedStereotype((Element)((Class)diagramOwner), (String)ERROR_MODEL, (boolean)true) != null ? 4 : 3;
        }
        CopyToImageUtil copyImageUtil = new CopyToImageUtil();
        String saveFilePath = this.getComponentImageFilePath(diagramName);
        Path imagePath = new Path(saveFilePath);
        try {
            if (saveFilePath.endsWith("svg")) {
                copyImageUtil.copyToImage(diagram, (IPath)imagePath, ImageFileFormat.SVG, (IProgressMonitor)new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
            } else if (saveFilePath.endsWith("pdf")) {
                copyImageUtil.copyToImage(diagram, (IPath)imagePath, ImageFileFormat.PDF, (IProgressMonitor)new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
            }
            return this.createDiagramDescriptor(diagramName, ownerName, hasComponentOwner, weight);
        }
        catch (CoreException coreException) {
            logger.error((Object)("Unable to create diagram " + diagramName));
            return null;
        }
    }

    private DiagramDescriptor createDiagramDescriptor(String diagramName, String ownerName, boolean hasComponentOwner, int weight) {
        String saveFilePath = this.getComponentImageFilePath(diagramName);
        logger.debug((Object)("saveFilePath: " + saveFilePath));
        DiagramDescriptor diagramDescriptor = this.createDiagramDescriptorWithImageFileUrl(diagramName, saveFilePath, ownerName, hasComponentOwner, weight);
        return diagramDescriptor;
    }

    private DiagramDescriptor createDiagramDescriptorWithImageFileUrl(String diagramName, String saveFilePath, String owner, boolean hasComponentOwner, int weight) {
        String diagramFileName;
        DiagramDescriptor diagramDescriptor = new DiagramDescriptor();
        diagramDescriptor.name = diagramName;
        diagramDescriptor.hasComponentOwner = hasComponentOwner;
        if (owner != null) {
            diagramDescriptor.ownerName = owner;
        }
        try {
            diagramFileName = new File(saveFilePath).toURI().toURL().getFile();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        diagramDescriptor.url = FilenameUtils.getName((String)diagramFileName);
        diagramDescriptor.weight = weight;
        return diagramDescriptor;
    }

    public Collection<Diagram> getDiagrams() {
        NotationModel notationModel = NotationUtils.getNotationModel();
        Set<Diagram> diagrams = this.getChessDiagrams(notationModel.getResources());
        return diagrams;
    }

    public Set<Diagram> getDiagrams(Set<Resource> resources) {
        HashSet<Diagram> diagrams = new HashSet<Diagram>();
        for (Resource current : resources) {
            for (EObject element : current.getContents()) {
                if (!(element instanceof Diagram)) continue;
                diagrams.add((Diagram)element);
            }
        }
        return diagrams;
    }

    private Set<Diagram> getChessDiagrams(Set<Resource> resources) {
        HashSet<Diagram> diagrams = new HashSet<Diagram>();
        for (Resource current : resources) {
            for (EObject element : current.getContents()) {
                Diagram diagram;
                if (!(element instanceof Diagram) || !this.isBlockDefinitionDiagram(diagram = (Diagram)element) && !this.isInternalBlockDiagram(diagram) && !this.isStateMachineDiagram(diagram)) continue;
                diagrams.add((Diagram)element);
            }
        }
        return diagrams;
    }

    private boolean isBlockDefinitionDiagram(Diagram diagram) {
        return diagram.getType().compareTo(BDD) == 0;
    }

    private boolean isInternalBlockDiagram(Diagram diagram) {
        return diagram.getType().compareTo(IBD) == 0;
    }

    private boolean isStateMachineDiagram(Diagram diagram) {
        return diagram.getType().compareTo(STMD) == 0;
    }

    private String getComponentImageFilePath(String fileName) {
        return String.valueOf(this.directoryName) + File.separator + fileName + this.imageExtension;
    }
}

