/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.utils;

import com.google.inject.Injector;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.tools.editor.basetype.baseType.BooleanType;
import eu.fbk.tools.editor.basetype.baseType.BoundedArrayType;
import eu.fbk.tools.editor.basetype.baseType.ContinuousType;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.basetype.baseType.EventType;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.basetype.baseType.FixedSizeArrayType;
import eu.fbk.tools.editor.basetype.baseType.Identifier;
import eu.fbk.tools.editor.basetype.baseType.IntegerLiteral;
import eu.fbk.tools.editor.basetype.baseType.IntegerType;
import eu.fbk.tools.editor.basetype.baseType.RangeType;
import eu.fbk.tools.editor.basetype.baseType.RealType;
import eu.fbk.tools.editor.basetype.baseType.SignedWordType;
import eu.fbk.tools.editor.basetype.baseType.SimpleType;
import eu.fbk.tools.editor.basetype.baseType.UnboundedArrayType;
import eu.fbk.tools.editor.basetype.baseType.UnsignedWordType;
import eu.fbk.tools.editor.basetype.baseType.WordArrayType;
import eu.fbk.tools.editor.basetype.baseType.WordType;
import eu.fbk.tools.editor.contract.contract.Assumption;
import eu.fbk.tools.editor.contract.contract.Contract;
import eu.fbk.tools.editor.contract.contract.Guarantee;
import eu.fbk.tools.editor.contract.expression.expression.ArrayIndex;
import eu.fbk.tools.editor.contract.expression.expression.ComponentId;
import eu.fbk.tools.editor.contract.expression.expression.FullParameterId;
import eu.fbk.tools.editor.contract.expression.expression.FullPortId;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBound;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBounds;
import eu.fbk.tools.editor.contract.expression.expression.VariableId;
import eu.fbk.tools.editor.oss.oss.AbstractComponent;
import eu.fbk.tools.editor.oss.oss.Assertion;
import eu.fbk.tools.editor.oss.oss.ComplexType;
import eu.fbk.tools.editor.oss.oss.Component;
import eu.fbk.tools.editor.oss.oss.Connection;
import eu.fbk.tools.editor.oss.oss.Define;
import eu.fbk.tools.editor.oss.oss.FullContractIdList;
import eu.fbk.tools.editor.oss.oss.InputPort;
import eu.fbk.tools.editor.oss.oss.InterfaceInstance;
import eu.fbk.tools.editor.oss.oss.IterativeCondition;
import eu.fbk.tools.editor.oss.oss.OSS;
import eu.fbk.tools.editor.oss.oss.OutputPort;
import eu.fbk.tools.editor.oss.oss.Parameter;
import eu.fbk.tools.editor.oss.oss.ParameterAssumptions;
import eu.fbk.tools.editor.oss.oss.ParameterizedArrayType;
import eu.fbk.tools.editor.oss.oss.Port;
import eu.fbk.tools.editor.oss.oss.Refinement;
import eu.fbk.tools.editor.oss.oss.RefinementInstance;
import eu.fbk.tools.editor.oss.oss.SubComponent;
import eu.fbk.tools.editor.oss.oss.SubComponentType;
import eu.fbk.tools.editor.oss.oss.Variable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;

public class OSSModelUtil {
    private static final Logger logger = Logger.getLogger(OSSModelUtil.class);
    SaveOptions noValidOptions = SaveOptions.newBuilder().noValidation().getOptions();
    private XTextResourceUtil xtextResourceUtil = XTextResourceUtil.getInstance();
    private static OSSModelUtil ocraModelUtil;
    String assumeWord = "assume :";
    String guaranteeWord = "guarantee :";

    public static OSSModelUtil getInstance() {
        if (ocraModelUtil == null) {
            ocraModelUtil = new OSSModelUtil();
        }
        return ocraModelUtil;
    }

    public File generateOssFileFromOssModel(String path, String fileName, Object ocraModel) throws Exception {
        File ossFile = this.generateOSSFile(fileName, (OSS)ocraModel, path);
        return ossFile;
    }

    public boolean isInputPort(Variable variable) {
        return variable instanceof InputPort;
    }

    public boolean isOutputPort(Variable variable) {
        return variable instanceof OutputPort;
    }

    private Set<String> getAllContactPropertiesIDOfComponentTypeAndSubComponentsInstance(String componentTypeName, OSS ocraModel, boolean validateElement) throws IOException {
        Set<String> contractPropertiesID = this.getContractPropertiesIDFromComponentTypeName(componentTypeName, ocraModel);
        String componentInstancePrefix = "";
        this.getAllContractPropertiesIDOfDescendenceComponentsInstance(componentTypeName, ocraModel, componentInstancePrefix, contractPropertiesID, validateElement);
        return contractPropertiesID;
    }

    public String[] getAllContactPropertiesIDOfSubComponentsAsStr(String componentTypeName, OSS ocraModel, boolean validateElement) throws IOException {
        Object[] propertiesIDs = this.getAllContactPropertiesIDOfComponentTypeAndSubComponentsInstance(componentTypeName, ocraModel, validateElement).toArray(new String[0]);
        Arrays.sort(propertiesIDs);
        return propertiesIDs;
    }

    public boolean isSimplePortToPortConnection(Connection connection) {
        return this.isConnectionWithNoArray(connection.getVariable(), connection.getConstraint(), connection.getIterativeCondition());
    }

    public boolean isConnectionWithNoArray(FullVariableId variable, Expression constraint, IterativeCondition iterCondition) {
        return !(!(constraint instanceof FullPortId) && !(constraint instanceof FullParameterId) || iterCondition != null && iterCondition.getConstraint() != null || !(variable instanceof FullPortId) && !(variable instanceof FullParameterId) || this.isVariableWithArray(variable) || this.isVariableWithArray((FullVariableId)constraint));
    }

    public boolean isVariableWithArray(FullVariableId variable) {
        if (variable.getId().getIndexes() != null && !variable.getId().getIndexes().isEmpty()) {
            return true;
        }
        for (ComponentId subCompId : variable.getFullComponentIds()) {
            if (subCompId.getIndexes() == null || subCompId.getIndexes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isPortIdWithNoIterators(FullPortId portId) {
        return portId.getId().getIndexes() == null;
    }

    private String getSimpleTypeAsStr(SimpleType type) {
        if (type instanceof BooleanType) {
            return "Boolean";
        }
        if (type instanceof IntegerType) {
            return "Integer";
        }
        if (type instanceof RealType) {
            return "Real";
        }
        if (type instanceof RangeType) {
            return "Range " + this.getRangeTypeValuesAsStr((RangeType)type);
        }
        if (type instanceof ContinuousType) {
            return "Continuous";
        }
        if (type instanceof EventType) {
            return "Event";
        }
        if (type instanceof EnumType) {
            return "Enum " + this.getEnumTypeValuesAsStr((EnumType)type);
        }
        if (type instanceof FixedSizeArrayType) {
            return this.getSimpleTypeAsStr(((FixedSizeArrayType)type).getType());
        }
        if (type instanceof BoundedArrayType) {
            return this.getSimpleTypeAsStr(((BoundedArrayType)type).getType());
        }
        if (type instanceof UnboundedArrayType) {
            return this.getSimpleTypeAsStr(((UnboundedArrayType)type).getType());
        }
        return null;
    }

    public String getTypeAsStr(ComplexType type) {
        return this.getSimpleTypeAsStr(this.getSimpleType(type));
    }

    private String getRangeTypeValuesAsStr(RangeType type) {
        String range = "[]";
        RangeType rangeType = type;
        if (rangeType.getLowerBound() instanceof IntegerLiteral && rangeType.getUpperBound() instanceof IntegerLiteral) {
            IntegerLiteral intLit = (IntegerLiteral)rangeType.getLowerBound();
            range = "[" + intLit.getValue();
            intLit = (IntegerLiteral)rangeType.getUpperBound();
            range = String.valueOf(range) + " .. " + intLit.getValue() + "]";
        }
        return range;
    }

    private String getEnumTypeValuesAsStr(EnumType type) {
        String enumValues = "[";
        for (EObject object : type.getValues()) {
            enumValues = String.valueOf(enumValues) + ((Identifier)object).getValue() + ", ";
        }
        if (enumValues.length() > 1) {
            enumValues = enumValues.substring(0, enumValues.length() - 2);
        }
        enumValues = String.valueOf(enumValues) + "]";
        return enumValues;
    }

    public String getVariableRangeAsStr(Variable variable) {
        if (this.isRangeTypeVariable(variable)) {
            if (variable instanceof Port) {
                SimpleType type = this.getSimpleType(((Port)variable).getType());
                return this.getRangeTypeValuesAsStr((RangeType)type);
            }
            if (variable instanceof Parameter) {
                SimpleType type = this.getSimpleType(((Parameter)variable).getType());
                return this.getRangeTypeValuesAsStr((RangeType)type);
            }
        }
        return "";
    }

    public String getVariableEnumTypeValuesAsStr(Variable variable) {
        if (this.isEnumTypeVariable(variable)) {
            if (variable instanceof Port) {
                SimpleType type = this.getSimpleType(((Port)variable).getType());
                return this.getEnumTypeValuesAsStr((EnumType)type);
            }
            if (variable instanceof Parameter) {
                SimpleType type = this.getSimpleType(((Parameter)variable).getType());
                return this.getEnumTypeValuesAsStr((EnumType)type);
            }
        }
        return "";
    }

    public boolean isRangeTypeVariable(Variable variable) {
        SimpleType type = null;
        if (variable instanceof Port) {
            type = this.getSimpleType(((Port)variable).getType());
        }
        if (variable instanceof Parameter) {
            type = this.getSimpleType(((Parameter)variable).getType());
        }
        return type instanceof RangeType;
    }

    public boolean isEnumTypeVariable(Variable variable) {
        SimpleType type = null;
        if (variable instanceof Port) {
            type = this.getSimpleType(((Port)variable).getType());
        }
        if (variable instanceof Parameter) {
            type = this.getSimpleType(((Parameter)variable).getType());
        }
        return type instanceof EnumType;
    }

    public SimpleType getSimpleType(ComplexType type) {
        if (type.getComplexType() instanceof ParameterizedArrayType) {
            return ((ParameterizedArrayType)type.getComplexType()).getType();
        }
        return (SimpleType)type.getComplexType();
    }

    public boolean isEventType(Variable variable) {
        SimpleType type = null;
        if (variable instanceof Port) {
            type = this.getSimpleType(((Port)variable).getType());
        }
        if (variable instanceof Parameter) {
            type = this.getSimpleType(((Parameter)variable).getType());
        }
        return type instanceof EventType;
    }

    public Set<SubComponent> getSubComponentsInstance(AbstractComponent component) {
        Refinement refinement;
        HashSet<SubComponent> subComponents = new HashSet<SubComponent>();
        if (component.getRefinement() != null && (refinement = component.getRefinement()).getRefinements() != null) {
            for (RefinementInstance refinementInstance : refinement.getRefinements()) {
                if (refinementInstance.getSubcomponent() == null) continue;
                SubComponent subcomponent = refinementInstance.getSubcomponent();
                subComponents.add(subcomponent);
            }
        }
        return subComponents;
    }

    public AbstractComponent getComponent(String componentType, OSS ocraModel) {
        if (ocraModel.getSystem().getType().compareTo(componentType) == 0) {
            return ocraModel.getSystem();
        }
        for (Component ocraComponent : ocraModel.getComponents()) {
            String currComponentType = ocraComponent.getType();
            if (currComponentType.compareTo(componentType) != 0) continue;
            return ocraComponent;
        }
        return null;
    }

    public String[] getComponentTypes(OSS ocraModel) {
        ArrayList<String> componentTypes = new ArrayList<String>();
        if (ocraModel.getSystem().getType() != null) {
            String systemType = ocraModel.getSystem().getType();
            componentTypes.add(systemType);
        }
        for (Component ocraComponent : ocraModel.getComponents()) {
            String componentType = ocraComponent.getType();
            componentTypes.add(componentType);
        }
        return componentTypes.toArray(new String[0]);
    }

    private Set<String> getAllContractPropertiesIDOfComponentTypeAndSubComponentsInstance(String componentTypeName, OSS ocraModel, boolean validateElement) throws IOException {
        Set<String> contractPropertiesID = this.getContractPropertiesIDFromComponentTypeName(componentTypeName, ocraModel);
        String componentInstancePrefix = "";
        this.getAllContractPropertiesIDOfDescendenceComponentsInstance(componentTypeName, ocraModel, componentInstancePrefix, contractPropertiesID, validateElement);
        return contractPropertiesID;
    }

    private Set<String> getAllAssertionsIDOfComponentTypeAndSubComponentsInstance(String componentTypeName, OSS ocraModel, boolean validateElement) throws IOException {
        Set<String> contractPropertiesID = this.getAssertionsIDFromComponentTypeName(componentTypeName, ocraModel);
        contractPropertiesID.addAll(this.getAllAssertionsIDOfSubComponentsInstance(componentTypeName, ocraModel, validateElement));
        return contractPropertiesID;
    }

    private Set<String> getAllAssertionsIDOfSubComponentsInstance(String componentTypeName, OSS ocraModel, boolean validateElement) throws IOException {
        AbstractComponent component = this.getComponent(componentTypeName, ocraModel);
        logger.debug((Object)("component.getType(): " + component.getType()));
        HashSet<String> assertionsID = new HashSet<String>();
        Set<SubComponent> subComponentsInstance = this.getSubComponentsInstance(component);
        logger.debug((Object)("num subComponentsInstance: " + subComponentsInstance.size()));
        for (SubComponent subComponentInstance : subComponentsInstance) {
            assertionsID.addAll(this.getAssertionsNameFromComponentInstance(subComponentInstance, ocraModel, validateElement));
        }
        return assertionsID;
    }

    private void getAllAssertionsIDOfDescendenceComponentsInstance(String componentTypeName, OSS ocraModel, String componentInstancePrefix, Set<String> assertionsID, boolean validateElement) throws IOException {
        AbstractComponent component = this.getComponent(componentTypeName, ocraModel);
        logger.debug((Object)("component.getType(): " + component.getType()));
        Set<SubComponent> subComponentsInstance = this.getSubComponentsInstance(component);
        logger.debug((Object)("num subComponentsInstance: " + subComponentsInstance.size()));
        for (SubComponent subComponentInstance : subComponentsInstance) {
            this.getAssertionsNameFromDescendanceComponentInstance(subComponentInstance, ocraModel, componentInstancePrefix, assertionsID, validateElement);
        }
    }

    private void getAllContractPropertiesIDOfDescendenceComponentsInstance(String componentTypeName, OSS ocraModel, String componentInstancePrefix, Set<String> assertionsID, boolean validateElement) throws IOException {
        AbstractComponent component = this.getComponent(componentTypeName, ocraModel);
        logger.debug((Object)("component.getType(): " + component.getType()));
        Set<SubComponent> subComponentsInstance = this.getSubComponentsInstance(component);
        logger.debug((Object)("num subComponentsInstance: " + subComponentsInstance.size()));
        for (SubComponent subComponentInstance : subComponentsInstance) {
            this.getContractsNameFromDescendanceComponentInstance(subComponentInstance, ocraModel, componentInstancePrefix, assertionsID, validateElement);
        }
    }

    public String[] getAllContractPropertiesIDOfSubComponentsAsStr(String componentTypeName, OSS ocraModel, boolean validateElement) throws IOException {
        Object[] propertiesIDs = this.getAllContractPropertiesIDOfComponentTypeAndSubComponentsInstance(componentTypeName, ocraModel, validateElement).toArray(new String[0]);
        Arrays.sort(propertiesIDs);
        return propertiesIDs;
    }

    public String[] getAllAssertionsIDOfSubComponentsAsStr(String componentTypeName, OSS ocraModel, boolean validateElement) throws IOException {
        Object[] propertiesIDs = this.getAllAssertionsIDOfComponentTypeAndSubComponentsInstance(componentTypeName, ocraModel, validateElement).toArray(new String[0]);
        Arrays.sort(propertiesIDs);
        return propertiesIDs;
    }

    public String[] getAllAssertionsIDOfDescendenceComponentsAsStr(String componentTypeName, OSS ocraModel, boolean validateElement) throws IOException {
        Object[] propertiesIDs = this.getAllAssertionsIDOfComponentTypeAndDescendanceComponentsInstance(componentTypeName, ocraModel, validateElement).toArray(new String[0]);
        Arrays.sort(propertiesIDs);
        return propertiesIDs;
    }

    private Set<String> getAllAssertionsIDOfComponentTypeAndDescendanceComponentsInstance(String componentTypeName, OSS ocraModel, boolean validateElement) throws IOException {
        Set<String> contractPropertiesID = this.getAssertionsIDFromComponentTypeName(componentTypeName, ocraModel);
        String componentInstancePrefix = "";
        this.getAllAssertionsIDOfDescendenceComponentsInstance(componentTypeName, ocraModel, componentInstancePrefix, contractPropertiesID, validateElement);
        contractPropertiesID.addAll(this.getContractPropertiesIDFromComponentTypeName(componentTypeName, ocraModel));
        this.getAllContractPropertiesIDOfDescendenceComponentsInstance(componentTypeName, ocraModel, componentInstancePrefix, contractPropertiesID, validateElement);
        return contractPropertiesID;
    }

    public String[] getContractPropertiesIDFromComponentTypeAsStr(String componentTypeName, OSS ocraModel) throws IOException {
        return this.getContractPropertiesIDFromComponentTypeName(componentTypeName, ocraModel).toArray(new String[0]);
    }

    private Set<String> getAssertionsIDFromComponentTypeName(String componentTypeName, OSS ocraModel) throws IOException {
        Assertion currAssertion;
        HashSet<String> assertionIDs = new HashSet<String>();
        EList interfaces = null;
        EList refinements = null;
        logger.debug((Object)("componentTypeName: " + componentTypeName));
        if (componentTypeName.compareTo("system") == 0 || componentTypeName.compareTo(ocraModel.getSystem().getType()) == 0) {
            logger.debug((Object)"is system");
            interfaces = ocraModel.getSystem().getInterface().getInterfaces();
            if (ocraModel.getSystem().getRefinement() != null && ocraModel.getSystem().getRefinement().getRefinements() != null && ocraModel.getSystem().getRefinement().getRefinements().size() != 0) {
                refinements = ocraModel.getSystem().getRefinement().getRefinements();
            }
        } else {
            for (Component component : ocraModel.getComponents()) {
                logger.debug((Object)("component.getType(): -" + component.getType() + "-"));
                logger.debug((Object)("componentTypeName  : -" + componentTypeName + "-"));
                if (component.getType().compareTo(componentTypeName) != 0) continue;
                logger.debug((Object)"ok");
                interfaces = component.getInterface().getInterfaces();
                if (component.getRefinement() == null || component.getRefinement().getRefinements() == null || component.getRefinement().getRefinements().size() == 0) continue;
                refinements = component.getRefinement().getRefinements();
            }
        }
        if (interfaces != null) {
            for (InterfaceInstance currInterface : interfaces) {
                currAssertion = currInterface.getAssertion();
                if (currAssertion == null) continue;
                assertionIDs.add(currAssertion.getName());
            }
        }
        if (refinements != null) {
            for (RefinementInstance currRefinement : refinements) {
                currAssertion = currRefinement.getAssertion();
                if (currAssertion == null) continue;
                assertionIDs.add(currAssertion.getName());
            }
        }
        return assertionIDs;
    }

    private Set<String> getContractPropertiesIDFromComponentTypeName(String componentTypeName, OSS ocraModel) throws IOException {
        HashSet<String> contractPropertiesID = new HashSet<String>();
        EList interfaces = null;
        if (componentTypeName.compareTo("system") == 0 || componentTypeName.compareTo(ocraModel.getSystem().getType()) == 0) {
            logger.debug((Object)"is system");
            interfaces = ocraModel.getSystem().getInterface().getInterfaces();
        } else {
            for (Component component : ocraModel.getComponents()) {
                if (component.getType().compareTo(componentTypeName) != 0) continue;
                interfaces = component.getInterface().getInterfaces();
            }
        }
        if (interfaces != null) {
            for (InterfaceInstance currInterface : interfaces) {
                Contract currContract = currInterface.getContract();
                if (currContract == null) continue;
                String contractName = currContract.getName();
                contractPropertiesID.add(String.valueOf(contractName) + ".ASSUMPTION");
                contractPropertiesID.add(String.valueOf(contractName) + ".GUARANTEE");
                contractPropertiesID.add(String.valueOf(contractName) + ".NORM_GUARANTEE");
            }
        }
        return contractPropertiesID;
    }

    private String[] createUndefinedMultiplicity() {
        String[] mult = new String[]{null, null};
        return mult;
    }

    private boolean isUnaryType(SimpleType type) {
        return type instanceof BooleanType || type instanceof IntegerType || type instanceof IntegerType || type instanceof RealType || type instanceof WordType || type instanceof UnsignedWordType || type instanceof SignedWordType || type instanceof ContinuousType || type instanceof EventType || type instanceof RangeType || type instanceof EnumType;
    }

    public String[] getMultiplicityBoundariesFromOssSimpleType(SimpleType type) {
        String[] mult = new String[2];
        if (this.isUnaryType(type)) {
            mult = this.createUndefinedMultiplicity();
        } else if (type instanceof FixedSizeArrayType) {
            logger.debug((Object)"FixedSizeArrayType");
            EObject number = ((FixedSizeArrayType)type).getNumber();
            if (number instanceof IntegerLiteral) {
                mult[0] = ((IntegerLiteral)number).getValue();
                mult[1] = ((IntegerLiteral)number).getValue();
            } else if (number instanceof Identifier) {
                mult[0] = ((Identifier)number).getValue();
                mult[1] = ((Identifier)number).getValue();
            }
        } else if (type instanceof BoundedArrayType) {
            logger.debug((Object)"BoundedArrayType");
            mult[0] = ((BoundedArrayType)type).getLowerBound().getValue();
            mult[1] = ((BoundedArrayType)type).getUpperBound().getValue();
            if (StringArrayUtil.isZeroNumber((String)mult[0]) && StringArrayUtil.isInteger((String)mult[1])) {
                String arraySize;
                mult[0] = arraySize = String.valueOf(Integer.parseInt(mult[1]) + 1);
                mult[1] = arraySize;
            }
        } else if (type instanceof UnboundedArrayType) {
            logger.debug((Object)"UnboundedArrayType");
            mult[0] = "1";
            mult[1] = "*";
        } else if (type instanceof WordArrayType) {
            logger.debug((Object)"WordArrayType");
            mult[0] = "1";
            Integer number = ((WordArrayType)type).getNumber();
            if (number instanceof IntegerLiteral) {
                mult[1] = ((IntegerLiteral)number).getValue();
            } else if (number instanceof Identifier) {
                mult[1] = ((Identifier)number).getValue();
            }
        }
        return mult;
    }

    private Set<String> getAssertionsNameFromComponentInstance(SubComponent componentInstance, OSS ocraModel, boolean validateElement) {
        String assertionName;
        Assertion currAssertion;
        HashSet<String> assertionIDs = new HashSet<String>();
        EList interfaces = null;
        EList refinements = null;
        String componentTypeName = this.getSubComponentTypeName(componentInstance);
        String componentInstanceName = this.getSubComponentName(componentInstance, validateElement);
        logger.debug((Object)("componentTypeName: " + componentTypeName));
        logger.debug((Object)("componentInstanceName: " + componentInstanceName));
        if (componentTypeName.compareTo("system") == 0 || componentTypeName.compareTo(ocraModel.getSystem().getType()) == 0) {
            logger.debug((Object)"is system");
            interfaces = ocraModel.getSystem().getInterface().getInterfaces();
            refinements = ocraModel.getSystem().getRefinement().getRefinements();
        } else {
            for (Component component : ocraModel.getComponents()) {
                if (component.getType().compareTo(componentTypeName) != 0) continue;
                interfaces = component.getInterface().getInterfaces();
                if (component.getRefinement() == null || component.getRefinement().getRefinements() == null || component.getRefinement().getRefinements().size() == 0) continue;
                refinements = component.getRefinement().getRefinements();
            }
        }
        if (interfaces != null) {
            logger.debug((Object)("interfaces size: " + interfaces.size()));
            for (InterfaceInstance currInterface : interfaces) {
                currAssertion = currInterface.getAssertion();
                if (currAssertion == null) continue;
                assertionName = currAssertion.getName();
                logger.debug((Object)("add assertion: " + componentInstanceName + "." + assertionName));
                assertionIDs.add(String.valueOf(componentInstanceName) + "." + assertionName);
            }
        }
        if (refinements != null) {
            logger.debug((Object)("refinements size: " + refinements.size()));
            for (RefinementInstance currRefinement : refinements) {
                currAssertion = currRefinement.getAssertion();
                if (currAssertion == null) continue;
                assertionName = currAssertion.getName();
                logger.debug((Object)("add assertion: " + componentInstanceName + "." + assertionName));
                assertionIDs.add(String.valueOf(componentInstanceName) + "." + assertionName);
            }
        }
        return assertionIDs;
    }

    private void getAssertionsNameFromDescendanceComponentInstance(SubComponent componentInstance, OSS ocraModel, String prefixFatherComponentInstanceName, Set<String> assertionsID, boolean validateElement) {
        String assertionName;
        Assertion currAssertion;
        Component component2;
        EList interfaces = null;
        EList refinements = null;
        String componentTypeName = this.getSubComponentTypeName(componentInstance);
        String componentInstanceName = this.getSubComponentName(componentInstance, validateElement);
        logger.debug((Object)("componentTypeName: " + componentTypeName));
        logger.debug((Object)("componentInstanceName: " + componentInstanceName));
        String currPrefix = prefixFatherComponentInstanceName.compareTo("") == 0 ? componentInstanceName : String.valueOf(prefixFatherComponentInstanceName) + "." + componentInstanceName;
        if (componentTypeName.compareTo("system") == 0 || componentTypeName.compareTo(ocraModel.getSystem().getType()) == 0) {
            logger.debug((Object)"is system");
            interfaces = ocraModel.getSystem().getInterface().getInterfaces();
            refinements = ocraModel.getSystem().getRefinement().getRefinements();
        } else {
            for (Component component2 : ocraModel.getComponents()) {
                if (component2.getType().compareTo(componentTypeName) != 0) continue;
                interfaces = component2.getInterface().getInterfaces();
                if (component2.getRefinement() == null || component2.getRefinement().getRefinements() == null || component2.getRefinement().getRefinements().size() == 0) continue;
                refinements = component2.getRefinement().getRefinements();
            }
        }
        if (interfaces != null) {
            logger.debug((Object)("interfaces size: " + interfaces.size()));
            for (InterfaceInstance currInterface : interfaces) {
                currAssertion = currInterface.getAssertion();
                if (currAssertion == null) continue;
                assertionName = currAssertion.getName();
                logger.debug((Object)("add assertion: " + componentInstanceName + "." + assertionName));
                assertionsID.add(String.valueOf(currPrefix) + "." + assertionName);
            }
        }
        if (refinements != null) {
            logger.debug((Object)("refinements size: " + refinements.size()));
            for (RefinementInstance currRefinement : refinements) {
                currAssertion = currRefinement.getAssertion();
                if (currAssertion == null) continue;
                assertionName = currAssertion.getName();
                logger.debug((Object)("add assertion: " + componentInstanceName + "." + assertionName));
                assertionsID.add(String.valueOf(currPrefix) + "." + assertionName);
            }
        }
        component2 = this.getComponent(componentTypeName, ocraModel);
        for (SubComponent subComponentInstance : this.getSubComponentsInstance((AbstractComponent)component2)) {
            this.getAssertionsNameFromDescendanceComponentInstance(subComponentInstance, ocraModel, currPrefix, assertionsID, validateElement);
        }
    }

    private void getContractsNameFromDescendanceComponentInstance(SubComponent componentInstance, OSS ocraModel, String prefixFatherComponentInstanceName, Set<String> assertionsID, boolean validateElement) {
        AbstractComponent component2;
        EList interfaces = null;
        String componentTypeName = this.getSubComponentTypeName(componentInstance);
        String componentInstanceName = this.getSubComponentName(componentInstance, validateElement);
        logger.debug((Object)("componentTypeName: " + componentTypeName));
        logger.debug((Object)("componentInstanceName: " + componentInstanceName));
        String currPrefix = prefixFatherComponentInstanceName.compareTo("") == 0 ? componentInstanceName : String.valueOf(prefixFatherComponentInstanceName) + "." + componentInstanceName;
        if (componentTypeName.compareTo("system") == 0 || componentTypeName.compareTo(ocraModel.getSystem().getType()) == 0) {
            logger.debug((Object)"is system");
            interfaces = ocraModel.getSystem().getInterface().getInterfaces();
        } else {
            for (AbstractComponent component2 : ocraModel.getComponents()) {
                if (component2.getType().compareTo(componentTypeName) != 0) continue;
                interfaces = component2.getInterface().getInterfaces();
            }
        }
        if (interfaces != null) {
            for (InterfaceInstance currInterface : interfaces) {
                Contract currContract = currInterface.getContract();
                if (currContract == null) continue;
                String contractName = currContract.getName();
                logger.debug((Object)("add contract: " + componentInstanceName + "." + contractName));
                assertionsID.add(String.valueOf(currPrefix) + "." + contractName + ".ASSUMPTION");
                assertionsID.add(String.valueOf(currPrefix) + "." + contractName + ".GUARANTEE");
                assertionsID.add(String.valueOf(currPrefix) + "." + contractName + ".NORM_GUARANTEE");
            }
        }
        component2 = this.getComponent(componentTypeName, ocraModel);
        for (SubComponent subComponentInstance : this.getSubComponentsInstance(component2)) {
            this.getContractsNameFromDescendanceComponentInstance(subComponentInstance, ocraModel, currPrefix, assertionsID, validateElement);
        }
    }

    public String getSubComponentTypeName(SubComponent componentInstance) {
        if (componentInstance.getType().getComponentTypeName() != null) {
            return componentInstance.getType().getComponentTypeName();
        }
        return componentInstance.getType().getArrayComponentTypeName();
    }

    public String getAssertionName(Assertion assertion) {
        return assertion.getName();
    }

    public String[] getProperties(String componentTypeName, OSS ocraModel, boolean validateElement) throws IOException {
        ArrayList<String> properties = new ArrayList<String>();
        EList interfaces = null;
        if (componentTypeName.compareTo("system") == 0 || componentTypeName.compareTo(ocraModel.getSystem().getType()) == 0) {
            logger.debug((Object)"is system");
            interfaces = ocraModel.getSystem().getInterface().getInterfaces();
        } else {
            for (Component component : ocraModel.getComponents()) {
                if (component.getType().compareTo(componentTypeName) != 0) continue;
                interfaces = component.getInterface().getInterfaces();
            }
        }
        if (interfaces != null) {
            for (InterfaceInstance currInterface : interfaces) {
                Contract currContract = currInterface.getContract();
                if (currContract == null) continue;
                properties.add(this.propertyBodyFromPropertyStr(this.assumeWord, this.getContractAssumptionAsString(currContract.getAssumption(), validateElement)));
                properties.add(this.propertyBodyFromPropertyStr(this.guaranteeWord, this.getContractGuaranteeAsString(currContract.getGuarantee(), validateElement)));
            }
        }
        return properties.toArray(new String[0]);
    }

    public String getContractText(Contract contract, boolean validateElement) {
        String contractName = "CONTRACT " + contract.getName();
        String assumption = this.getContractAssumptionAsString(contract.getAssumption(), validateElement);
        String guarantee = this.getContractGuaranteeAsString(contract.getGuarantee(), validateElement);
        return String.valueOf(contractName) + "\n" + assumption + "\n" + guarantee + "\n";
    }

    public String getContractsText(AbstractComponent component, boolean validateElement) {
        String contractsText = "";
        for (InterfaceInstance interfaceInstance : component.getInterface().getInterfaces()) {
            Contract currContract = interfaceInstance.getContract();
            if (currContract == null) continue;
            contractsText = contractsText.concat(this.getContractText(currContract, validateElement));
        }
        return contractsText;
    }

    public String getContractName(Contract contract) {
        return contract.getName();
    }

    private String getCleanExpression(String expression) {
        return expression.replace("\n", " ").replace("\r", "").replace("\t", " ").replaceAll(" +", " ");
    }

    public String getContractAssumption(Contract contract, boolean validateElement) {
        String assumption = this.getContractAssumptionAsString(contract.getAssumption(), validateElement);
        assumption = this.getCleanExpression(assumption);
        return assumption.substring(assumption.indexOf(":") + 1, assumption.length()).trim();
    }

    public String getContractGuarantee(Contract contract, boolean validateElement) {
        String guarantee = this.getContractGuaranteeAsString(contract.getGuarantee(), validateElement);
        guarantee = this.getCleanExpression(guarantee);
        return guarantee.substring(guarantee.indexOf(":") + 1, guarantee.length()).trim();
    }

    public File generateOSSFile(String fileName, OSS ossModel, String workspaceDir) throws IOException {
        logger.debug((Object)"generateOSSFile");
        File ossFile = fileName == null ? FileSystemUtil.generateEmptyFile((String)".oss", (String)workspaceDir) : FileSystemUtil.generateEmptyFile((String)fileName, (String)".oss", (String)workspaceDir);
        BufferedWriter bw = new BufferedWriter(new FileWriter(ossFile));
        this.generateText(bw, ossModel);
        bw.close();
        return ossFile;
    }

    private void generateText(Writer writer, OSS ossModel) throws IOException {
        if (writer == null) {
            return;
        }
        Injector injector = this.xtextResourceUtil.getOssInjector();
        ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
        String serialization = serializer.serialize((EObject)ossModel);
        logger.debug((Object)("OSS: " + serialization));
        writer.append(serialization);
        logger.debug((Object)"OCRA file generation completed");
    }

    private String propertyBodyFromPropertyStr(String propertyWord, String property) throws IOException {
        int beginIndex = property.indexOf(propertyWord) + propertyWord.length();
        int endIndex = property.indexOf(";", beginIndex);
        return property.substring(beginIndex, endIndex);
    }

    public String[] getBoundariesFromOssRangeType(RangeType rangeType) {
        String[] boundaries = new String[]{this.parseRangeBound(rangeType.getLowerBound()), this.parseRangeBound(rangeType.getUpperBound())};
        return boundaries;
    }

    private String parseRangeBound(EObject bound) {
        if (bound instanceof IntegerLiteral) {
            IntegerLiteral intLit = (IntegerLiteral)bound;
            return this.getOssElementAsString((EObject)intLit, false, true);
        }
        if (bound instanceof Identifier) {
            Identifier idLit = (Identifier)bound;
            return this.getOssElementAsString((EObject)idLit, false, true);
        }
        logger.error((Object)("Cannot understand the rangeType bound " + bound));
        return null;
    }

    public String[] getMultiplicityBoundariesFromOssSubComponentType(SubComponentType type, boolean validateElement) {
        String[] mult = new String[]{null, null};
        if (type.getArraySize() != null) {
            String arraySizeExpr;
            mult[0] = arraySizeExpr = this.getExpressionAsString(type.getArraySize(), validateElement);
            mult[1] = arraySizeExpr;
        }
        return mult;
    }

    public Set<String> getListValuesForEnumType(EnumType enumType) {
        TreeSet<String> enumValuesNames = new TreeSet<String>();
        for (EObject object : enumType.getValues()) {
            enumValuesNames.add(((Identifier)object).getValue());
        }
        return enumValuesNames;
    }

    public String getNearestComponentName(FullVariableId variable) {
        EList variableComponentNames = variable.getFullComponentIds();
        if (variableComponentNames != null && variableComponentNames.size() != 0) {
            return ((ComponentId)variableComponentNames.get(0)).getName();
        }
        return null;
    }

    public String getNearestComponentId(FullVariableId variable) {
        EList variableComponentNames = variable.getFullComponentIds();
        if (variableComponentNames != null && variableComponentNames.size() != 0) {
            return this.getOssElementAsString((EObject)variableComponentNames.get(0), false, true);
        }
        return null;
    }

    public String getNearestComponentName(FullContractIdList contractId) {
        EList variableComponentNames = contractId.getFullComponentIds();
        if (variableComponentNames != null && variableComponentNames.size() != 0) {
            return ((ComponentId)variableComponentNames.get(0)).getName();
        }
        return null;
    }

    public String getSubComponentName(SubComponent subcomponent, boolean validateElement) {
        return this.getComponentIdAsString(subcomponent.getName(), validateElement);
    }

    public String getParameterAssumptionsText(ParameterAssumptions parameterAssumptions, boolean validateElement) {
        return this.getExpressionAsString(parameterAssumptions.getConstraint(), validateElement);
    }

    private Set<String> getInterfaceAssertionsIDFromComponent(AbstractComponent component) {
        HashSet<String> assertionIDs = new HashSet<String>();
        EList interfaces = component.getInterface().getInterfaces();
        if (interfaces != null) {
            for (InterfaceInstance currInterface : interfaces) {
                Assertion currAssertion = currInterface.getAssertion();
                if (currAssertion == null) continue;
                assertionIDs.add(currAssertion.getName());
            }
        }
        return assertionIDs;
    }

    public boolean isAssertionID(AbstractComponent component, Expression constraint) {
        Set<String> interfaceAssertions;
        return constraint instanceof FullPortId && (interfaceAssertions = this.getInterfaceAssertionsIDFromComponent(component)).contains(((FullPortId)constraint).getId().getName());
    }

    public String getNearestComponentInstanceNameFromFullContractId(FullContractIdList contractId) {
        EList variableComponentNames = contractId.getFullComponentIds();
        if (variableComponentNames != null && variableComponentNames.size() != 0) {
            return ((ComponentId)variableComponentNames.get(0)).getName();
        }
        return null;
    }

    public String getNearestComponentInstanceIdFromFullContractId(FullContractIdList contractId, boolean validateElement) {
        EList variableComponentNames = contractId.getFullComponentIds();
        if (variableComponentNames != null && variableComponentNames.size() != 0) {
            return this.getComponentIdAsString((ComponentId)variableComponentNames.get(0), validateElement);
        }
        return null;
    }

    public String getNearestComponentInstanceIndexFromFullContractId(FullContractIdList contractId, String componentInstanceName, boolean validateElement) {
        EList variableComponentNames = contractId.getFullComponentIds();
        if (variableComponentNames != null && variableComponentNames.size() != 0 && ((ComponentId)variableComponentNames.get(0)).getIndexes() != null && ((ComponentId)variableComponentNames.get(0)).getIndexes().size() != 0 && componentInstanceName.equals(((ComponentId)variableComponentNames.get(0)).getName())) {
            return this.getExpressionAsString(((ArrayIndex)((ComponentId)variableComponentNames.get(0)).getIndexes().get(0)).getIndex(), validateElement);
        }
        return null;
    }

    public String[] getNearestComponentInstanceRangeFromFullContractId(FullContractIdList contractId, boolean validateElement) {
        EList iteratorBounds = contractId.getIteratorBounds();
        if (iteratorBounds != null && iteratorBounds.size() != 0) {
            String[] mult = new String[]{this.getExpressionAsString(((IteratorBound)((IteratorBounds)iteratorBounds.get(0)).getBounds().get(0)).getLowerBound(), validateElement), this.getExpressionAsString(((IteratorBound)((IteratorBounds)iteratorBounds.get(0)).getBounds().get(0)).getUpperBound(), validateElement)};
            String leftOperator = ((IteratorBound)((IteratorBounds)iteratorBounds.get(0)).getBounds().get(0)).getLeftOperator();
            String rightOperator = ((IteratorBound)((IteratorBounds)iteratorBounds.get(0)).getBounds().get(0)).getRightOperator();
            if (leftOperator.compareTo("<") == 0) {
                mult[0] = String.valueOf(mult[0]) + "+1";
            }
            if (rightOperator.compareTo("<") == 0) {
                mult[1] = String.valueOf(mult[1]) + "-1";
            }
            return mult;
        }
        return null;
    }

    public String getPortName(Port port, boolean validateElement) {
        return this.getVariableIdAsString(port.getId(), validateElement);
    }

    public String getFullVariableIdAsString(FullVariableId fullVariableId, boolean validateElement) {
        if (fullVariableId.getFullComponentIds().isEmpty() && fullVariableId.getId().getIndexes().isEmpty()) {
            return fullVariableId.getId().getName();
        }
        return this.getOssElementAsString((EObject)fullVariableId, validateElement, true);
    }

    public String getFullPortIdToString(FullPortId fullPortId, boolean validateElement) {
        if (fullPortId.getFullComponentIds().isEmpty() && fullPortId.getId().getIndexes().isEmpty()) {
            return fullPortId.getId().getName();
        }
        return this.getOssElementAsString((EObject)fullPortId, validateElement, true);
    }

    public String getComponentIdAsString(ComponentId componentId, boolean validateElement) {
        if (componentId.getIndexes().isEmpty()) {
            return componentId.getName();
        }
        return this.getOssElementAsString((EObject)componentId, validateElement, true);
    }

    public String getVariableIdAsString(VariableId variableId, boolean validateElement) {
        if (variableId.getIndexes().isEmpty()) {
            return variableId.getName();
        }
        return this.getOssElementAsString((EObject)variableId, validateElement, true);
    }

    public String getVariableIdAsString(ComponentId componentId, boolean validateElement) {
        if (componentId.getIndexes().isEmpty()) {
            return componentId.getName();
        }
        return this.getOssElementAsString((EObject)componentId, validateElement, true);
    }

    public String getIterativeConditionAsString(IterativeCondition iterCondition, boolean validateElement) {
        return this.getOssElementAsString((EObject)iterCondition, validateElement, true);
    }

    public String getDelegationAsString(Connection connection, boolean validateElement) {
        return this.getOssElementAsString((EObject)connection.getConstraint(), validateElement, true);
    }

    public String getFullContractIdAsString(FullContractIdList fullContractIdList, boolean validateElement) {
        if (fullContractIdList.getFullComponentIds().isEmpty() && fullContractIdList.getIteratorBounds().isEmpty()) {
            return fullContractIdList.getName();
        }
        return this.getOssElementAsString((EObject)fullContractIdList, validateElement, true);
    }

    public String getSourcePort(Connection connection, boolean validateElement) {
        Expression extExpr = connection.getConstraint();
        FullVariableId portConstraint = (FullVariableId)extExpr;
        return this.getFullVariableIdAsString(portConstraint, validateElement);
    }

    public String getTargetPort(Connection connection, boolean validateElement) {
        FullVariableId portVariable = connection.getVariable();
        return this.getFullVariableIdAsString(portVariable, validateElement);
    }

    public String getIterativeConditionAsString(Connection connection, boolean validateElement) {
        IterativeCondition iterativeCondition = connection.getIterativeCondition();
        if (iterativeCondition != null) {
            return this.getIterativeConditionAsString(iterativeCondition, validateElement);
        }
        return null;
    }

    public String getExpressionAsString(Expression ossElement, boolean validateElement) {
        return this.getOssElementAsString((EObject)ossElement, validateElement, true);
    }

    public String getOssElementAsString(EObject ossElement, boolean validateElement, boolean removeWhiteSpaces) {
        Injector injector = this.xtextResourceUtil.getOssInjector();
        ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
        if (!validateElement) {
            String string = serializer.serialize(ossElement, this.noValidOptions);
        }
        String str = serializer.serialize(ossElement);
        return removeWhiteSpaces ? str.trim() : str;
    }

    public String[] getMultiplicityBoundariesFromOssComplexType(ComplexType elementType, boolean validateElement) {
        String[] mult = new String[2];
        EObject type = elementType.getComplexType();
        if (type instanceof SimpleType) {
            mult = this.getMultiplicityBoundariesFromOssSimpleType((SimpleType)type);
        } else if (type instanceof ParameterizedArrayType) {
            mult[0] = this.getExpressionAsString(((ParameterizedArrayType)type).getNumber(), validateElement);
            mult[1] = this.getExpressionAsString(((ParameterizedArrayType)type).getNumber(), validateElement);
        }
        return mult;
    }

    public String getUninterpretedFunctionInputsAsStr(Variable uninterpretedFunction, boolean validateElement) {
        String inputs = "";
        EList parameters = ((Parameter)uninterpretedFunction).getParameters();
        for (ComplexType complexType : parameters) {
            inputs = String.valueOf(inputs) + this.getTypeAsStr(complexType);
            String[] boundaries = ocraModelUtil.getMultiplicityBoundariesFromOssComplexType(complexType, validateElement);
            if (boundaries[0] != null) {
                inputs = String.valueOf(inputs) + " [";
                inputs = String.valueOf(inputs) + boundaries[0];
                if (!boundaries[0].equals(boundaries[1])) {
                    inputs = String.valueOf(inputs) + ".." + boundaries[1];
                }
                inputs = String.valueOf(inputs) + "]";
            }
            inputs = String.valueOf(inputs) + ", ";
        }
        if (inputs.length() > 0) {
            inputs = inputs.substring(0, inputs.length() - 2);
        }
        return inputs;
    }

    public EList<String[]> getMultiplicityBoundariesFromOssComplexTypes(EList<ComplexType> elementTypes, boolean validateElement) {
        BasicEList multiplicityBounds = new BasicEList();
        for (ComplexType elementType : elementTypes) {
            multiplicityBounds.add((Object)this.getMultiplicityBoundariesFromOssComplexType(elementType, validateElement));
        }
        return multiplicityBounds;
    }

    public String getAssertionText(Assertion assertion, boolean validateElement) {
        return String.valueOf(this.getCleanExpression(this.getExpressionAsString(assertion.getConstraint(), validateElement))) + " ;";
    }

    private String getContractElementToString(EObject property, boolean validateElement) {
        Injector injector = this.xtextResourceUtil.getContractInjector();
        ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
        if (!validateElement) {
            String string = serializer.serialize(property, this.noValidOptions);
        }
        String str = serializer.serialize(property);
        logger.debug((Object)("propertyToStr: " + str));
        return str;
    }

    public String getContractAssumptionAsString(Assumption assumption, boolean validateElement) {
        return this.getContractElementToString((EObject)assumption, validateElement);
    }

    public String getContractGuaranteeAsString(Guarantee guarantee, boolean validateElement) {
        return this.getContractElementToString((EObject)guarantee, validateElement);
    }

    public String getDefineName(Define define) {
        return define.getName();
    }

    public String getDefineText(Define define, boolean validateElement) {
        return this.getCleanExpression(this.getExpressionAsString(define.getConstraint(), validateElement));
    }
}

