/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services;

import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.modelTranslators.GenericModelToOSSModelTranslator;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.utils.OSSModelUtil;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.tools.editor.oss.oss.OSS;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;

public class OSSTranslatorServiceAPI {
    private static OSSTranslatorServiceAPI ossTranslatorServiceAPI;
    private OSSModelUtil ossModelUtil = OSSModelUtil.getInstance();
    private GenericModelToOSSModelTranslator toolToOCRAModelTranslator;

    public static OSSTranslatorServiceAPI getInstance(AbstractSystemModel abstractSystemModel) {
        if (ossTranslatorServiceAPI == null) {
            ossTranslatorServiceAPI = new OSSTranslatorServiceAPI(abstractSystemModel);
        }
        return ossTranslatorServiceAPI;
    }

    public OSSTranslatorServiceAPI(AbstractSystemModel abstractSystemModel) {
        this.toolToOCRAModelTranslator = GenericModelToOSSModelTranslator.getInstance(abstractSystemModel);
    }

    public OSS exportRootComponentToOssModel(Object rootComponent, boolean isDiscreteTime, IProgressMonitor monitor) throws Exception {
        return this.toolToOCRAModelTranslator.exportRootComponentAsOssModel(rootComponent, isDiscreteTime, monitor);
    }

    public String getFileName(Object component) {
        return this.toolToOCRAModelTranslator.getFileName(component);
    }

    public File exportRootComponentToOSSFile(Object umlRootComponent, String selectedDirectory, String fileName, boolean isDiscreteTime, IProgressMonitor monitor) throws Exception {
        OSS ossModel = this.exportRootComponentToOssModel(umlRootComponent, isDiscreteTime, monitor);
        if (fileName == null) {
            fileName = this.toolToOCRAModelTranslator.getFileName(umlRootComponent);
        }
        File smvFile = this.exportOSSModelToOSSFile(ossModel, fileName, selectedDirectory);
        return smvFile;
    }

    public File exportOSSModelToOSSFile(Object ossModel, String fileName, String path) throws Exception {
        return this.ossModelUtil.generateOssFileFromOssModel(path, fileName, ossModel);
    }
}

