/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.framework.Bundle;
import org.polarsys.chess.core.Activator;
import org.polarsys.chess.core.internal.util.InternalCHESSProjectSupport;
import org.polarsys.chess.core.internal.util.InternalConsoleUtil;

public class CHESSProjectSupport {
    public static String CHESS_CONSOLE_NAME = "CHESS notification console";
    private static final boolean isConsoleEnabled = true;
    public static final MessageConsoleStream CHESS_CONSOLE = InternalConsoleUtil.findCHESSconsole();
    public static final PrintStream CHESS_CONSOLE_STREAM = new PrintStream((OutputStream)CHESS_CONSOLE);

    public static void printlnToCHESSConsole(String message) {
        CHESS_CONSOLE.println(message);
    }

    public static IProject createProject(String projectName, URI location) {
        IProject project = InternalCHESSProjectSupport.createBaseProject(projectName, location);
        try {
            InternalCHESSProjectSupport.addNature(project);
        }
        catch (CoreException e) {
            Activator.error("Create project error", e);
        }
        return project;
    }

    public static void createFolder(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            CHESSProjectSupport.createFolder((IFolder)parent);
        }
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
    }

    public static IFile resourceToFile(Resource inResource) {
        URI inputJURI = null;
        if (inResource.getURI().isPlatformResource()) {
            inputJURI = URI.create(inResource.getURI().toPlatformString(false).toString());
            IPath path = InternalCHESSProjectSupport.toPath(inputJURI);
            IFile inputFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            return inputFile;
        }
        return null;
    }

    public static IFile copyFile(IFile inputFile, String newLocation, String outputName) throws Exception {
        IFile inputCopy = inputFile.getProject().getFile(String.valueOf(newLocation) + File.separator + outputName);
        try {
            inputCopy.delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new Exception("Unable to make a copy of the model");
        }
        try {
            inputFile.copy(inputCopy.getFullPath(), true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new Exception("Unable to make a copy of the model");
        }
        return inputCopy;
    }

    public static void fileReplace(IFile in, IFile out) throws CoreException, IOException {
        InputStream ins = in.getContents(true);
        out.setContents(ins, true, true, null);
        ins.close();
    }

    public static void bundleToProjectCopy(String pluginID, Plugin plugin, String pluginPath, IProject currentProject, String projectPath, boolean includeBundleFolder) throws IOException {
        ArrayList<String> collectedPaths = new ArrayList<String>();
        InternalCHESSProjectSupport.getBundleContents(plugin, pluginPath, collectedPaths);
        IPath workingDir = currentProject.getFolder(projectPath).getLocation();
        for (String collectedPath : collectedPaths) {
            Path path = new Path(collectedPath);
            URL u = FileLocator.find((Bundle)plugin.getBundle(), (IPath)path, null);
            if (!includeBundleFolder) {
                collectedPath = collectedPath.substring(pluginPath.length() + 1);
            }
            try {
                InputStream in = u.openStream();
                File f = new File(workingDir + "/" + collectedPath);
                f.getParentFile().mkdirs();
                FileOutputStream o = new FileOutputStream(f);
                InternalCHESSProjectSupport.fileCopy(in, o);
            }
            catch (IOException e) {
                Activator.error("Unable to copy the content of the plug-in", e);
                throw e;
            }
        }
    }

    public static void deleteFolder(IFolder folder) throws CoreException {
        if (folder.exists()) {
            folder.delete(true, null);
        }
    }
}

