/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.chess.core.Activator;
import org.polarsys.chess.core.constraint.ConstraintList;
import org.polarsys.chess.core.constraint.IConstraint;
import org.polarsys.chess.core.constraint.PreferenceProperties;
import org.polarsys.chess.core.internal.preferences.LabelField;
import org.polarsys.chess.core.preferences.FilterableConstraint;

public class ConstraintPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static int i = 0;

    public ConstraintPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("List of dynamic constraints.");
        System.out.println("ConstraintPreferencePage" + ++i);
    }

    public void createFieldEditors() {
        ArrayList<FilterableConstraint> list = ConstraintList.getList();
        if (list.isEmpty()) {
            this.addField(new LabelField("Open the CHESS editor to load the constraints!", this.getFieldEditorParent()));
        } else {
            for (FilterableConstraint c : ConstraintList.getList()) {
                IConstraint cc = c.getConstraint();
                BooleanFieldEditor b = new BooleanFieldEditor(cc.getName(), cc.getMessage(), 1, this.getFieldEditorParent());
                this.addField((FieldEditor)b);
            }
            BooleanFieldEditor b1 = new BooleanFieldEditor(PreferenceProperties.DIAGRAM_IN_VIEW, "Diagrams must be created inside the proper CHESS views", 1, this.getFieldEditorParent());
            this.addField((FieldEditor)b1);
            BooleanFieldEditor b2 = new BooleanFieldEditor(PreferenceProperties.PALETTES_IN_VIEW, "Hide Diagram Palettes according to the current CHESS views", 1, this.getFieldEditorParent());
            this.addField((FieldEditor)b2);
        }
    }

    public boolean performOk() {
        super.performOk();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        for (FilterableConstraint c : ConstraintList.getList()) {
            IConstraint cc = c.getConstraint();
            c.setActive(store.getBoolean(cc.getName()));
        }
        return true;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("CHESS Core Constraints");
    }

    public IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

