/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;

public class CellStyleUtil {
    public static IStyle getCellStyle(ILayerCell cell, IConfigRegistry configRegistry) {
        return new CellStyleProxy(configRegistry, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
    }

    public static int getHorizontalAlignmentPadding(IStyle cellStyle, Rectangle rectangle, int contentWidth) {
        HorizontalAlignmentEnum horizontalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT);
        return CellStyleUtil.getHorizontalAlignmentPadding(horizontalAlignment, rectangle, contentWidth);
    }

    public static int getHorizontalAlignmentPadding(HorizontalAlignmentEnum horizontalAlignment, Rectangle rectangle, int contentWidth) {
        if (horizontalAlignment == null) {
            horizontalAlignment = HorizontalAlignmentEnum.CENTER;
        }
        int padding = 0;
        switch (horizontalAlignment) {
            case CENTER: {
                padding = (rectangle.width - contentWidth) / 2;
                break;
            }
            case RIGHT: {
                padding = rectangle.width - contentWidth;
            }
        }
        if (padding < 0) {
            padding = 0;
        }
        return padding;
    }

    public static int getVerticalAlignmentPadding(IStyle cellStyle, Rectangle rectangle, int contentHeight) {
        VerticalAlignmentEnum verticalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT);
        return CellStyleUtil.getVerticalAlignmentPadding(verticalAlignment, rectangle, contentHeight);
    }

    public static int getVerticalAlignmentPadding(VerticalAlignmentEnum verticalAlignment, Rectangle rectangle, int contentHeight) {
        if (verticalAlignment == null) {
            verticalAlignment = VerticalAlignmentEnum.MIDDLE;
        }
        int padding = 0;
        switch (verticalAlignment) {
            case MIDDLE: {
                padding = (rectangle.height - contentHeight) / 2;
                break;
            }
            case BOTTOM: {
                padding = rectangle.height - contentHeight;
            }
        }
        if (padding < 0) {
            padding = 0;
        }
        return padding;
    }

    public static List<Color> getAllBackgroundColors(ILayerCell cell, IConfigRegistry configRegistry, String displayMode) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String configLabel : cell.getConfigLabels().getLabels()) {
            Color color;
            IStyle cellStyle = configRegistry.getSpecificConfigAttribute(CellConfigAttributes.CELL_STYLE, displayMode, configLabel);
            if (cellStyle == null || (color = cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR)) == null) continue;
            colors.add(color);
        }
        return colors;
    }
}

