/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.expressions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.concurrent.Future;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.uml2.uml.Package;

public class PackagePropertyTester
extends PropertyTester {
    public static final String PROPERTY_OWNS_PROFILE_APPLICATIONS = "ownsProfileApplications";
    public static final String PROPERTY_HAS_EXTERNAL_PROFILE_APPLICATIONS = "hasExternalProfileApplications";
    public static final String PROPERTY_IS_DECORATOR_MODEL = "isDecoratorModel";
    public static final String PROPERTY_HAS_UNLOADED_DECORATOR_MODELS = "hasUnloadedDecoratorModels";
    public static final String PROPERTY_HAS_LOADED_DECORATOR_MODELS = "hasLoadedDecoratorModels";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IStructuredSelection) {
            receiver = ((IStructuredSelection)receiver).getFirstElement();
        } else if (receiver instanceof Iterable) {
            receiver = Iterables.getFirst((Iterable)((Iterable)receiver), null);
        }
        receiver = EMFHelper.getEObject((Object)receiver);
        if (receiver instanceof Package) {
            Package package_ = (Package)receiver;
            if (PROPERTY_OWNS_PROFILE_APPLICATIONS.equals(property)) {
                result = PackagePropertyTester.ownsProfileApplications(package_);
            } else if (PROPERTY_HAS_EXTERNAL_PROFILE_APPLICATIONS.equals(property)) {
                result = PackagePropertyTester.hasExternalProfileApplications(package_);
            } else if (PROPERTY_IS_DECORATOR_MODEL.equals(property)) {
                result = PackagePropertyTester.isDecoratorModel(package_);
            } else if (PROPERTY_HAS_UNLOADED_DECORATOR_MODELS.equals(property)) {
                result = PackagePropertyTester.hasUnloadedDecoratorModels(package_, args);
            } else if (PROPERTY_HAS_LOADED_DECORATOR_MODELS.equals(property)) {
                result = PackagePropertyTester.hasLoadedDecoratorModels(package_, args);
            }
            result = PackagePropertyTester.expectBoolean(expectedValue) == result;
        }
        return result;
    }

    private static boolean expectBoolean(Object expectedValue) {
        return expectedValue == null || expectedValue instanceof Boolean && (Boolean)expectedValue != false;
    }

    static boolean ownsProfileApplications(Package receiver) {
        return !receiver.getProfileApplications().isEmpty();
    }

    static boolean hasExternalProfileApplications(Package receiver) {
        return !Iterables.isEmpty((Iterable)DecoratorModelUtils.getDecoratorModelProfileApplications((Package)receiver));
    }

    static boolean isDecoratorModel(Package receiver) {
        return receiver.getOwner() == null && DecoratorModelUtils.hasExternalizationProfile((Package)receiver);
    }

    static boolean hasUnloadedDecoratorModels(Package receiver, Object[] args) {
        HashSet options = Sets.newHashSet((Object[])args);
        boolean recursive = options.contains("recursive");
        boolean optimistic = options.contains("optimistic");
        return PackagePropertyTester.hasUnloadedDecoratorModels(receiver, recursive, optimistic);
    }

    public static boolean hasUnloadedDecoratorModels(Package receiver, boolean recursive, boolean optimistic) {
        ListenableFuture result = DecoratorModelUtils.hasUnloadedDecoratorModelsAsync((Package)receiver, (boolean)true);
        return result.isDone() ? Boolean.TRUE.equals(Futures.getUnchecked((Future)result)) : optimistic;
    }

    static boolean hasLoadedDecoratorModels(Package receiver, Object[] args) {
        HashSet options = Sets.newHashSet((Object[])args);
        boolean recursive = options.contains("recursive");
        return PackagePropertyTester.hasLoadedDecoratorModels(receiver, recursive);
    }

    private static boolean hasLoadedDecoratorModels(Package receiver, boolean recursive) {
        boolean result;
        Resource resource = receiver.eResource();
        boolean bl = result = !DecoratorModelUtils.getLoadedDecoratorModels((Resource)resource).isEmpty();
        if (!result && recursive) {
            for (Package next : DecoratorModelUtils.getLoadedSubUnitPackages((Package)receiver)) {
                result = PackagePropertyTester.hasLoadedDecoratorModels(next, recursive);
                if (result) break;
            }
        }
        return result;
    }
}

