/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IOvalAnchorableFigure;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableOvalAnchor;
import org.eclipse.gmf.runtime.gef.ui.internal.figures.CircleFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.papyrus.uml.diagram.sequence.command.ExecutionOccurrenceSpecificationMessageCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.ExecutionOccurrenceSpecificationMessageReorientCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.CommentAnnotatedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.ConstraintConstrainedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CommentAnnotatedElementEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ConstraintConstrainedElementEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.ExecutionSpecificationEndGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.HighlightEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class ExecutionSpecificationEndEditPart
extends org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart
implements INodeEditPart {
    public static final String VISUAL_ID = "ExecutionSpecification_Shape";
    private static final int DEFAULT_SIZE = 16;
    private Locator locator;
    private OccurrenceSpecification executionSpecificationEnd;
    static ViewHelper helper = new ViewHelper();

    public ExecutionSpecificationEndEditPart(OccurrenceSpecification occurrenceSpecification, ShapeNodeEditPart parent, RelativeLocator locator) {
        super(ExecutionSpecificationEndEditPart.createDummyView(parent, (EObject)occurrenceSpecification));
        this.executionSpecificationEnd = occurrenceSpecification;
        this.locator = locator;
        this.setParent((EditPart)parent);
        this.addToResource(parent.getNotationView(), this.getNotationView());
    }

    public ExecutionSpecificationEndEditPart(View view) {
        super((EObject)view);
        if (view.getElement() instanceof OccurrenceSpecification) {
            this.executionSpecificationEnd = (OccurrenceSpecification)view.getElement();
        }
    }

    public void setParent(EditPart parent) {
        super.setParent(parent);
        this.initLocator();
    }

    private static EObject createDummyView(ShapeNodeEditPart parent, EObject model) {
        ShapeImpl node = new ShapeImpl(){

            public boolean eNotificationRequired() {
                return true;
            }
        };
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(String.valueOf(VISUAL_ID));
        node.setElement(model);
        return node;
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getView_SourceEdges().equals(feature)) {
            this.refreshSourceConnections();
        } else if (NotationPackage.eINSTANCE.getView_TargetEdges().equals(feature)) {
            this.refreshTargetConnections();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    protected void addNotationalListeners() {
        if (this.hasNotationView()) {
            this.addListenerFilter("View", (NotificationListener)this, (EObject)((View)this.getModel()));
        }
    }

    private void addToResource(final View container, final View view) {
        CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), (Command)new DummyCommand(){

            @Override
            public void execute() {
                ViewUtil.insertChildView((View)container, (View)view, (int)-1, (boolean)false);
            }
        }, true);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ExecutionSpecificationEndSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ExecutionSpecificationEndGraphicalNodeEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicy(){

            protected void addSelectionHandles() {
            }
        });
        this.installEditPolicy("Highlight Edit Policy", (EditPolicy)new HighlightEditPolicy(){

            @Override
            protected void highlight(EditPart object) {
                super.highlight(ExecutionSpecificationEndEditPart.this.getParent());
                HighlightEditPolicy.Indicator feedback = this.getTargetIndicator();
                Rectangle rect = ExecutionSpecificationEndEditPart.this.getFigure().getBounds().getCopy();
                ExecutionSpecificationEndEditPart.this.getFigure().translateToAbsolute((Translatable)rect);
                this.setFeedbackLocation((IFigure)feedback, rect.getCenter());
            }
        });
        this.removeEditPolicy("CreationPolicy");
    }

    public void rebuildLinks(Diagram diagram) {
        helper.collectViews(diagram);
        if (this.executionSpecificationEnd == null) {
            return;
        }
        EAnnotation annotation = this.executionSpecificationEnd.getEAnnotation("Connections");
        if (annotation != null) {
            block0: for (EObject eo : annotation.getReferences()) {
                View view = helper.findView(eo);
                if (view == null) continue;
                EList edges = view.getSourceEdges();
                for (Object o : edges) {
                    if (!(o instanceof Edge) || !this.needRestoreLink((Edge)o)) continue;
                    this.restoreEdgeTarget((Edge)o);
                    continue block0;
                }
            }
        }
    }

    public void removeFromResource() {
        CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), (Command)new DummyCommand(){

            @Override
            public void execute() {
                View view = ExecutionSpecificationEndEditPart.this.getNotationView();
                ViewUtil.destroy((View)view);
            }
        }, true);
    }

    private boolean needRestoreLink(Edge e) {
        if (e.getTarget() == null) {
            return true;
        }
        EObject model = e.getTarget().getElement();
        if (!(model instanceof OccurrenceSpecification)) {
            return false;
        }
        return model == this.resolveSemanticElement() && !this.getNotationView().equals(e.getTarget());
    }

    private void restoreEdgeTarget(final Edge edge) {
        CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), (Command)new DummyCommand(){

            @Override
            public void execute() {
                edge.setTarget((View)ExecutionSpecificationEndEditPart.this.getModel());
            }
        }, true);
    }

    public Locator getLocator() {
        return this.locator;
    }

    protected IFigure createFigure() {
        ExecutionSpecificationEndFigure fig = new ExecutionSpecificationEndFigure();
        fig.setForegroundColor(ColorConstants.black);
        fig.setOpaque(false);
        return fig;
    }

    public boolean hasNotationView() {
        return true;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        final ConnectionNodeEditPart connection = (ConnectionNodeEditPart)connEditPart;
        String t = "";
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = ((Edge)connection.getModel()).getTargetAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getTargetConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getTargetConnectionAnchor", (Throwable)e);
        }
        IAnchorableFigure fig = (IAnchorableFigure)this.getFigure();
        ConnectionAnchor a = fig.getConnectionAnchor(t);
        return a;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt;
        Point center = this.getFigure().getBounds().getCenter();
        this.getFigure().translateToAbsolute((Translatable)center);
        Point point = pt = ((DropRequest)request).getLocation() == null ? center : new Point(((DropRequest)request).getLocation());
        if (request instanceof CreateRequest) {
            this.getFigure().translateToRelative((Translatable)pt);
        }
        ConnectionAnchor a = ((IAnchorableFigure)this.getFigure()).getTargetConnectionAnchorAt(pt);
        return a;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point location = this.getFigure().getBounds().getCenter();
        this.getFigure().translateToAbsolute((Translatable)location);
        if (!(request instanceof CreateRequest)) {
            this.getFigure().translateToRelative((Translatable)location);
        }
        return ((IAnchorableFigure)this.getFigure()).getSourceConnectionAnchorAt(location);
    }

    public boolean canAttachNote() {
        return true;
    }

    public String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return ((IAnchorableFigure)this.getFigure()).getConnectionAnchorTerminal(c);
    }

    public ConnectionAnchor mapTerminalToConnectionAnchor(String terminal) {
        int location;
        if (terminal != null && terminal.indexOf("{") != -1 && terminal.indexOf("}") != -1 && (8 == (location = AnchorHelper.FixedAnchorEx.parsePosition(terminal)) || 32 == location)) {
            IFigure parentFigure = ((AbstractExecutionSpecificationEditPart)this.getParent()).getFigure();
            return new AnchorHelper.FixedAnchorEx(parentFigure, location);
        }
        return ((IAnchorableFigure)this.getFigure()).getConnectionAnchor(terminal);
    }

    protected List getModelSourceConnections() {
        return ViewUtil.getSourceConnectionsConnectingVisibleViews((View)((View)this.getModel()));
    }

    protected List getModelTargetConnections() {
        List list = ViewUtil.getTargetConnectionsConnectingVisibleViews((View)((View)this.getModel()));
        return list;
    }

    public EditPart getTargetEditPart(Request request) {
        ConnectionEditPart con;
        List types;
        EditPart targetEditPart = super.getTargetEditPart(request);
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType()) || "Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            return targetEditPart;
        }
        if ("annotated link end".equals(request.getType()) || "annotated link reorient end".equals(request.getType())) {
            return targetEditPart;
        }
        if (request instanceof CreateUnspecifiedTypeConnectionRequest ? (types = ((CreateUnspecifiedTypeConnectionRequest)request).getElementTypes()).contains(UMLElementTypes.Comment_AnnotatedElementEdge) || types.contains(UMLElementTypes.Constraint_ConstrainedElementEdge) : request instanceof ReconnectRequest && ((con = ((ReconnectRequest)request).getConnectionEditPart()) instanceof CommentAnnotatedElementEditPart || con instanceof ConstraintConstrainedElementEditPart)) {
            return targetEditPart;
        }
        if ("selection" == request.getType() && this.isSelectable()) {
            return this;
        }
        return this.getParent().getTargetEditPart(request);
    }

    private void initLocator() {
        if (this.locator == null && this.executionSpecificationEnd instanceof ExecutionOccurrenceSpecification) {
            ExecutionSpecification es = ((ExecutionOccurrenceSpecification)this.executionSpecificationEnd).getExecution();
            this.locator = es.getStart() == this.executionSpecificationEnd ? new RelativeLocator(((GraphicalEditPart)this.getParent()).getFigure(), 1) : new RelativeLocator(((GraphicalEditPart)this.getParent()).getFigure(), 4);
        }
    }

    public void relocateFigure(ExecutionSpecificationEndFigure fig) {
        if (this.locator == null) {
            this.initLocator();
        }
        if (this.locator != null) {
            this.locator.relocate((IFigure)fig);
        }
    }

    static class CommentAnnotatedElementCreateCommandEx
    extends CommentAnnotatedElementCreateCommand {
        public CommentAnnotatedElementCreateCommandEx(CreateRelationshipRequest request, EObject source, EObject target) {
            super(request, source, target);
        }

        @Override
        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CommandResult res = super.doExecuteWithResult(monitor, info);
            if (this.getTarget() instanceof OccurrenceSpecification) {
                ExecutionSpecificationEndHelper.addConnectionSourceToExecutionSpecificationEnd((OccurrenceSpecification)this.getTarget(), (EObject)this.getSource());
            }
            return res;
        }
    }

    static class ConstraintConstrainedElementCreateCommandEx
    extends ConstraintConstrainedElementCreateCommand {
        public ConstraintConstrainedElementCreateCommandEx(CreateRelationshipRequest request, EObject source, EObject target) {
            super(request, source, target);
        }

        @Override
        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CommandResult res = super.doExecuteWithResult(monitor, info);
            if (this.getTarget() instanceof OccurrenceSpecification) {
                ExecutionSpecificationEndHelper.addConnectionSourceToExecutionSpecificationEnd((OccurrenceSpecification)this.getTarget(), (EObject)this.getSource());
            }
            return res;
        }
    }

    static class DummyCommand
    extends AbstractCommand {
        DummyCommand() {
        }

        public void execute() {
        }

        public void redo() {
        }

        public void undo() {
        }

        protected boolean prepare() {
            return true;
        }
    }

    static class ExecutionSpecificationEndAnchor
    extends SlidableOvalAnchor {
        public ExecutionSpecificationEndAnchor(CircleFigure circleFigure, PrecisionPoint p) {
            super((IOvalAnchorableFigure)circleFigure, p);
        }

        public ExecutionSpecificationEndAnchor(CircleFigure circleFigure) {
            super((IOvalAnchorableFigure)circleFigure);
        }

        public Point getLocation(Point reference) {
            return this.getBox().getCenter();
        }
    }

    class ExecutionSpecificationEndFigure
    extends CircleFigure {
        ExecutionSpecificationEndFigure() {
            super(16, 16);
        }

        protected void paintFigure(Graphics g) {
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(this.getBounds());
            --r.width;
            --r.height;
        }

        protected ConnectionAnchor createAnchor(PrecisionPoint p) {
            if (p == null) {
                return this.createDefaultAnchor();
            }
            return new ExecutionSpecificationEndAnchor(this, p);
        }

        protected ConnectionAnchor createDefaultAnchor() {
            return new ExecutionSpecificationEndAnchor(this);
        }

        public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
            try {
                return super.getTargetConnectionAnchorAt(p);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void validate() {
            ExecutionSpecificationEndEditPart.this.relocateFigure(this);
            super.validate();
        }
    }

    public static class ExecutionSpecificationEndHelper {
        public static void removeConnectionSourceFromExecutionSpecificationEnd(OccurrenceSpecification executionOccurrence, EObject connectionSource) {
            EAnnotation annotation = executionOccurrence.getEAnnotation("Connections");
            if (annotation != null) {
                annotation.getReferences().remove((Object)connectionSource);
            }
        }

        public static void addConnectionSourceToExecutionSpecificationEnd(OccurrenceSpecification executionOccurrence, EObject connectionSource) {
            EAnnotation annotation = executionOccurrence.getEAnnotation("Connections");
            if (annotation == null) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource("Connections");
                executionOccurrence.getEAnnotations().add((Object)annotation);
            }
            if (!annotation.getReferences().contains((Object)connectionSource)) {
                annotation.getReferences().add((Object)connectionSource);
            }
        }
    }

    static class ExecutionSpecificationEndSemanticEditPolicy
    extends SemanticEditPolicy {
        ExecutionSpecificationEndSemanticEditPolicy() {
        }

        protected org.eclipse.gef.commands.Command getSemanticCommand(IEditCommandRequest request) {
            if (request instanceof CreateRelationshipRequest) {
                return this.getCreateRelationshipCommand((CreateRelationshipRequest)request);
            }
            if (request instanceof ReorientReferenceRelationshipRequest) {
                return this.getGEFWrapper((ICommand)new ReorientExecutionSpecificationEndCommand((ReorientReferenceRelationshipRequest)request));
            }
            if (request instanceof ReorientRelationshipRequest) {
                return this.getGEFWrapper((ICommand)new ExecutionOccurrenceSpecificationMessageReorientCommand((ReorientRelationshipRequest)request));
            }
            org.eclipse.gef.commands.Command cmd = super.getSemanticCommand(request);
            return cmd;
        }

        protected org.eclipse.gef.commands.Command getStartCreateRelationshipCommand(CreateRelationshipRequest req) {
            if (UMLElementTypes.Constraint_ConstrainedElementEdge == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementCreateCommandEx(req, req.getSource(), req.getTarget()));
            }
            if (UMLElementTypes.Message_SynchEdge == req.getElementType() || UMLElementTypes.Message_AsynchEdge == req.getElementType() || UMLElementTypes.Message_ReplyEdge == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new ExecutionOccurrenceSpecificationMessageCreateCommand(req));
            }
            return null;
        }

        protected org.eclipse.gef.commands.Command getCompleteCreateRelationshipCommand(CreateRelationshipRequest req) {
            if (UMLElementTypes.Constraint_ConstrainedElementEdge == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementCreateCommandEx(req, req.getSource(), req.getTarget()));
            }
            if (UMLElementTypes.Comment_AnnotatedElementEdge == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new CommentAnnotatedElementCreateCommandEx(req, req.getSource(), req.getTarget()));
            }
            if (UMLElementTypes.Message_SynchEdge == req.getElementType() || UMLElementTypes.Message_AsynchEdge == req.getElementType() || UMLElementTypes.Message_ReplyEdge == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new ExecutionOccurrenceSpecificationMessageCreateCommand(req));
            }
            return null;
        }

        protected org.eclipse.gef.commands.Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
            org.eclipse.gef.commands.Command command = req.getTarget() == null ? this.getStartCreateRelationshipCommand(req) : this.getCompleteCreateRelationshipCommand(req);
            return command;
        }

        protected final org.eclipse.gef.commands.Command getGEFWrapper(ICommand cmd) {
            return new ICommandProxy(cmd);
        }
    }

    static class ReorientExecutionSpecificationEndCommand
    extends EditElementCommand {
        private ReorientReferenceRelationshipRequest request;

        public ReorientExecutionSpecificationEndCommand(ReorientReferenceRelationshipRequest request) {
            super(request.getLabel(), request.getNewRelationshipEnd(), (IEditCommandRequest)request);
            this.request = request;
        }

        public boolean canExecute() {
            return true;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.request.getNewRelationshipEnd() instanceof OccurrenceSpecification) {
                ExecutionSpecificationEndHelper.addConnectionSourceToExecutionSpecificationEnd((OccurrenceSpecification)this.request.getNewRelationshipEnd(), this.request.getReferenceOwner());
                if (this.request.getReferenceOwner() instanceof Constraint) {
                    ((Constraint)this.request.getReferenceOwner()).getConstrainedElements().add((Object)((OccurrenceSpecification)this.request.getNewRelationshipEnd()));
                } else if (this.request.getReferenceOwner() instanceof Comment) {
                    ((Comment)this.request.getReferenceOwner()).getAnnotatedElements().add((Object)((OccurrenceSpecification)this.request.getNewRelationshipEnd()));
                }
            }
            if (this.request.getOldRelationshipEnd() instanceof OccurrenceSpecification) {
                ExecutionSpecificationEndHelper.removeConnectionSourceFromExecutionSpecificationEnd((OccurrenceSpecification)this.request.getOldRelationshipEnd(), this.request.getReferenceOwner());
                if (this.request.getReferenceOwner() instanceof Constraint) {
                    ((Constraint)this.request.getReferenceOwner()).getConstrainedElements().remove((Object)this.request.getOldRelationshipEnd());
                } else if (this.request.getReferenceOwner() instanceof Comment) {
                    ((Comment)this.request.getReferenceOwner()).getAnnotatedElements().remove((Object)this.request.getOldRelationshipEnd());
                }
            }
            return CommandResult.newOKCommandResult();
        }
    }

    static class ViewHelper {
        Diagram diagram = null;
        Set<View> allViews = new HashSet<View>();
        Map<EObject, View> viewMaps = new HashMap<EObject, View>();

        ViewHelper() {
        }

        View findView(EObject key) {
            return this.viewMaps.get(key);
        }

        void collectViews(Diagram d) {
            if (this.diagram != d) {
                this.diagram = d;
                this.allViews.clear();
                this.viewMaps.clear();
                ViewHelper.getAllNestedViews((View)this.diagram, this.allViews);
                for (View v : this.allViews) {
                    if (v instanceof DecorationNode) continue;
                    this.viewMaps.put(v.getElement(), v);
                }
            }
        }

        private static void getAllNestedViews(View view, Set<View> allViews) {
            for (View childView : view.getChildren()) {
                ViewHelper.getAllNestedViews(childView, allViews);
                allViews.add(childView);
            }
        }
    }
}

