/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;

public class SetEnclosingInteractionCommand
extends AbstractTransactionalCommand {
    private InteractionFragment ift;
    private EObject interactionTarget;

    public SetEnclosingInteractionCommand(TransactionalEditingDomain ed, InteractionFragment ift, EObject interactionTarget) {
        super(ed, "Set enclosing interaction command", null);
        this.ift = ift;
        this.interactionTarget = interactionTarget;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SetEnclosingInteractionCommand.setEnclosingInteraction(this.ift, this.interactionTarget, false);
        return CommandResult.newOKCommandResult();
    }

    protected static void setEnclosingInteraction(InteractionFragment ift, EObject interaction, boolean forceIfCoregion) {
        if (ift != null) {
            if (interaction instanceof Interaction) {
                if (!interaction.equals(ift.getEnclosingInteraction())) {
                    if (!(ift instanceof MessageOccurrenceSpecification)) {
                        ift.setEnclosingOperand(null);
                        ift.setEnclosingInteraction((Interaction)interaction);
                    } else if (!SetEnclosingInteractionCommand.messageOccurenceSpecIsCoregion(ift, forceIfCoregion)) {
                        ift.setEnclosingOperand(null);
                        ift.setEnclosingInteraction((Interaction)interaction);
                    }
                }
            } else if (interaction instanceof InteractionOperand && !interaction.equals(ift.getEnclosingOperand())) {
                ift.setEnclosingInteraction(null);
                ift.setEnclosingOperand((InteractionOperand)interaction);
            }
        }
    }

    protected static boolean messageOccurenceSpecIsCoregion(InteractionFragment ift, boolean forceIfCoregion) {
        Element cf;
        InteractionOperand operand;
        boolean coRegion = false;
        if (!forceIfCoregion && ift instanceof MessageOccurrenceSpecification && (operand = ift.getEnclosingOperand()) != null && (cf = operand.getOwner()) instanceof CombinedFragment && InteractionOperatorKind.PAR_LITERAL.equals((Object)((CombinedFragment)cf).getInteractionOperator())) {
            Message mess = ((MessageOccurrenceSpecification)ift).getMessage();
            MessageOccurrenceSpecification otherMos = null;
            if (ift.equals(mess.getSendEvent()) && mess.getReceiveEvent() instanceof MessageOccurrenceSpecification) {
                otherMos = (MessageOccurrenceSpecification)mess.getReceiveEvent();
            } else if (ift.equals(mess.getReceiveEvent()) && mess.getSendEvent() instanceof MessageOccurrenceSpecification) {
                otherMos = (MessageOccurrenceSpecification)mess.getSendEvent();
            }
            if (otherMos != null && operand.equals(otherMos.getEnclosingOperand())) {
                coRegion = true;
            }
        }
        return coRegion;
    }
}

