/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.support.Activator;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class SupportPreferences
implements IPreferenceSupplier {
    public static final String P_CHROMATOGRAM_OPERATION_IS_UNDOABLE = "chromatogramOperationIsUndoable";
    public static final boolean DEF_CHROMATOGRAM_OPERATION_IS_UNDOABLE = true;
    public static final String P_APPLICATION_LANGUAGE = "applicationLanguage";
    public static final String DEF_APPLICATION_LANGUAGE = "";
    public static final String P_CLIPBOARD_TABLE_DEFAULT_SORTING = "clipboardTableDefaultSorting";
    public static final boolean DEF_CLIPBOARD_TABLE_DEFAULT_SORTING = false;
    public static final String LANGUAGE_AUTODETECT = "";
    public static final String LANGUAGE_EN_GB = "en_GB";
    public static final String LANGUAGE_DE_DE = "de_DE";
    public static final String[][] AVAILABLE_LANGUAGES = new String[][]{{"Autodetect", ""}, {"English", "en_GB"}, {"German", "de_DE"}};
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new SupportPreferences();
        }
        return preferenceSupplier;
    }

    @Override
    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    @Override
    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    @Override
    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_CHROMATOGRAM_OPERATION_IS_UNDOABLE, Boolean.toString(true));
        defaultValues.put(P_APPLICATION_LANGUAGE, "");
        defaultValues.put(P_CLIPBOARD_TABLE_DEFAULT_SORTING, Boolean.toString(false));
        return defaultValues;
    }

    @Override
    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static boolean isUndoable() {
        IEclipsePreferences preferences = SupportPreferences.INSTANCE().getPreferences();
        return preferences.getBoolean(P_CHROMATOGRAM_OPERATION_IS_UNDOABLE, true);
    }

    public static String getApplicationLanguage() {
        IEclipsePreferences preferences = SupportPreferences.INSTANCE().getPreferences();
        return preferences.get(P_APPLICATION_LANGUAGE, "");
    }

    public static boolean isClipboardDefaultSorting() {
        IEclipsePreferences preferences = SupportPreferences.INSTANCE().getPreferences();
        return preferences.getBoolean(P_CLIPBOARD_TABLE_DEFAULT_SORTING, false);
    }
}

