/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.history;

import java.util.Date;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.support.messages.SupportMessages;

public class EditInformation
implements IEditInformation {
    private Date date;
    private String description = "";
    private String editor = "";
    public static final String NO_DESCRIPTION = SupportMessages.INSTANCE().getMessage("labelNoDescription", new String[0]);
    public static final String NO_EDITOR = SupportMessages.INSTANCE().getMessage("labelNotAvailable", new String[0]);

    public EditInformation(String description) {
        this(new Date(), description, "");
    }

    public EditInformation(String description, String editor) {
        this(new Date(), description, editor);
    }

    public EditInformation(Date date, String description) {
        this(date, description, "");
    }

    public EditInformation(Date date, String description, String editor) {
        this.setDate(date);
        this.setDescription(description);
        this.setEditor(editor);
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    private void setDate(Date date) {
        this.date = date == null ? new Date() : date;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        if (description == null) {
            description = NO_DESCRIPTION;
        }
        this.description = description;
    }

    @Override
    public String getEditor() {
        return this.editor;
    }

    private void setEditor(String editor) {
        if (editor == null) {
            editor = NO_EDITOR;
        }
        this.editor = editor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.editor == null ? 0 : this.editor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditInformation other = (EditInformation)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.editor == null ? other.editor != null : !this.editor.equals(other.editor));
    }

    public String toString() {
        return "EditInformation [date=" + this.date + ", description=" + this.description + ", editor=" + this.editor + "]";
    }
}

