/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.model.core.selection;

import java.util.List;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.notifier.ChromatogramSelectionCSDUpdateNotifier;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.AbstractChromatogramSelection;

public class ChromatogramSelectionCSD
extends AbstractChromatogramSelection<IChromatogramPeakCSD, IChromatogramCSD>
implements IChromatogramSelectionCSD {
    private IScanCSD selectedScan;
    private IChromatogramPeakCSD selectedPeak;
    private IScan identifiedScan;

    public ChromatogramSelectionCSD(IChromatogramCSD chromatogram) throws ChromatogramIsNullException {
        this(chromatogram, true);
    }

    public ChromatogramSelectionCSD(IChromatogramCSD chromatogram, boolean fireUpdate) throws ChromatogramIsNullException {
        super((IChromatogram)chromatogram, fireUpdate);
        this.reset(fireUpdate);
    }

    public void dispose() {
        super.dispose();
        this.selectedScan = null;
        this.selectedPeak = null;
    }

    @Override
    public IChromatogramCSD getChromatogramCSD() {
        IChromatogram chromatogram = this.getChromatogram();
        if (chromatogram instanceof IChromatogramCSD) {
            return (IChromatogramCSD)chromatogram;
        }
        return null;
    }

    @Override
    public IScanCSD getSelectedScan() {
        return this.selectedScan;
    }

    public IChromatogramPeakCSD getSelectedPeak() {
        return this.selectedPeak;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean fireUpdate) {
        super.reset(fireUpdate);
        IChromatogram chromatogram = this.getChromatogram();
        if (chromatogram.getNumberOfScans() >= 1) {
            if (chromatogram instanceof IChromatogramCSD) {
                this.selectedScan = ((IChromatogramCSD)chromatogram).getSupplierScan(1);
            }
        } else {
            this.selectedScan = null;
        }
        if (chromatogram instanceof IChromatogramCSD) {
            List peaks = ((IChromatogramCSD)chromatogram).getPeaks();
            this.selectedPeak = peaks != null && peaks.size() >= 1 ? (IChromatogramPeakCSD)peaks.get(0) : null;
        }
        if (fireUpdate) {
            ChromatogramSelectionCSDUpdateNotifier.fireUpdateChange(this, false);
        }
    }

    public void setSelectedScan(IScan selectedScan) {
        if (selectedScan instanceof IScanCSD) {
            this.setSelectedScan((IScanCSD)selectedScan);
        }
    }

    public void setSelectedScan(IScan selectedScan, boolean update) {
        if (selectedScan instanceof IScanCSD) {
            this.setSelectedScan((IScanCSD)selectedScan, update);
        }
    }

    @Override
    public void setSelectedScan(IScanCSD selectedScan) {
        this.setSelectedScan(selectedScan, true);
    }

    @Override
    public void setSelectedScan(IScanCSD selectedScan, boolean update) {
        if (selectedScan != null) {
            this.selectedScan = selectedScan;
            if (update) {
                ChromatogramSelectionCSDUpdateNotifier.fireUpdateChange(this, false);
            }
        }
    }

    public void setSelectedPeak(IChromatogramPeakCSD selectedPeak) {
        this.setSelectedPeak(selectedPeak, true);
    }

    public void setSelectedPeak(IChromatogramPeakCSD selectedPeak, boolean update) {
        this.selectedPeak = selectedPeak;
        if (selectedPeak != null && update) {
            ChromatogramSelectionCSDUpdateNotifier.fireUpdateChange(this, false);
        }
    }

    public void fireUpdateChange(boolean forceReload) {
        ChromatogramSelectionCSDUpdateNotifier.fireUpdateChange(this, forceReload);
    }

    public void update(boolean forceReload) {
        super.update(forceReload);
        this.setSelectedScan(this.selectedScan, false);
        this.setSelectedPeak(this.selectedPeak, false);
        this.fireUpdateChange(forceReload);
    }

    public IScan getSelectedIdentifiedScan() {
        return this.identifiedScan;
    }

    public void setSelectedIdentifiedScan(IScan identifiedScan) {
        this.identifiedScan = identifiedScan;
    }

    public void removeSelectedIdentifiedScan() {
        this.identifiedScan = null;
    }
}

