/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.wizard.samplequant;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.IMassSpectrumIdentifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.IMassSpectrumIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.MassSpectrumIdentifier;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.core.SampleQuantProcessor;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.swt.SampleQuantTableViewerUI;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.wizard.samplequant.ISampleQuantWizardElements;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class PageDataVerification
extends AbstractExtendedWizardPage {
    private static final Logger logger = Logger.getLogger(PageDataVerification.class);
    private ISampleQuantWizardElements wizardElements;
    private Button checkBoxValidate;
    private Text textMinMatchQuality;
    private Combo comboScanIdentifier;
    private SampleQuantTableViewerUI sampleQuantTableViewerUI;
    private IMassSpectrumIdentifierSupport massSpectrumIdentifierSupport = MassSpectrumIdentifier.getMassSpectrumIdentifierSupport();

    public PageDataVerification(ISampleQuantWizardElements wizardElements) {
        super(PageDataVerification.class.getName());
        this.setTitle("Quantitation Entries");
        this.setDescription("Please select/verify the quantitation entries.");
        this.wizardElements = wizardElements;
    }

    public boolean canFinish() {
        return this.getMessage() == null;
    }

    public void setDefaultValues() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.sampleQuantTableViewerUI != null) {
                SampleQuantProcessor sampleQuantProcessor = new SampleQuantProcessor();
                File fileAdditionalReportData = new File(this.wizardElements.getAdditionalReportData());
                File fileAreaPercentReport = new File(this.wizardElements.getAreaPercentReport());
                File fileQuantitationReport = new File(this.wizardElements.getQuantitationReport());
                List sampleQuantSubstances = sampleQuantProcessor.extractSampleQuantSubstances(fileAdditionalReportData, fileAreaPercentReport, fileQuantitationReport);
                ISampleQuantReport sampleQuantReport = this.wizardElements.getSampleQuantReport();
                sampleQuantReport.getSampleQuantSubstances().clear();
                sampleQuantReport.getSampleQuantSubstances().addAll(sampleQuantSubstances);
                this.sampleQuantTableViewerUI.setInput(this.wizardElements.getSampleQuantReport().getSampleQuantSubstances());
            }
            this.validate();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createCheckBoxField(composite);
        this.createMatchQualityField(composite);
        this.createScanIdenfifierSection(composite);
        this.createInfoField(composite);
        this.createTableField(composite);
        this.validate();
        this.setControl((Control)composite);
    }

    private void createCheckBoxField(Composite composite) {
        this.checkBoxValidate = new Button(composite, 32);
        this.checkBoxValidate.setText("Sample data is valid.");
        this.checkBoxValidate.setSelection(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.checkBoxValidate.setLayoutData((Object)gridData);
        this.checkBoxValidate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageDataVerification.this.validate();
            }
        });
    }

    private void createMatchQualityField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Min Match Quality:");
        this.textMinMatchQuality = new Text(composite, 2048);
        String minMatchQuality = Double.toString(PreferenceSupplier.INSTANCE().getPreferences().getDouble("samplequantMinMatchQuality", 95.0));
        this.textMinMatchQuality.setText(minMatchQuality);
        this.textMinMatchQuality.setLayoutData((Object)new GridData(768));
        this.textMinMatchQuality.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    double minMatchQuality = Double.parseDouble(PageDataVerification.this.textMinMatchQuality.getText().trim());
                    if (minMatchQuality >= 0.0 && minMatchQuality <= 100.0) {
                        PreferenceSupplier.INSTANCE().getPreferences().putDouble("samplequantMinMatchQuality", minMatchQuality);
                        PageDataVerification.this.wizardElements.getSampleQuantReport().setMinMatchQuality(minMatchQuality);
                        PageDataVerification.this.sampleQuantTableViewerUI.setInput(PageDataVerification.this.wizardElements.getSampleQuantReport().getSampleQuantSubstances());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PageDataVerification.this.validate();
            }
        });
    }

    private void createScanIdenfifierSection(Composite parent) {
        String[] items;
        Label label = new Label(parent, 0);
        label.setText("Scan Identifier:");
        this.comboScanIdentifier = new Combo(parent, 8);
        try {
            items = MassSpectrumIdentifier.getMassSpectrumIdentifierSupport().getIdentifierNames();
        }
        catch (NoIdentifierAvailableException e1) {
            items = new String[]{"No scan identifier available."};
        }
        this.comboScanIdentifier.setItems(items);
        this.comboScanIdentifier.select(this.getSelectionIndexScanIdentifier());
        this.comboScanIdentifier.setLayoutData((Object)new GridData(768));
        this.comboScanIdentifier.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PageDataVerification.this.scanIdentifierExists()) {
                    try {
                        String identifierId = PageDataVerification.this.getScanIdentifierId();
                        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
                        preferences.put("samplequantScanIdentifier", identifierId);
                        preferences.flush();
                    }
                    catch (BackingStoreException e1) {
                        logger.warn((Object)e1);
                    }
                }
                PageDataVerification.this.validate();
            }
        });
    }

    private void createInfoField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("The following quantitation entries will be used for analysis.");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createTableField(Composite composite) {
        this.sampleQuantTableViewerUI = new SampleQuantTableViewerUI(composite, 2048);
        Table table = this.sampleQuantTableViewerUI.getTable();
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean scanIdentifierExists() {
        try {
            List identifierIds = this.massSpectrumIdentifierSupport.getAvailableIdentifierIds();
            int i = 0;
            while (true) {
                if (i >= identifierIds.size()) {
                    return false;
                }
                IMassSpectrumIdentifierSupplier supplier = this.massSpectrumIdentifierSupport.getIdentifierSupplier((String)identifierIds.get(i));
                if (this.comboScanIdentifier.getText().trim().equals(supplier.getIdentifierName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getScanIdentifierId() {
        try {
            List identifierIds = this.massSpectrumIdentifierSupport.getAvailableIdentifierIds();
            int i = 0;
            while (i < identifierIds.size()) {
                IMassSpectrumIdentifierSupplier supplier = this.massSpectrumIdentifierSupport.getIdentifierSupplier((String)identifierIds.get(i));
                if (this.comboScanIdentifier.getText().trim().equals(supplier.getIdentifierName())) {
                    return supplier.getId();
                }
                ++i;
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    private int getSelectionIndexScanIdentifier() {
        String identifierId = PreferenceSupplier.INSTANCE().getPreferences().get("samplequantScanIdentifier", "");
        try {
            List identifierIds = this.massSpectrumIdentifierSupport.getAvailableIdentifierIds();
            int i = 0;
            while (i < identifierIds.size()) {
                if (((String)identifierIds.get(i)).equals(identifierId)) {
                    return i;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    private void validate() {
        String message = null;
        try {
            double minMatchQuality = Double.parseDouble(this.textMinMatchQuality.getText().trim());
            if (minMatchQuality < 0.0 || minMatchQuality > 100.0) {
                message = "The min match quality must be in the range of 0.0 - 100.0.";
            }
        }
        catch (Exception e) {
            message = "Please set a valid min match quality.";
        }
        if (message == null && !this.scanIdentifierExists()) {
            message = "Please select a valid scan identifier.";
        }
        if (message == null) {
            this.wizardElements.setDataVerified(this.checkBoxValidate.getSelection());
            if (!this.checkBoxValidate.getSelection()) {
                message = "Please verify the data and activate the check box.";
            }
        }
        this.updateStatus(message);
    }
}

