/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.comparison.exceptions.NoMassSpectrumComparatorAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparatorSupport;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparisonSupplier;

public class MassSpectrumComparatorSupport
implements IMassSpectrumComparatorSupport {
    private final List<IMassSpectrumComparisonSupplier> suppliers = new ArrayList<IMassSpectrumComparisonSupplier>();

    protected void add(IMassSpectrumComparisonSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public String getComparatorId(int index) throws NoMassSpectrumComparatorAvailableException {
        this.areComparatorsStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoMassSpectrumComparatorAvailableException("There is no mass spectrum comparator available with the following id: " + index + ".");
        }
        IMassSpectrumComparisonSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public IMassSpectrumComparisonSupplier getMassSpectrumComparisonSupplier(String comparatorId) throws NoMassSpectrumComparatorAvailableException {
        IMassSpectrumComparisonSupplier comparisonSupplier = null;
        this.areComparatorsStored();
        if (comparatorId == null || comparatorId.equals("")) {
            throw new NoMassSpectrumComparatorAvailableException("There is no mass spectrum comparator available with the following id: " + comparatorId + ".");
        }
        for (IMassSpectrumComparisonSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(comparatorId)) continue;
            comparisonSupplier = supplier;
            break;
        }
        if (comparisonSupplier == null) {
            throw new NoMassSpectrumComparatorAvailableException("There is no mass spectrum comparator available with the following id: " + comparatorId + ".");
        }
        return comparisonSupplier;
    }

    @Override
    public Collection<IMassSpectrumComparisonSupplier> getSuppliers() {
        return Collections.unmodifiableCollection(this.suppliers);
    }

    @Override
    public List<String> getAvailableComparatorIds() throws NoMassSpectrumComparatorAvailableException {
        this.areComparatorsStored();
        ArrayList<String> availableComparators = new ArrayList<String>();
        for (IMassSpectrumComparisonSupplier supplier : this.suppliers) {
            availableComparators.add(supplier.getId());
        }
        return availableComparators;
    }

    @Override
    public String[] getComparatorNames() throws NoMassSpectrumComparatorAvailableException {
        this.areComparatorsStored();
        ArrayList<String> comparatorNames = new ArrayList<String>();
        for (IMassSpectrumComparisonSupplier supplier : this.suppliers) {
            comparatorNames.add(supplier.getComparatorName());
        }
        return comparatorNames.toArray(new String[comparatorNames.size()]);
    }

    private void areComparatorsStored() throws NoMassSpectrumComparatorAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoMassSpectrumComparatorAvailableException();
        }
    }
}

