/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.peak;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.IPeakFilter;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public abstract class AbstractPeakFilter
implements IPeakFilter {
    private static final String DESCRIPTION = "Peak Filter";

    @Override
    public IProcessingInfo validate(IPeakMSD peak, IPeakFilterSettings peakFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(this.validatePeak(peak));
        processingInfo.addMessages(this.validateFilterSettings(peakFilterSettings));
        return processingInfo;
    }

    @Override
    public IProcessingInfo validate(List<IPeakMSD> peaks, IPeakFilterSettings peakFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(this.validatePeaks(peaks));
        processingInfo.addMessages(this.validateFilterSettings(peakFilterSettings));
        return processingInfo;
    }

    @Override
    public IProcessingInfo validate(IChromatogramSelectionMSD chromatogramSelection, IPeakFilterSettings peakFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(this.validateChromatogramSelection(chromatogramSelection));
        processingInfo.addMessages(this.validateFilterSettings(peakFilterSettings));
        return processingInfo;
    }

    private IProcessingInfo validatePeak(IPeakMSD peak) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (peak == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The peak is not valid.");
        }
        return processingInfo;
    }

    private IProcessingInfo validatePeaks(List<IPeakMSD> peaks) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (peaks == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The peak list is not valid.");
        }
        return processingInfo;
    }

    private IProcessingInfo validateFilterSettings(IPeakFilterSettings peakFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (peakFilterSettings == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings are not valid.");
        }
        return processingInfo;
    }

    private IProcessingInfo validateChromatogramSelection(IChromatogramSelectionMSD chromatogramSelection) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (chromatogramSelection == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The chromatogram selection is not valid.");
        } else if (chromatogramSelection.getChromatogram() == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The chromatogram is not valid.");
        }
        return processingInfo;
    }
}

