/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.Activator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.ISubtractFilterSettingsMassSpectrum;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.ISubtractFilterSettingsPeak;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.ISupplierFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.SubtractFilterSettingsMassSpectrum;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.SubtractFilterSettingsPeak;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.SupplierFilterSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.CombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String FILTER_ID_CHROMATOGRAM = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.chromatogram";
    public static final String FILTER_ID_PEAK = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.peak";
    public static final String P_SUBTRACT_MASS_SPECTRUM = "subtractMassSpectrum";
    public static final String P_USE_NOMINAL_MASSES = "useNominalMasses";
    public static final String P_USE_NORMALIZE = "useNormalize";
    public static final String DEF_SUBTRACT_MASS_SPECTRUM = "18:200;28:1000;32:500";
    public static final boolean DEF_USE_NOMINAL_MASSES = true;
    public static final boolean DEF_USE_NORMALIZE = false;
    private static final String DELIMITER_ION_ABUNDANCE = ":";
    private static final String DELIMITER_IONS = ";";
    private static IScanMSD sessionMassSpectrum;
    private static final Logger logger;
    private static IPreferenceSupplier preferenceSupplier;

    static {
        logger = Logger.getLogger(PreferenceSupplier.class);
    }

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_SUBTRACT_MASS_SPECTRUM, DEF_SUBTRACT_MASS_SPECTRUM);
        defaultValues.put(P_USE_NOMINAL_MASSES, Boolean.toString(true));
        defaultValues.put(P_USE_NORMALIZE, Boolean.toString(false));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static void initialize() {
        IScanMSD massSpectrum = PreferenceSupplier.getSubtractMassSpectrum();
        PreferenceSupplier.setSessionSubtractMassSpectrum(massSpectrum);
    }

    public static ISupplierFilterSettings getChromatogramFilterSettings() {
        SupplierFilterSettings subtractFilterSettingsChromatogram = new SupplierFilterSettings();
        subtractFilterSettingsChromatogram.setSubtractMassSpectrum(sessionMassSpectrum);
        subtractFilterSettingsChromatogram.setUseNominalMasses(PreferenceSupplier.isUseNominalMasses());
        subtractFilterSettingsChromatogram.setUseNormalize(PreferenceSupplier.isUseNormalize());
        return subtractFilterSettingsChromatogram;
    }

    public static ISubtractFilterSettingsPeak getPeakFilterSettings() {
        SubtractFilterSettingsPeak subtractFilterSettingsPeak = new SubtractFilterSettingsPeak();
        subtractFilterSettingsPeak.setSubtractMassSpectrum(sessionMassSpectrum);
        subtractFilterSettingsPeak.setUseNominalMasses(PreferenceSupplier.isUseNominalMasses());
        subtractFilterSettingsPeak.setUseNormalize(PreferenceSupplier.isUseNormalize());
        return subtractFilterSettingsPeak;
    }

    public static ISubtractFilterSettingsMassSpectrum getMassSpectrumFilterSettings() {
        SubtractFilterSettingsMassSpectrum subtractFilterSettingsMassSpectrum = new SubtractFilterSettingsMassSpectrum();
        subtractFilterSettingsMassSpectrum.setSubtractMassSpectrum(sessionMassSpectrum);
        subtractFilterSettingsMassSpectrum.setUseNominalMasses(PreferenceSupplier.isUseNominalMasses());
        subtractFilterSettingsMassSpectrum.setUseNormalize(PreferenceSupplier.isUseNormalize());
        return subtractFilterSettingsMassSpectrum;
    }

    public static boolean isUseNominalMasses() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_USE_NOMINAL_MASSES, true);
    }

    public static boolean isUseNormalize() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_USE_NORMALIZE, false);
    }

    public static IScanMSD getSessionSubtractMassSpectrum() {
        return sessionMassSpectrum;
    }

    public static void setSessionSubtractMassSpectrum(IScanMSD normalizedMassSpectrum) {
        sessionMassSpectrum = normalizedMassSpectrum;
    }

    public static IScanMSD getSubtractMassSpectrum() {
        String[] ions;
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        String value = preferences.get(P_SUBTRACT_MASS_SPECTRUM, DEF_SUBTRACT_MASS_SPECTRUM);
        if (value == null || value.equals("")) {
            return null;
        }
        CombinedMassSpectrum subtractMassSpectrum = new CombinedMassSpectrum();
        String[] stringArray = ions = value.split(DELIMITER_IONS);
        int n = ions.length;
        int n2 = 0;
        while (n2 < n) {
            String ion = stringArray[n2];
            String[] fragment = ion.split(DELIMITER_ION_ABUNDANCE);
            if (fragment.length == 2) {
                double mz = Double.parseDouble(fragment[0]);
                float abundance = Float.parseFloat(fragment[1]);
                try {
                    Ion subtractIon = new Ion(mz, abundance);
                    subtractMassSpectrum.addIon((IIon)subtractIon);
                }
                catch (AbundanceLimitExceededException e) {
                    logger.warn((Object)e);
                }
                catch (IonLimitExceededException e) {
                    logger.warn((Object)e);
                }
            }
            ++n2;
        }
        return subtractMassSpectrum;
    }

    public static void setSubtractMassSpectrum(IScanMSD subtractMassSpectrum) {
        String value = "";
        if (subtractMassSpectrum != null) {
            StringBuilder builder = new StringBuilder();
            for (IIon ion : subtractMassSpectrum.getIons()) {
                builder.append(ion.getIon());
                builder.append(DELIMITER_ION_ABUNDANCE);
                builder.append(ion.getAbundance());
                builder.append(DELIMITER_IONS);
            }
            value = builder.toString();
        }
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        preferences.put(P_SUBTRACT_MASS_SPECTRUM, value);
    }
}

