/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.axis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IDisposeListener;
import org.swtchart.IGrid;
import org.swtchart.ISeries;
import org.swtchart.ITitle;
import org.swtchart.Range;
import org.swtchart.internal.Grid;
import org.swtchart.internal.axis.AxisTick;
import org.swtchart.internal.axis.AxisTitle;
import org.swtchart.internal.series.Series;
import org.swtchart.internal.series.SeriesSet;

public class Axis
implements IAxis {
    public static final int MARGIN = 5;
    public static final double DEFAULT_MIN = 0.0;
    public static final double DEFAULT_MAX = 1.0;
    public static final double DEFAULT_LOG_SCALE_MIN = 0.1;
    public static final double DEFAULT_LOG_SCALE_MAX = 1.0;
    private static final double ZOOM_RATIO = 0.2;
    private static final double SCROLL_RATIO = 0.1;
    private static final double MAX_RESOLUTION = 13.0;
    private int id;
    private IAxis.Direction direction;
    private IAxis.Position position;
    private double min;
    private double max;
    private AxisTitle title;
    private AxisTick tick;
    private Grid grid;
    private Chart chart;
    private boolean logScaleEnabled;
    private boolean categoryAxisEnabled;
    private String[] categorySeries;
    private int numRisers;
    private boolean isHorizontalAxis;
    private int width;
    private int height;
    private List<IDisposeListener> listeners;

    public Axis(int id, IAxis.Direction direction, Chart chart) {
        this.id = id;
        this.direction = direction;
        this.chart = chart;
        this.grid = new Grid(this);
        this.title = new AxisTitle(chart, 0, this, direction);
        this.tick = new AxisTick(chart, this);
        this.listeners = new ArrayList<IDisposeListener>();
        this.position = IAxis.Position.Primary;
        this.min = 0.0;
        this.max = 1.0;
        if (direction == IAxis.Direction.X) {
            this.title.setText("X axis");
        } else if (direction == IAxis.Direction.Y) {
            this.title.setText("Y axis");
        }
        this.logScaleEnabled = false;
        this.categoryAxisEnabled = false;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public IAxis.Direction getDirection() {
        return this.direction;
    }

    @Override
    public IAxis.Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(IAxis.Position position) {
        if (position == null) {
            SWT.error((int)4);
        }
        if (this.position == position) {
            return;
        }
        this.position = position;
        this.chart.updateLayout();
    }

    @Override
    public void setRange(Range range) {
        this.setRange(range, true);
    }

    public void setRange(Range range, boolean update) {
        if (range == null) {
            SWT.error((int)4);
            return;
        }
        if (Double.isNaN(range.lower) || Double.isNaN(range.upper) || Double.isInfinite(range.lower) || Double.isInfinite(range.upper) || range.lower > range.upper) {
            throw new IllegalArgumentException("Illegal range: " + range);
        }
        if (this.min == range.lower && this.max == range.upper) {
            return;
        }
        if (this.isValidCategoryAxis()) {
            this.min = (int)range.lower;
            this.max = (int)range.upper;
            if (this.min < 0.0) {
                this.min = 0.0;
            }
            if (this.max > (double)(this.categorySeries.length - 1)) {
                this.max = this.categorySeries.length - 1;
            }
        } else {
            if (range.lower == range.upper) {
                throw new IllegalArgumentException("Given range is invalid");
            }
            if (this.logScaleEnabled && range.lower <= 0.0) {
                range.lower = this.min;
            }
            if (Math.abs(range.lower / (range.upper - range.lower)) > Math.pow(10.0, 13.0)) {
                return;
            }
            this.min = range.lower;
            this.max = range.upper;
        }
        if (update) {
            this.chart.updateLayout();
        }
    }

    @Override
    public Range getRange() {
        return new Range(this.min, this.max);
    }

    @Override
    public ITitle getTitle() {
        return this.title;
    }

    @Override
    public AxisTick getTick() {
        return this.tick;
    }

    @Override
    public void enableLogScale(boolean enabled) throws IllegalStateException {
        if (this.logScaleEnabled == enabled) {
            return;
        }
        if (enabled) {
            double minSeriesValue = this.getMinSeriesValue();
            if (minSeriesValue <= 0.0) {
                throw new IllegalStateException("Series contain zero or negative value.");
            }
            if (this.min <= 0.0) {
                double d = this.min = Double.isNaN(minSeriesValue) ? 0.1 : minSeriesValue;
            }
            if (this.max < this.min) {
                this.max = 1.0;
            }
            if (this.categoryAxisEnabled) {
                this.categoryAxisEnabled = false;
                ((SeriesSet)this.chart.getSeriesSet()).updateCompressor(this);
            }
        }
        this.logScaleEnabled = enabled;
        this.chart.updateLayout();
        ((SeriesSet)this.chart.getSeriesSet()).compressAllSeries();
    }

    private double getMinSeriesValue() {
        double minimum = Double.NaN;
        ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                double lower;
                block7: {
                    ISeries series;
                    block6: {
                        series = iSeriesArray[n2];
                        if (series.getYSeries().length == 0) break block5;
                        if (this.direction != IAxis.Direction.X || series.getXAxisId() != this.getId()) break block6;
                        lower = ((Series)series).getXRange().lower;
                        break block7;
                    }
                    if (this.direction != IAxis.Direction.Y || series.getYAxisId() != this.getId()) break block5;
                    lower = ((Series)series).getYRange().lower;
                }
                if (Double.isNaN(minimum) || lower < minimum) {
                    minimum = lower;
                }
            }
            ++n2;
        }
        return minimum;
    }

    @Override
    public boolean isLogScaleEnabled() {
        return this.logScaleEnabled;
    }

    @Override
    public IGrid getGrid() {
        return this.grid;
    }

    @Override
    public void adjustRange() {
        this.adjustRange(true);
    }

    public void adjustRange(boolean update) {
        if (this.isValidCategoryAxis()) {
            this.setRange(new Range(0.0, this.categorySeries.length - 1));
            return;
        }
        double minimum = Double.NaN;
        double maximum = Double.NaN;
        ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            int axisId;
            ISeries series = iSeriesArray[n2];
            int n3 = axisId = this.direction == IAxis.Direction.X ? series.getXAxisId() : series.getYAxisId();
            if (series.isVisible() && this.getId() == axisId) {
                int length = this.isHorizontalAxis ? this.chart.getPlotArea().getSize().x : this.chart.getPlotArea().getSize().y;
                Range range = ((Series)series).getAdjustedRange(this, length);
                if (Double.isNaN(minimum) || range.lower < minimum) {
                    minimum = range.lower;
                }
                if (Double.isNaN(maximum) || range.upper > maximum) {
                    maximum = range.upper;
                }
            }
            ++n2;
        }
        if (!Double.isNaN(minimum) && !Double.isNaN(maximum)) {
            if (minimum == maximum) {
                double margin = minimum == 0.0 ? 1.0 : Math.abs(minimum / 2.0);
                minimum -= margin;
                maximum += margin;
            }
            this.setRange(new Range(minimum, maximum), update);
        }
    }

    @Override
    public void zoomIn() {
        this.zoomIn((this.max + this.min) / 2.0);
    }

    @Override
    public void zoomIn(double coordinate) {
        double lower = this.min;
        double upper = this.max;
        if (this.isValidCategoryAxis()) {
            if (lower != upper) {
                if ((this.min + this.max) / 2.0 < coordinate) {
                    lower = this.min + 1.0;
                } else if (coordinate < (this.min + this.max) / 2.0) {
                    upper = this.max - 1.0;
                } else {
                    lower = this.min + 1.0;
                    upper = this.max - 1.0;
                }
            }
        } else if (this.isLogScaleEnabled()) {
            double digitMin = Math.log10(this.min);
            double digitMax = Math.log10(this.max);
            double digitCoordinate = Math.log10(coordinate);
            lower = Math.pow(10.0, digitMin + 0.2 * (digitCoordinate - digitMin));
            upper = Math.pow(10.0, digitMax + 0.2 * (digitCoordinate - digitMax));
        } else {
            lower = this.min + 0.4 * (coordinate - this.min);
            upper = this.max + 0.4 * (coordinate - this.max);
        }
        this.setRange(new Range(lower, upper));
    }

    @Override
    public void zoomOut() {
        this.zoomOut((this.min + this.max) / 2.0);
    }

    @Override
    public void zoomOut(double coordinate) {
        double lower = this.min;
        double upper = this.max;
        if (this.isValidCategoryAxis()) {
            if ((this.min + this.max) / 2.0 < coordinate && this.min != 0.0) {
                lower = this.min - 1.0;
            } else if (coordinate < (this.min + this.max) / 2.0 && this.max != (double)(this.categorySeries.length - 1)) {
                upper = this.max + 1.0;
            } else {
                lower = this.min - 1.0;
                upper = this.max + 1.0;
            }
        } else if (this.isLogScaleEnabled()) {
            double digitMin = Math.log10(this.min);
            double digitMax = Math.log10(this.max);
            double digitCoordinate = Math.log10(coordinate);
            lower = Math.pow(10.0, (digitMin - 0.2 * digitCoordinate) / 0.8);
            upper = Math.pow(10.0, (digitMax - 0.2 * digitCoordinate) / 0.8);
        } else {
            lower = (this.min - 0.4 * coordinate) / 0.6;
            upper = (this.max - 0.4 * coordinate) / 0.6;
        }
        this.setRange(new Range(lower, upper));
    }

    @Override
    public void scrollUp() {
        double lower = this.min;
        double upper = this.max;
        if (this.isValidCategoryAxis()) {
            if (upper < (double)(this.categorySeries.length - 1)) {
                lower = this.min + 1.0;
                upper = this.max + 1.0;
            }
        } else if (this.isLogScaleEnabled()) {
            double digitMax = Math.log10(upper);
            double digitMin = Math.log10(lower);
            upper = Math.pow(10.0, digitMax + (digitMax - digitMin) * 0.1);
            lower = Math.pow(10.0, digitMin + (digitMax - digitMin) * 0.1);
        } else {
            lower = this.min + (this.max - this.min) * 0.1;
            upper = this.max + (this.max - this.min) * 0.1;
        }
        this.setRange(new Range(lower, upper));
    }

    @Override
    public void scrollDown() {
        double lower = this.min;
        double upper = this.max;
        if (this.isValidCategoryAxis()) {
            if (lower >= 1.0) {
                lower = this.min - 1.0;
                upper = this.max - 1.0;
            }
        } else if (this.isLogScaleEnabled()) {
            double digitMax = Math.log10(upper);
            double digitMin = Math.log10(lower);
            upper = Math.pow(10.0, digitMax - (digitMax - digitMin) * 0.1);
            lower = Math.pow(10.0, digitMin - (digitMax - digitMin) * 0.1);
        } else {
            lower = this.min - (this.max - this.min) * 0.1;
            upper = this.max - (this.max - this.min) * 0.1;
        }
        this.setRange(new Range(lower, upper));
    }

    @Override
    public boolean isCategoryEnabled() {
        return this.categoryAxisEnabled;
    }

    public boolean isValidCategoryAxis() {
        return this.categoryAxisEnabled && this.categorySeries != null && this.categorySeries.length != 0;
    }

    @Override
    public void enableCategory(boolean enabled) {
        if (this.categoryAxisEnabled == enabled) {
            return;
        }
        if (enabled) {
            if (this.direction == IAxis.Direction.Y) {
                throw new IllegalStateException("Y axis cannot be category axis.");
            }
            if (this.categorySeries != null && this.categorySeries.length != 0) {
                this.min = this.min < 0.0 || this.min >= (double)this.categorySeries.length ? 0 : (int)this.min;
                this.max = this.max < 0.0 || this.max >= (double)this.categorySeries.length ? (this.max = (double)(this.categorySeries.length - 1)) : (double)((int)this.max);
            }
            this.logScaleEnabled = false;
        }
        this.categoryAxisEnabled = enabled;
        this.chart.updateLayout();
        ((SeriesSet)this.chart.getSeriesSet()).updateCompressor(this);
        ((SeriesSet)this.chart.getSeriesSet()).updateStackAndRiserData();
    }

    @Override
    public void setCategorySeries(String[] series) {
        if (series == null) {
            SWT.error((int)4);
            return;
        }
        if (this.direction == IAxis.Direction.Y) {
            throw new IllegalStateException("Y axis cannot be category axis.");
        }
        String[] copiedSeries = new String[series.length];
        System.arraycopy(series, 0, copiedSeries, 0, series.length);
        this.categorySeries = copiedSeries;
        if (this.isValidCategoryAxis()) {
            this.min = this.min < 0.0 ? 0 : (int)this.min;
            this.max = this.max >= (double)this.categorySeries.length ? (this.max = (double)(this.categorySeries.length - 1)) : (double)((int)this.max);
        }
        this.chart.updateLayout();
        ((SeriesSet)this.chart.getSeriesSet()).updateCompressor(this);
        ((SeriesSet)this.chart.getSeriesSet()).updateStackAndRiserData();
    }

    @Override
    public String[] getCategorySeries() {
        String[] copiedCategorySeries = null;
        if (this.categorySeries != null) {
            copiedCategorySeries = new String[this.categorySeries.length];
            System.arraycopy(this.categorySeries, 0, copiedCategorySeries, 0, this.categorySeries.length);
        }
        return copiedCategorySeries;
    }

    @Override
    public int getPixelCoordinate(double dataCoordinate) {
        return this.getPixelCoordinate(dataCoordinate, this.min, this.max);
    }

    public int getPixelCoordinate(double dataCoordinate, double lower, double upper) {
        int pixelCoordinate = this.isHorizontalAxis ? (this.logScaleEnabled ? (int)((Math.log10(dataCoordinate) - Math.log10(lower)) / (Math.log10(upper) - Math.log10(lower)) * (double)this.width) : (this.categoryAxisEnabled ? (int)((dataCoordinate + 0.5 - lower) / (upper + 1.0 - lower) * (double)this.width) : (int)((dataCoordinate - lower) / (upper - lower) * (double)this.width))) : (this.logScaleEnabled ? (int)((Math.log10(upper) - Math.log10(dataCoordinate)) / (Math.log10(upper) - Math.log10(lower)) * (double)this.height) : (this.categoryAxisEnabled ? (int)((upper - dataCoordinate + 0.5) / (upper + 1.0 - lower) * (double)this.height) : (int)((upper - dataCoordinate) / (upper - lower) * (double)this.height)));
        return pixelCoordinate;
    }

    @Override
    public double getDataCoordinate(int pixelCoordinate) {
        return this.getDataCoordinate(pixelCoordinate, this.min, this.max);
    }

    public double getDataCoordinate(int pixelCoordinate, double lower, double upper) {
        double dataCoordinate = this.isHorizontalAxis ? (this.logScaleEnabled ? Math.pow(10.0, (double)pixelCoordinate / (double)this.width * (Math.log10(upper) - Math.log10(lower)) + Math.log10(lower)) : (this.categoryAxisEnabled ? Math.floor((double)pixelCoordinate / (double)this.width * (upper + 1.0 - lower) + lower) : (double)pixelCoordinate / (double)this.width * (upper - lower) + lower)) : (this.logScaleEnabled ? Math.pow(10.0, Math.log10(upper) - (double)pixelCoordinate / (double)this.height * (Math.log10(upper) - Math.log10(lower))) : (this.categoryAxisEnabled ? Math.floor(upper + 1.0 - (double)pixelCoordinate / (double)this.height * (upper + 1.0 - lower)) : (double)(this.height - pixelCoordinate) / (double)this.height * (upper - lower) + lower));
        return dataCoordinate;
    }

    public void setNumRisers(int numRisers) {
        this.numRisers = numRisers;
    }

    public int getNumRisers() {
        return this.numRisers;
    }

    public boolean isHorizontalAxis() {
        int orientation = this.chart.getOrientation();
        return this.direction == IAxis.Direction.X && orientation == 256 || this.direction == IAxis.Direction.Y && orientation == 512;
    }

    protected void dispose() {
        this.tick.getAxisTickLabels().dispose();
        this.tick.getAxisTickMarks().dispose();
        this.title.dispose();
        for (IDisposeListener listener : this.listeners) {
            listener.disposed(new Event());
        }
    }

    @Override
    public void addDisposeListener(IDisposeListener listener) {
        this.listeners.add(listener);
    }

    public void updateLayoutData() {
        this.title.updateLayoutData();
        this.tick.updateLayoutData();
    }

    public void refresh() {
        int orientation = this.chart.getOrientation();
        this.isHorizontalAxis = this.direction == IAxis.Direction.X && orientation == 256 || this.direction == IAxis.Direction.Y && orientation == 512;
        this.width = this.chart.getPlotArea().getBounds().width;
        this.height = this.chart.getPlotArea().getBounds().height;
    }

    public boolean isDateEnabled() {
        if (!this.isHorizontalAxis) {
            return false;
        }
        ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            if (series.getXAxisId() == this.id && ((Series)series).isDateSeries() && series.isVisible()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

