/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.IChromatogramAndPeakSelectionView;
import org.eclipse.chemclipse.ux.extension.ui.definitions.ChromatogramType;
import org.eclipse.chemclipse.ux.extension.ui.definitions.PeakType;
import org.eclipse.chemclipse.ux.extension.ui.explorer.AbstractSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractChromatogramAndPeakSelectionView
extends AbstractSelectionView
implements IChromatogramAndPeakSelectionView {
    private IChromatogramSelectionMSD chromatogramSelection;
    private IChromatogramPeakMSD chromatogramPeak;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    public AbstractChromatogramAndPeakSelectionView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @Override
    public IChromatogramSelectionMSD getChromatogramSelection() {
        if (this.chromatogramSelection == null) {
            this.chromatogramSelection = ChromatogramType.getChromatogramSelectionMSD();
        }
        return this.chromatogramSelection;
    }

    @Override
    public void setChromatogramSelection(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    @Override
    public IChromatogramPeakMSD getChromatogramPeak() {
        IPeakMSD peakMSD;
        if (this.chromatogramPeak == null && (peakMSD = PeakType.getSelectedPeakMSD()) instanceof IChromatogramPeakMSD) {
            this.chromatogramPeak = (IChromatogramPeakMSD)peakMSD;
        }
        return this.chromatogramPeak;
    }

    @Override
    public void setChromatogramPeak(IChromatogramPeakMSD chromatogramPeak) {
        this.chromatogramPeak = chromatogramPeak;
    }

    @Override
    public boolean doUpdate(IChromatogramSelectionMSD chromatogramSelection, IChromatogramPeakMSD chromatogramPeak) {
        return this.isPartVisible() && chromatogramSelection != null && chromatogramPeak != null;
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    AbstractChromatogramAndPeakSelectionView.this.chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
                    AbstractChromatogramAndPeakSelectionView.this.chromatogramPeak = (IChromatogramPeakMSD)event.getProperty("ChromatogramPeakMSD");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    AbstractChromatogramAndPeakSelectionView.this.update(AbstractChromatogramAndPeakSelectionView.this.chromatogramSelection, AbstractChromatogramAndPeakSelectionView.this.chromatogramPeak, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/chromatogramandpeakselection", this.eventHandler);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

