/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraWriter;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.AbstractAmdisWriter;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class AmdisMSLWriter
extends AbstractAmdisWriter
implements IMassSpectraWriter {
    private static final Logger logger = Logger.getLogger(AmdisMSLWriter.class);

    public void writeMassSpectrum(FileWriter fileWriter, IScanMSD massSpectrum, IProgressMonitor monitor) throws IOException {
        IScanMSD normalizedMassSpectrum;
        try {
            normalizedMassSpectrum = this.makeDeepCopyAndNormalize(massSpectrum);
        }
        catch (CloneNotSupportedException e) {
            logger.warn((Object)e);
            return;
        }
        IIdentificationTarget identificationTarget = this.getIdentificationTarget(normalizedMassSpectrum);
        fileWriter.write(String.valueOf(this.getNameField(massSpectrum, identificationTarget)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getCasNumberField(identificationTarget)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getSmilesField(identificationTarget)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getRetentionTimeField(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getRetentionIndexField(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getCommentsField(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getSourceField(normalizedMassSpectrum, identificationTarget)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getNumberOfPeaks(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(String.valueOf(this.getMassSpectra(normalizedMassSpectrum)) + this.CRLF);
        fileWriter.write(this.CRLF);
        fileWriter.flush();
    }

    private String getMassSpectra(IScanMSD massSpectrum) {
        int blockSize = 5;
        int actualPosition = 1;
        StringBuilder builder = new StringBuilder();
        List ions = massSpectrum.getIons();
        for (IIon ion : ions) {
            if (actualPosition > blockSize) {
                builder.append(this.CRLF);
                actualPosition = 1;
            }
            builder.append("(");
            builder.append(AbstractIon.getIon((double)ion.getIon()));
            builder.append(" ");
            builder.append(AbstractIon.getAbundance((float)ion.getAbundance()));
            builder.append(")");
            if (actualPosition < blockSize) {
                builder.append(" ");
            }
            ++actualPosition;
        }
        return builder.toString();
    }
}

