/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.xy.core;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramImportConverter;
import org.eclipse.chemclipse.converter.processing.chromatogram.ChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.csd.converter.chromatogram.AbstractChromatogramCSDImportConverter;
import org.eclipse.chemclipse.csd.converter.processing.chromatogram.ChromatogramCSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.csd.converter.processing.chromatogram.IChromatogramCSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.csd.converter.supplier.xy.internal.support.SpecificationValidator;
import org.eclipse.chemclipse.csd.converter.supplier.xy.io.ChromatogramReader;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramImportConverter
extends AbstractChromatogramCSDImportConverter
implements IChromatogramImportConverter {
    private static final Logger logger = Logger.getLogger(ChromatogramImportConverter.class);
    private static final String DESCRIPTION = "XY Import Converter";

    public IChromatogramCSDImportConverterProcessingInfo convert(File file, IProgressMonitor monitor) {
        ChromatogramCSDImportConverterProcessingInfo processingInfo = new ChromatogramCSDImportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(file);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReader reader = new ChromatogramReader();
            monitor.subTask("Import XY Chromatogram");
            try {
                IChromatogramCSD chromatogram = reader.read(file, monitor);
                processingInfo.setChromatogram(chromatogram);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    public IChromatogramOverviewImportConverterProcessingInfo convertOverview(File file, IProgressMonitor monitor) {
        ChromatogramOverviewImportConverterProcessingInfo processingInfo = new ChromatogramOverviewImportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(file);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReader reader = new ChromatogramReader();
            monitor.subTask("Import XY Chromatogram Overview");
            try {
                IChromatogramOverview chromatogramOverview = reader.readOverview(file, monitor);
                processingInfo.setChromatogramOverview(chromatogramOverview);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

