/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.xy.core;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramExportConverter;
import org.eclipse.chemclipse.converter.processing.chromatogram.ChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.csd.converter.chromatogram.AbstractChromatogramCSDExportConverter;
import org.eclipse.chemclipse.csd.converter.supplier.xy.internal.support.SpecificationValidator;
import org.eclipse.chemclipse.csd.converter.supplier.xy.io.ChromatogramWriter;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramExportConverter
extends AbstractChromatogramCSDExportConverter
implements IChromatogramExportConverter {
    private static final Logger logger = Logger.getLogger(ChromatogramExportConverter.class);
    private static final String DESCRIPTION = "XY Export Converter";

    public IChromatogramExportConverterProcessingInfo convert(File file, IChromatogramCSD chromatogram, IProgressMonitor monitor) {
        ChromatogramExportConverterProcessingInfo processingInfo = new ChromatogramExportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(file = SpecificationValidator.validateSpecification(file));
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            monitor.subTask("Export XY Chromatogram");
            ChromatogramWriter writer = new ChromatogramWriter();
            try {
                writer.writeChromatogram(file, chromatogram, monitor);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
            processingInfo.setFile(file);
        }
        return processingInfo;
    }
}

