/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.ui.swt;

import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.IMassSpectrumFilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.MassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.exceptions.NoMassSpectrumFilterSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences.FilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.IMassSpectrumIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.MassSpectrumIdentifier;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.notifier.IMassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.model.notifier.MassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMassSpectrumUI;
import org.eclipse.chemclipse.msd.swt.ui.support.MassSpectrumFileSupport;
import org.eclipse.chemclipse.rcp.app.ui.handlers.PerspectiveSwitchHandler;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PinnedMassSpectrumEditUIWithLabel
extends Composite
implements IMassSpectrumSelectionUpdateNotifier {
    private static final Logger logger = Logger.getLogger(PinnedMassSpectrumEditUIWithLabel.class);
    private SimpleMassSpectrumUI massSpectrumUI;
    private Button pinButton;
    private Button addSubtractMassSpectrumButton;
    private Button saveButton;
    private Combo filterCombo;
    private Combo identifierCombo;
    private Label infoLabel;
    private IScanMSD originalMassSpectrum;
    private IScanMSD clonedMassSpectrum;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0####");
    private MassValueDisplayPrecision massValueDisplayPrecision;
    private boolean isPinned = false;
    private List<String> massSpectrumFilterIds;
    private String[] massSpectrumFilterNames;
    private List<String> massSpectrumIdentifierIds;
    private String[] massSpectrumIdentifierNames;
    private IEventBroker eventBroker;

    public PinnedMassSpectrumEditUIWithLabel(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision, IEventBroker eventBroker) {
        super(parent, style);
        this.eventBroker = eventBroker;
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        try {
            IMassSpectrumFilterSupport massSpectrumFilterSupport = MassSpectrumFilter.getMassSpectrumFilterSupport();
            this.massSpectrumFilterIds = massSpectrumFilterSupport.getAvailableFilterIds();
            this.massSpectrumFilterNames = massSpectrumFilterSupport.getFilterNames();
        }
        catch (NoMassSpectrumFilterSupplierAvailableException noMassSpectrumFilterSupplierAvailableException) {
            this.massSpectrumFilterIds = new ArrayList<String>();
            this.massSpectrumFilterNames = new String[0];
        }
        try {
            IMassSpectrumIdentifierSupport massSpectrumIdentifierSupport = MassSpectrumIdentifier.getMassSpectrumIdentifierSupport();
            this.massSpectrumIdentifierIds = massSpectrumIdentifierSupport.getAvailableIdentifierIds();
            this.massSpectrumIdentifierNames = massSpectrumIdentifierSupport.getIdentifierNames();
        }
        catch (NoIdentifierAvailableException noIdentifierAvailableException) {
            this.massSpectrumIdentifierIds = new ArrayList<String>();
            this.massSpectrumIdentifierNames = new String[0];
        }
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Composite labelbar = new Composite(composite, 4);
        labelbar.setLayout((Layout)new GridLayout(7, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        labelbar.setLayoutData((Object)gridData);
        this.pinButton = new Button(labelbar, 8);
        this.setPinButtonText();
        this.pinButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PinnedMassSpectrumEditUIWithLabel.this.isPinned = !PinnedMassSpectrumEditUIWithLabel.this.isPinned;
                PinnedMassSpectrumEditUIWithLabel.this.setPinButtonText();
            }
        });
        this.addSubtractMassSpectrumButton = new Button(labelbar, 8);
        this.addSubtractMassSpectrumButton.setText("");
        this.addSubtractMassSpectrumButton.setImage(ApplicationImageFactory.getInstance().getImage("subtractFilterAddSelectedScan.gif", "16x16"));
        this.addSubtractMassSpectrumButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum != null) {
                    String perspectiveId = "org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.main";
                    String viewId = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.ui.part.sessionSubtractMassSpectrum";
                    PerspectiveSwitchHandler.focusPerspectiveAndView((String)perspectiveId, (String)viewId);
                    PreferenceSupplier.setSessionSubtractMassSpectrum(null);
                    IScanMSD massSpectrum1 = PreferenceSupplier.getSessionSubtractMassSpectrum();
                    boolean useNormalize = PreferenceSupplier.isUseNormalize();
                    IScanMSD normalizedMassSpectrum = FilterSupport.getCombinedMassSpectrum((IScanMSD)massSpectrum1, (IScanMSD)PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum, null, (boolean)useNormalize);
                    PreferenceSupplier.setSessionSubtractMassSpectrum((IScanMSD)normalizedMassSpectrum);
                    PinnedMassSpectrumEditUIWithLabel.this.eventBroker.send("filter/supplier/subtract/update/session/subtractmassspectrum", (Object)true);
                }
            }
        });
        this.filterCombo = new Combo(labelbar, 0);
        this.filterCombo.setLayoutData((Object)new GridData(768));
        this.filterCombo.setItems(this.massSpectrumFilterNames);
        Button filterButton = new Button(labelbar, 0);
        filterButton.setText("Filter");
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = PinnedMassSpectrumEditUIWithLabel.this.filterCombo.getSelectionIndex();
                if (index >= 0 && index < PinnedMassSpectrumEditUIWithLabel.this.massSpectrumFilterIds.size()) {
                    String filterId = (String)PinnedMassSpectrumEditUIWithLabel.this.massSpectrumFilterIds.get(index);
                    if (PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum != null) {
                        PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum.getTargets().clear();
                        MassSpectrumFilter.applyFilter((IScanMSD)PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum, (String)filterId, (IProgressMonitor)new NullProgressMonitor());
                        PinnedMassSpectrumEditUIWithLabel.this.updateAfterProcessing();
                    }
                }
            }
        });
        this.identifierCombo = new Combo(labelbar, 0);
        this.identifierCombo.setItems(this.massSpectrumIdentifierNames);
        this.identifierCombo.setLayoutData((Object)new GridData(768));
        Button identifierButton = new Button(labelbar, 0);
        identifierButton.setText("Identify");
        identifierButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = PinnedMassSpectrumEditUIWithLabel.this.identifierCombo.getSelectionIndex();
                if (index >= 0 && index < PinnedMassSpectrumEditUIWithLabel.this.massSpectrumIdentifierIds.size()) {
                    final String identifierId = (String)PinnedMassSpectrumEditUIWithLabel.this.massSpectrumIdentifierIds.get(index);
                    if (PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum != null) {
                        PerspectiveSwitchHandler.focusPerspectiveAndView((String)"org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.main", (String)"org.eclipse.chemclipse.ux.extension.msd.ui.part.massSpectrumTargetsView");
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    monitor.beginTask("Mass Spectrum Identification", -1);
                                    MassSpectrumIdentifier.identify((IScanMSD)PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum, (String)identifierId, (IProgressMonitor)monitor);
                                    MassSpectrumSelectionUpdateNotifier.fireUpdateChange((IScanMSD)PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum, (boolean)true);
                                    PinnedMassSpectrumEditUIWithLabel.this.originalMassSpectrum.setOptimizedMassSpectrum(PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum);
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        };
                        ProgressMonitorDialog monitor = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                        try {
                            monitor.run(true, true, runnable);
                        }
                        catch (InvocationTargetException e1) {
                            logger.warn((Object)e1);
                        }
                        catch (InterruptedException e1) {
                            logger.warn((Object)e1);
                        }
                    }
                }
            }
        });
        this.saveButton = new Button(labelbar, 8);
        this.saveButton.setImage(ApplicationImageFactory.getInstance().getImage("saveas.gif", "16x16"));
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MassSpectrumFileSupport.saveMassSpectrum((IScanMSD)PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum);
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        this.infoLabel = new Label(labelbar, 0);
        this.infoLabel.setText("");
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 6;
        this.infoLabel.setLayoutData((Object)gridData);
        this.massSpectrumUI = new SimpleMassSpectrumUI(composite, 2052, this.massValueDisplayPrecision);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.massSpectrumUI.setLayoutData(gridData);
        this.massSpectrumUI.getPlotArea().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MassSpectrumSelectionUpdateNotifier.fireUpdateChange((IScanMSD)PinnedMassSpectrumEditUIWithLabel.this.clonedMassSpectrum, (boolean)true);
            }
        });
    }

    public void update(IScanMSD massSpectrum, boolean forceReload) {
        if (massSpectrum != null && !this.isPinned && this.clonedMassSpectrum != massSpectrum) {
            try {
                this.originalMassSpectrum = massSpectrum;
                this.clonedMassSpectrum = massSpectrum.makeDeepCopy();
                this.setMassSpectrumLabel(this.clonedMassSpectrum);
                this.massSpectrumUI.update(this.clonedMassSpectrum, forceReload);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.infoLabel.setText("It's not possible to clone the mass spectrum.");
            }
        }
    }

    private void updateAfterProcessing() {
        this.massSpectrumUI.update(this.clonedMassSpectrum, true);
        this.setMassSpectrumLabel(this.clonedMassSpectrum);
    }

    private void setPinButtonText() {
        this.pinButton.setText("");
        if (this.isPinned) {
            this.pinButton.setImage(ApplicationImageFactory.getInstance().getImage("unpinMassSpectrum.gif", "16x16"));
        } else {
            this.pinButton.setImage(ApplicationImageFactory.getInstance().getImage("pinMassSpectrum.gif", "16x16"));
        }
    }

    private void setMassSpectrumLabel(IScanMSD massSpectrum) {
        StringBuilder builder = new StringBuilder();
        if (massSpectrum instanceof IVendorMassSpectrum) {
            IVendorMassSpectrum actualMassSpectrum = (IVendorMassSpectrum)massSpectrum;
            builder.append("Scan: ");
            builder.append(actualMassSpectrum.getScanNumber());
            builder.append(" | ");
            builder.append("RT: ");
            builder.append(this.decimalFormat.format((double)actualMassSpectrum.getRetentionTime() / 60000.0));
            builder.append(" | ");
            builder.append("RI: ");
            if (org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                builder.append(Integer.toString((int)actualMassSpectrum.getRetentionIndex()));
            } else {
                builder.append(this.decimalFormat.format(actualMassSpectrum.getRetentionIndex()));
            }
            builder.append(" | ");
            builder.append("Detector: MS");
            builder.append(actualMassSpectrum.getMassSpectrometer());
            builder.append(" | ");
            builder.append("Type: ");
            builder.append(actualMassSpectrum.getMassSpectrumTypeDescription());
            builder.append(" | ");
        }
        builder.append("Signal: ");
        builder.append((int)massSpectrum.getTotalSignal());
        this.infoLabel.setText(builder.toString());
    }
}

