/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.activator;

import java.net.URL;
import java.util.Map;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractActivatorUI
extends AbstractUIPlugin {
    private ScopedPreferenceStore preferenceStore;

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.preferenceStore = null;
        super.stop(context);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            return super.getPreferenceStore();
        }
        return this.preferenceStore;
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    protected void initializePreferenceStore(IPreferenceSupplier preferenceSupplier) {
        if (preferenceSupplier != null) {
            this.preferenceStore = new ScopedPreferenceStore(preferenceSupplier.getScopeContext(), preferenceSupplier.getPreferenceNode());
            Map initializationEntries = preferenceSupplier.getDefaultValues();
            for (Map.Entry entry : initializationEntries.entrySet()) {
                this.preferenceStore.setDefault((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected void initializeImageRegistry(Map<String, String> imageHashMap) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        if (imageHashMap != null && imageRegistry != null) {
            for (Map.Entry<String, String> entry : imageHashMap.entrySet()) {
                imageRegistry.put(entry.getKey(), this.createImageDescriptor(this.getBundle(), entry.getValue()));
            }
        }
    }

    private ImageDescriptor createImageDescriptor(Bundle bundle, String string) {
        ImageDescriptor imageDescriptor = null;
        Path path = new Path(string);
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        return imageDescriptor;
    }
}

