/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.series;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;

public class MultipleSeries
implements IMultipleSeries {
    private List<ISeries> multipleSeries = new ArrayList<ISeries>();

    @Override
    public void add(ISeries series) {
        this.multipleSeries.add(series);
    }

    @Override
    public List<ISeries> getMultipleSeries() {
        return this.multipleSeries;
    }

    @Override
    public void remove(ISeries series) {
        this.multipleSeries.remove(series);
    }

    @Override
    public void remove(int index) {
        this.multipleSeries.remove(index);
    }

    @Override
    public void removeAll() {
        this.multipleSeries.clear();
    }

    @Override
    public double getXMax() {
        if (this.multipleSeries.size() == 0) {
            return 0.0;
        }
        double[] xMaxValues = new double[this.multipleSeries.size()];
        int i = 0;
        for (ISeries series : this.multipleSeries) {
            xMaxValues[i++] = series.getXMax();
        }
        return Calculations.getMax((double[])xMaxValues);
    }

    @Override
    public double getXMin() {
        if (this.multipleSeries.size() == 0) {
            return 0.0;
        }
        double[] xMinValues = new double[this.multipleSeries.size()];
        int i = 0;
        for (ISeries series : this.multipleSeries) {
            xMinValues[i++] = series.getXMin();
        }
        return Calculations.getMin((double[])xMinValues);
    }

    @Override
    public double getYMax() {
        if (this.multipleSeries.size() == 0) {
            return 0.0;
        }
        double[] yMaxValues = new double[this.multipleSeries.size()];
        int i = 0;
        for (ISeries series : this.multipleSeries) {
            yMaxValues[i++] = series.getYMax();
        }
        return Calculations.getMax((double[])yMaxValues);
    }

    @Override
    public double getYMin() {
        if (this.multipleSeries.size() == 0) {
            return 0.0;
        }
        double[] yMinValues = new double[this.multipleSeries.size()];
        int i = 0;
        for (ISeries series : this.multipleSeries) {
            yMinValues[i++] = series.getYMin();
        }
        return Calculations.getMin((double[])yMinValues);
    }
}

