/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.Activator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.settings.IBackfoldingSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.backfolding.settings.SupplierFilterSettings;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_BACKFOLDING_RUNS = "backfoldingRuns";
    public static final String P_MAX_RETENTION_TIME_SHIFT = "maxRetentionTimeShift";
    public static final int MIN_BACKFOLDING_RUNS = 1;
    public static final int MAX_BACKFOLDING_RUNS = 10;
    public static final int DEF_BACKFOLDING_RUNS = 3;
    public static final int MIN_RETENTION_TIME_SHIFT = 500;
    public static final int MAX_RETENTION_TIME_SHIFT = 25000;
    public static final int DEF_RETENTION_TIME_SHIFT = 5000;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_BACKFOLDING_RUNS, Integer.toString(3));
        defaultValues.put(P_MAX_RETENTION_TIME_SHIFT, Integer.toString(5000));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static IChromatogramFilterSettings getChromatogramFilterSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        SupplierFilterSettings chromatogramFilterSettings = new SupplierFilterSettings();
        IBackfoldingSettings backfoldingSettings = chromatogramFilterSettings.getBackfoldingSettings();
        backfoldingSettings.setMaximumRetentionTimeShift(preferences.getInt(P_MAX_RETENTION_TIME_SHIFT, 5000));
        backfoldingSettings.setNumberOfBackfoldingRuns(preferences.getInt(P_BACKFOLDING_RUNS, 3));
        return chromatogramFilterSettings;
    }

    public static int getMaxRetentionTimeShift() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_MAX_RETENTION_TIME_SHIFT, 5000);
    }

    public static int getBackfoldingRuns() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_BACKFOLDING_RUNS, 3);
    }
}

